//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
use objc2_core_graphics::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/ctframesetter?language=objc)
#[doc(alias = "CTFramesetterRef")]
#[repr(C)]
pub struct CTFramesetter {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CTFramesetter {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CTFramesetter"> for CTFramesetter {}
);

unsafe impl ConcreteType for CTFramesetter {
    /// Returns the CFType of the framesetter object
    #[doc(alias = "CTFramesetterGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CTFramesetterGetTypeID() -> CFTypeID;
        }
        unsafe { CTFramesetterGetTypeID() }
    }
}

impl CTFramesetter {
    /// Creates a framesetter directly from a typesetter.
    ///
    ///
    /// Each framesetter uses a typesetter internally to perform
    /// line breaking and other contextual analysis based on the
    /// characters in a string. This function allows use of a
    /// typesetter that was constructed using specific options.
    ///
    ///
    /// Parameter `typesetter`: The typesetter to be used by the newly-created framesetter.
    ///
    ///
    /// Returns: This function will return a reference to a CTFramesetter object.
    ///
    ///
    /// See also: CTTypesetterCreateWithAttributedStringAndOptions
    #[doc(alias = "CTFramesetterCreateWithTypesetter")]
    #[cfg(feature = "CTTypesetter")]
    #[inline]
    pub unsafe fn with_typesetter(typesetter: &CTTypesetter) -> CFRetained<CTFramesetter> {
        extern "C-unwind" {
            fn CTFramesetterCreateWithTypesetter(
                typesetter: &CTTypesetter,
            ) -> Option<NonNull<CTFramesetter>>;
        }
        let ret = unsafe { CTFramesetterCreateWithTypesetter(typesetter) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Creates an immutable framesetter object from an attributed
    /// string.
    ///
    ///
    /// The resultant framesetter object can be used to create and
    /// fill text frames with the CTFramesetterCreateFrame call.
    ///
    ///
    /// Parameter `attrString`: The attributed string to construct the framesetter with.
    ///
    ///
    /// Returns: This function will return a reference to a CTFramesetter object.
    #[doc(alias = "CTFramesetterCreateWithAttributedString")]
    #[inline]
    pub unsafe fn with_attributed_string(
        attr_string: &CFAttributedString,
    ) -> CFRetained<CTFramesetter> {
        extern "C-unwind" {
            fn CTFramesetterCreateWithAttributedString(
                attr_string: &CFAttributedString,
            ) -> Option<NonNull<CTFramesetter>>;
        }
        let ret = unsafe { CTFramesetterCreateWithAttributedString(attr_string) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Creates an immutable frame from a framesetter.
    ///
    ///
    /// This call will create a frame full of glyphs in the shape of
    /// the path provided by the "path" parameter. The framesetter
    /// will continue to fill the frame until it either runs out of
    /// text or it finds that text no longer fits.
    ///
    ///
    /// Parameter `framesetter`: The framesetter that will be used to create the frame.
    ///
    ///
    /// Parameter `stringRange`: The string range which the new frame will be based on. The
    /// string range is a range over the string that was used to
    /// create the framesetter. If the length portion of the range
    /// is set to 0, then the framesetter will continue to add lines
    /// until it runs out of text or space.
    ///
    ///
    /// Parameter `path`: A CGPath object that specifies the shape which the frame will
    /// take on.
    ///
    ///
    /// Parameter `frameAttributes`: Additional attributes that control the frame filling process
    /// can be specified here, or NULL if there are no such attributes.
    /// See CTFrame.h for available attributes.
    ///
    ///
    /// Returns: This function will return a reference to a new CTFrame object.
    ///
    /// # Safety
    ///
    /// `frame_attributes` generics must be of the correct type.
    #[doc(alias = "CTFramesetterCreateFrame")]
    #[cfg(all(feature = "CTFrame", feature = "objc2-core-graphics"))]
    #[inline]
    pub unsafe fn frame(
        &self,
        string_range: CFRange,
        path: &CGPath,
        frame_attributes: Option<&CFDictionary>,
    ) -> CFRetained<CTFrame> {
        extern "C-unwind" {
            fn CTFramesetterCreateFrame(
                framesetter: &CTFramesetter,
                string_range: CFRange,
                path: &CGPath,
                frame_attributes: Option<&CFDictionary>,
            ) -> Option<NonNull<CTFrame>>;
        }
        let ret = unsafe { CTFramesetterCreateFrame(self, string_range, path, frame_attributes) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns the typesetter object being used by the framesetter.
    ///
    ///
    /// Each framesetter uses a typesetter internally to perform
    /// line breaking and other contextual analysis based on the
    /// characters in a string; this function returns the typesetter
    /// being used by a particular framesetter if the caller would
    /// like to perform other operations on that typesetter.
    ///
    ///
    /// Parameter `framesetter`: The framesetter from which a typesetter is being requested.
    ///
    ///
    /// Returns: This function will return a reference to a CTTypesetter
    /// object, which should not be released by the caller.
    #[doc(alias = "CTFramesetterGetTypesetter")]
    #[cfg(feature = "CTTypesetter")]
    #[inline]
    pub unsafe fn typesetter(&self) -> CFRetained<CTTypesetter> {
        extern "C-unwind" {
            fn CTFramesetterGetTypesetter(
                framesetter: &CTFramesetter,
            ) -> Option<NonNull<CTTypesetter>>;
        }
        let ret = unsafe { CTFramesetterGetTypesetter(self) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::retain(ret) }
    }

    /// Determines the frame size needed for a string range.
    ///
    ///
    /// This function may be used to determine how much space is needed
    /// to display a string, optionally by constraining the space along
    /// either dimension.
    ///
    ///
    /// Parameter `framesetter`: The framesetter that will be used for measuring the frame size.
    ///
    ///
    /// Parameter `stringRange`: The string range to which the frame size will apply. The
    /// string range is a range over the string that was used to
    /// create the framesetter. If the length portion of the range
    /// is set to 0, then the framesetter will continue to add lines
    /// until it runs out of text or space.
    ///
    ///
    /// Parameter `frameAttributes`: Additional attributes that control the frame filling process
    /// can be specified here, or NULL if there are no such attributes.
    ///
    ///
    /// Parameter `constraints`: The width and height to which the frame size will be constrained,
    /// A value of CGFLOAT_MAX for either dimension indicates that it
    /// should be treated as unconstrained.
    ///
    ///
    /// Parameter `fitRange`: The range of the string that actually fit in the constrained size.
    ///
    ///
    /// Returns: The actual dimensions for the given string range and constraints.
    ///
    /// # Safety
    ///
    /// - `frame_attributes` generics must be of the correct type.
    /// - `fit_range` must be a valid pointer or null.
    #[doc(alias = "CTFramesetterSuggestFrameSizeWithConstraints")]
    #[inline]
    pub unsafe fn suggest_frame_size_with_constraints(
        &self,
        string_range: CFRange,
        frame_attributes: Option<&CFDictionary>,
        constraints: CGSize,
        fit_range: *mut CFRange,
    ) -> CGSize {
        extern "C-unwind" {
            fn CTFramesetterSuggestFrameSizeWithConstraints(
                framesetter: &CTFramesetter,
                string_range: CFRange,
                frame_attributes: Option<&CFDictionary>,
                constraints: CGSize,
                fit_range: *mut CFRange,
            ) -> CGSize;
        }
        unsafe {
            CTFramesetterSuggestFrameSizeWithConstraints(
                self,
                string_range,
                frame_attributes,
                constraints,
                fit_range,
            )
        }
    }
}

#[cfg(feature = "CTTypesetter")]
#[deprecated = "renamed to `CTFramesetter::with_typesetter`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFramesetterCreateWithTypesetter(
    typesetter: &CTTypesetter,
) -> CFRetained<CTFramesetter> {
    extern "C-unwind" {
        fn CTFramesetterCreateWithTypesetter(
            typesetter: &CTTypesetter,
        ) -> Option<NonNull<CTFramesetter>>;
    }
    let ret = unsafe { CTFramesetterCreateWithTypesetter(typesetter) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFramesetter::with_attributed_string`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFramesetterCreateWithAttributedString(
    attr_string: &CFAttributedString,
) -> CFRetained<CTFramesetter> {
    extern "C-unwind" {
        fn CTFramesetterCreateWithAttributedString(
            attr_string: &CFAttributedString,
        ) -> Option<NonNull<CTFramesetter>>;
    }
    let ret = unsafe { CTFramesetterCreateWithAttributedString(attr_string) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[cfg(all(feature = "CTFrame", feature = "objc2-core-graphics"))]
#[deprecated = "renamed to `CTFramesetter::frame`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFramesetterCreateFrame(
    framesetter: &CTFramesetter,
    string_range: CFRange,
    path: &CGPath,
    frame_attributes: Option<&CFDictionary>,
) -> CFRetained<CTFrame> {
    extern "C-unwind" {
        fn CTFramesetterCreateFrame(
            framesetter: &CTFramesetter,
            string_range: CFRange,
            path: &CGPath,
            frame_attributes: Option<&CFDictionary>,
        ) -> Option<NonNull<CTFrame>>;
    }
    let ret =
        unsafe { CTFramesetterCreateFrame(framesetter, string_range, path, frame_attributes) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[cfg(feature = "CTTypesetter")]
#[deprecated = "renamed to `CTFramesetter::typesetter`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFramesetterGetTypesetter(
    framesetter: &CTFramesetter,
) -> CFRetained<CTTypesetter> {
    extern "C-unwind" {
        fn CTFramesetterGetTypesetter(framesetter: &CTFramesetter)
            -> Option<NonNull<CTTypesetter>>;
    }
    let ret = unsafe { CTFramesetterGetTypesetter(framesetter) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::retain(ret) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTFramesetter::suggest_frame_size_with_constraints`"]
    pub fn CTFramesetterSuggestFrameSizeWithConstraints(
        framesetter: &CTFramesetter,
        string_range: CFRange,
        frame_attributes: Option<&CFDictionary>,
        constraints: CGSize,
        fit_range: *mut CFRange,
    ) -> CGSize;
}
