/*
 * Decompiled with CFR 0.152.
 */
package proguard.util.kotlin.asserter;

import java.util.Arrays;
import java.util.Objects;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.kotlin.KotlinConstants;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.kotlin.asserter.Reporter;

public class AssertUtil {
    private String parentElement;
    private final Reporter reporter;
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;

    public AssertUtil(String parentElement, Reporter reporter, ClassPool programClassPool, ClassPool libraryClassPool) {
        this.parentElement = parentElement;
        this.reporter = reporter;
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
    }

    public void setParentElement(String parentElement) {
        this.parentElement = parentElement;
    }

    public void reportIfNull(String checkedElementName, Object ... checkedElement) {
        if (Arrays.stream(checkedElement).allMatch(Objects::isNull)) {
            this.reporter.report(this.parentElement + " has no " + checkedElementName + ".");
        }
    }

    public void reportIfNullReference(String checkedElementName, Object checkedElement) {
        if (checkedElement == null) {
            this.reporter.report(this.parentElement + " has no reference for its " + checkedElementName + ".");
        }
    }

    public void reportIfClassDangling(String checkedElementName, Clazz clazz) {
        if (!(clazz == null || this.programClassPool.contains(clazz) || this.libraryClassPool.contains(clazz) || KotlinConstants.dummyClassPool.contains(clazz))) {
            this.reporter.report(this.parentElement + " has dangling class reference for its " + checkedElementName + ".");
        }
    }

    public void reportIfFieldDangling(String checkedElementName, Clazz checkedClass, Field field) {
        if (checkedClass != null && field != null) {
            ExactMemberMatcher match = new ExactMemberMatcher(field);
            checkedClass.accept(new AllFieldVisitor(match));
            if (!match.memberMatched) {
                this.reporter.report(this.parentElement + " has a dangling reference for its " + checkedElementName + ".");
            }
        }
    }

    public void reportIfMethodDangling(String checkedElementName, Clazz checkedClass, Method method) {
        if (checkedClass != null && method != null) {
            ExactMemberMatcher match = new ExactMemberMatcher(method);
            checkedClass.accept(new AllMethodVisitor(match));
            if (!match.memberMatched) {
                this.reporter.report(this.parentElement + " has a dangling reference for its " + checkedElementName + ".");
            }
        }
    }

    private static class ExactMemberMatcher
    implements MemberVisitor {
        private final Member memberToMatch;
        boolean memberMatched;

        ExactMemberMatcher(Member memberToMatch) {
            this.memberToMatch = memberToMatch;
        }

        @Override
        public void visitAnyMember(Clazz clazz, Member member) {
            if (member == this.memberToMatch) {
                this.memberMatched = true;
            }
        }
    }
}

