/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramMethod;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.ReferenceTracingInvocationUnit;
import proguard.evaluation.SimplifiedInvocationUnit;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TracedReferenceValue;
import proguard.evaluation.value.Value;
import proguard.optimize.info.ParameterEscapeMarker;

public class ParameterTracingInvocationUnit
extends ReferenceTracingInvocationUnit {
    private static final Logger logger = LogManager.getLogger(ParameterTracingInvocationUnit.class);
    private Value[] parameters = new Value[256];

    public ParameterTracingInvocationUnit(SimplifiedInvocationUnit invocationUnit) {
        super(invocationUnit);
    }

    @Override
    public void setMethodParameterValue(Clazz clazz, AnyMethodrefConstant refConstant, int parameterIndex, Value value) {
        super.setMethodParameterValue(clazz, refConstant, parameterIndex, value);
        this.parameters[parameterIndex] = value;
    }

    @Override
    public Value getMethodReturnValue(Clazz clazz, AnyMethodrefConstant refConstant, String type) {
        Value returnValue = super.getMethodReturnValue(clazz, refConstant, type);
        if (returnValue.computationalType() != 5) {
            return returnValue;
        }
        Method referencedMethod = refConstant.referencedMethod;
        if (referencedMethod != null) {
            int offset = ((TracedReferenceValue)returnValue).getTraceValue().instructionOffsetValue().instructionOffset(0);
            InstructionOffsetValue traceValue = ParameterEscapeMarker.returnsExternalValues(referencedMethod) ? new InstructionOffsetValue(offset | 0x4000000) : (ParameterEscapeMarker.returnsNewInstances(referencedMethod) ? new InstructionOffsetValue(offset | 0x8000000) : null);
            long returnedParameters = ParameterEscapeMarker.getReturnedParameters(referencedMethod);
            int parameterCount = ClassUtil.internalMethodParameterCount(refConstant.getType(clazz), this.isStatic);
            for (int parameterIndex = 0; parameterIndex < parameterCount; ++parameterIndex) {
                TracedReferenceValue tracedParameterValue;
                Value parameterValue;
                if ((returnedParameters & 1L << parameterIndex) == 0L || !((parameterValue = this.parameters[parameterIndex]) instanceof TracedReferenceValue) || !this.mayReturnType(refConstant.referencedClass, referencedMethod, tracedParameterValue = (TracedReferenceValue)parameterValue)) continue;
                InstructionOffsetValue parameterTraceValue = tracedParameterValue.getTraceValue().instructionOffsetValue();
                traceValue = traceValue == null ? parameterTraceValue : traceValue.generalize(parameterTraceValue);
            }
            logger.debug("ParameterTracingInvocationUnit.getMethodReturnValue: calling [{}.{}{}  ] returns [{} {}]", (Object)refConstant.getClassName(clazz), (Object)refConstant.getName(clazz), (Object)refConstant.getType(clazz), (Object)traceValue, (Object)returnValue);
            if (traceValue != null) {
                return this.trace(returnValue, traceValue);
            }
        }
        return returnValue;
    }

    private boolean mayReturnType(Clazz clazz, Method method, ReferenceValue referenceValue) {
        String returnType = ClassUtil.internalMethodReturnType(method.getDescriptor(clazz));
        Clazz[] referencedClasses = method instanceof ProgramMethod ? ((ProgramMethod)method).referencedClasses : ((LibraryMethod)method).referencedClasses;
        Clazz referencedClass = referencedClasses == null || !ClassUtil.isInternalClassType(returnType) ? null : referencedClasses[referencedClasses.length - 1];
        return referenceValue.instanceOf(returnType, referencedClass) != -1;
    }
}

