/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.obfuscate.MappingProcessor;

public class MappingTargetClassNameCollector
implements MappingProcessor {
    private final WarningPrinter warningPrinter;
    private final Map classNameMapping = new LinkedHashMap();

    public MappingTargetClassNameCollector(WarningPrinter warningPrinter) {
        this.warningPrinter = warningPrinter;
    }

    @Override
    public boolean processClassMapping(String className, String newClassName) {
        String internalNewClassName = ClassUtil.internalClassName(newClassName);
        String otherClassName = this.classNameMapping.put(internalNewClassName, className);
        if (otherClassName != null && !className.equals(otherClassName)) {
            throw new RuntimeException("Duplicate target '" + newClassName + "' for two different classes: '" + className + "' and '" + otherClassName + "'.");
        }
        return false;
    }

    @Override
    public void processFieldMapping(String className, String fieldType, String fieldName, String newClassName, String newFieldName) {
    }

    @Override
    public void processMethodMapping(String className, int firstLineNumber, int lastLineNumber, String methodReturnType, String methodName, String methodArguments, String newClassName, int newFirstLineNumber, int newLastLineNumber, String newMethodName) {
    }

    public Set getReservedClassNames() {
        return this.classNameMapping.keySet();
    }
}

