/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import java.util.Objects;
import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.evaluation.value.IdentifiedReferenceValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.ValueFactory;

public class ParticularReferenceValue
extends IdentifiedReferenceValue {
    private final Object value;

    public ParticularReferenceValue(String type, Clazz referencedClass, ValueFactory valueFactory, int referenceID, Object value) {
        super(type, referencedClass, false, true, valueFactory, referenceID);
        boolean isExtended;
        this.value = value;
        ClassCounter counter = new ClassCounter();
        if (value != null && referencedClass != null) {
            referencedClass.hierarchyAccept(true, false, false, true, new ClassNameFilter(ClassUtil.internalClassName(ClassUtil.externalBaseType(value.getClass().getCanonicalName())), (ClassVisitor)counter));
        }
        boolean bl = isExtended = counter.getCount() > 0;
        if (value != null && (referencedClass != null && !isExtended || referencedClass == null && !type.equals(ClassUtil.internalType(value.getClass().getCanonicalName())))) {
            throw new RuntimeException("Type does not match or is not extended by type of the value (" + ClassUtil.internalType(value.getClass().getCanonicalName()) + " - " + type + ")");
        }
        if (type == null) {
            throw new RuntimeException("Type must not be null");
        }
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public boolean isParticular() {
        return true;
    }

    @Override
    public int isNull() {
        return this.value == null ? 1 : -1;
    }

    @Override
    public int instanceOf(String otherType, Clazz otherReferencedClass) {
        if (this.referencedClass == null || otherReferencedClass == null) {
            return 0;
        }
        if (this.referencedClass.extendsOrImplements(otherReferencedClass)) {
            return 1;
        }
        if ((this.referencedClass.getAccessFlags() & 0x10) != 0) {
            return -1;
        }
        if ((this.referencedClass.getAccessFlags() & 0x200) == 0 && (otherReferencedClass.getAccessFlags() & 0x200) == 0 && !otherReferencedClass.extendsOrImplements(this.referencedClass)) {
            return -1;
        }
        return 0;
    }

    @Override
    public ReferenceValue cast(String type, Clazz referencedClass, ValueFactory valueFactory, boolean alwaysCast) {
        if (!(alwaysCast || this.type != null && this.instanceOf(type, referencedClass) != 1)) {
            return this;
        }
        if (this.type != null && this.type.equals(type)) {
            return this;
        }
        if (this.instanceOf(type, referencedClass) == 1) {
            return valueFactory.createReferenceValue(type, referencedClass, true, true, this.value);
        }
        return valueFactory.createReferenceValue(type, referencedClass, true, true);
    }

    @Override
    public ReferenceValue generalize(ReferenceValue other) {
        return other.generalize(this);
    }

    @Override
    public ReferenceValue generalize(ParticularReferenceValue other) {
        if (this.equal(other) == 1) {
            return other;
        }
        return super.generalize((IdentifiedReferenceValue)other);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() ^ (this.value == null ? 1 : this.value.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && object instanceof ParticularReferenceValue && Objects.equals(this.value, ((ParticularReferenceValue)object).value);
    }

    @Override
    public int equal(ReferenceValue other) {
        if (this == other) {
            return 1;
        }
        if (super.equal(other) == -1) {
            return -1;
        }
        if (this.getClass() != other.getClass()) {
            return 0;
        }
        if (this.value == null && other.value() == null || this.value != null && this.value.equals(other.value())) {
            return 1;
        }
        return -1;
    }

    @Override
    public String toString() {
        return super.toString() + "(" + (this.value == null ? "null" : this.value.toString()) + ")";
    }
}

