/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.cfa.visitors;

import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.analysis.cpa.defaults.Cfa;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.edges.JvmAssumeCaseCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmAssumeCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmAssumeDefaultCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmAssumeExceptionCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmInstructionCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCatchCfaNode;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmUnknownCfaNode;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class JvmIntraproceduralCfaFillerAllInstructionVisitor
implements AttributeVisitor {
    private final Cfa<JvmCfaNode, JvmCfaEdge, MethodSignature> cfa;
    private static final Logger log = LogManager.getLogger(JvmIntraproceduralCfaFillerAllInstructionVisitor.class);

    public JvmIntraproceduralCfaFillerAllInstructionVisitor(JvmCfa cfa) {
        this.cfa = cfa;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        MethodSignature signature = MethodSignature.computeIfAbsent(clazz, method);
        this.generateCatchNodes(signature, codeAttribute, clazz);
        JvmIntraproceduralCfaFillerVisitor instructionVisitor = new JvmIntraproceduralCfaFillerVisitor((JvmCfa)this.cfa);
        instructionVisitor.setSignature(signature);
        codeAttribute.instructionsAccept(clazz, method, instructionVisitor);
    }

    private void generateCatchNodes(MethodSignature signature, CodeAttribute codeAttribute, Clazz clazz) {
        if (codeAttribute.exceptionTable != null) {
            LinkedHashSet handlersOffset = new LinkedHashSet(Arrays.stream(codeAttribute.exceptionTable).map(x -> x.u2handlerPC).collect(Collectors.toList()));
            Iterator iterator2 = handlersOffset.iterator();
            while (iterator2.hasNext()) {
                int handlerOffset = (Integer)iterator2.next();
                JvmCatchCfaNode catchNode = new JvmCatchCfaNode(signature, handlerOffset, Arrays.stream(codeAttribute.exceptionTable).filter((Predicate<ExceptionInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$generateCatchNodes$1(int proguard.classfile.attribute.ExceptionInfo ), (Lproguard/classfile/attribute/ExceptionInfo;)Z)((int)handlerOffset)).findFirst().get().u2catchType, clazz);
                ((JvmCfa)this.cfa).addFunctionCatchNode(signature, catchNode, handlerOffset);
                new JvmAssumeExceptionCfaEdge(catchNode, ((JvmCfa)this.cfa).addNodeIfAbsent(signature, handlerOffset, clazz), true, catchNode.getCatchType());
            }
            iterator2 = handlersOffset.iterator();
            block1: while (iterator2.hasNext()) {
                int currHandlerOffset = (Integer)iterator2.next();
                Set handledBlocks = Arrays.stream(codeAttribute.exceptionTable).filter(e -> e.u2handlerPC == currHandlerOffset).collect(Collectors.toSet());
                for (ExceptionInfo currBlock : handledBlocks) {
                    int pos = Arrays.asList(codeAttribute.exceptionTable).indexOf(currBlock);
                    Optional<ExceptionInfo> followingCatch = Arrays.stream(codeAttribute.exceptionTable).skip(pos + 1).filter(e -> e.u2startPC <= currBlock.u2startPC && e.u2endPC >= currBlock.u2endPC).findFirst();
                    if (!followingCatch.isPresent()) continue;
                    JvmCatchCfaNode currNode = ((JvmCfa)this.cfa).getFunctionCatchNode(signature, currHandlerOffset);
                    JvmCatchCfaNode nextNode = ((JvmCfa)this.cfa).getFunctionCatchNode(signature, followingCatch.get().u2handlerPC);
                    new JvmAssumeExceptionCfaEdge(currNode, nextNode, false, currNode.getCatchType());
                    continue block1;
                }
            }
        }
        for (JvmCatchCfaNode node : ((JvmCfa)this.cfa).getFunctionCatchNodes(signature)) {
            if (node.getLeavingEdges().size() != 1 || node.getCatchType() == 0) continue;
            JvmCfaNode exitNode = ((JvmCfa)this.cfa).getFunctionExceptionExitNode(signature, clazz);
            new JvmAssumeExceptionCfaEdge(node, exitNode, false, node.getCatchType());
        }
    }

    private static /* synthetic */ boolean lambda$generateCatchNodes$1(int handlerOffset, ExceptionInfo e) {
        return e.u2handlerPC == handlerOffset;
    }

    private class JvmIntraproceduralCfaFillerVisitor
    implements InstructionVisitor {
        private final Cfa<JvmCfaNode, JvmCfaEdge, MethodSignature> cfa;
        private MethodSignature signature;
        private JvmCfaEdge previousEdge;

        public JvmIntraproceduralCfaFillerVisitor(JvmCfa cfa) {
            this.cfa = cfa;
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            switch (simpleInstruction.opcode) {
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: 
                case -79: {
                    this.connectReturn(offset, clazz, codeAttribute);
                    break;
                }
                case -65: {
                    this.connectThrow(offset, clazz, codeAttribute);
                    break;
                }
                default: {
                    this.connectStatement(offset, clazz, codeAttribute);
                }
            }
        }

        @Override
        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            switch (variableInstruction.opcode) {
                case -87: {
                    this.connectRet(offset, clazz, codeAttribute);
                    break;
                }
                default: {
                    this.connectStatement(offset, clazz, codeAttribute);
                }
            }
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            this.connectStatement(offset, clazz, codeAttribute);
        }

        @Override
        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            switch (branchInstruction.opcode) {
                case -89: 
                case -88: 
                case -56: 
                case -55: {
                    this.connectGoto(offset, clazz, codeAttribute, branchInstruction);
                    break;
                }
                default: {
                    this.connectBranch(offset, clazz, codeAttribute, branchInstruction);
                }
            }
        }

        @Override
        public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction tableSwitchInstruction) {
            try {
                this.connectSwitch(offset, clazz, codeAttribute, tableSwitchInstruction);
            }
            catch (IllegalArgumentException e) {
                log.error("Unknown switch instruction", (Throwable)e);
            }
        }

        public void setSignature(MethodSignature signature) {
            this.signature = signature;
        }

        private JvmCfaNode connect(int offset, Clazz clazz) {
            JvmCfaNode currentNode = ((JvmCfa)this.cfa).addNodeIfAbsent(this.signature, offset, clazz);
            if (this.previousEdge != null) {
                this.previousEdge.setTarget(currentNode);
            }
            return currentNode;
        }

        private void connectStatement(int offset, Clazz clazz, CodeAttribute methodCode) {
            JvmCfaNode currentNode = this.connect(offset, clazz);
            this.previousEdge = new JvmInstructionCfaEdge(methodCode, offset);
            this.previousEdge.setSource(currentNode);
        }

        private void connectReturn(int offset, Clazz clazz, CodeAttribute methodCode) {
            JvmCfaNode currentNode = this.connect(offset, clazz);
            this.previousEdge = null;
            JvmCfaNode exitNode = ((JvmCfa)this.cfa).getFunctionReturnExitNode(this.signature, clazz);
            new JvmInstructionCfaEdge(currentNode, exitNode, methodCode, offset);
        }

        private void connectRet(int offset, Clazz clazz, CodeAttribute methodCode) {
            JvmCfaNode currentNode = this.connect(offset, clazz);
            this.previousEdge = null;
            new JvmInstructionCfaEdge(currentNode, JvmUnknownCfaNode.INSTANCE, methodCode, offset);
        }

        private void connectGoto(int offset, Clazz clazz, CodeAttribute methodCode, BranchInstruction instruction) {
            JvmCfaNode currentNode = this.connect(offset, clazz);
            this.previousEdge = null;
            int branchTarget = offset + instruction.branchOffset;
            JvmCfaNode jumpNode = ((JvmCfa)this.cfa).addNodeIfAbsent(this.signature, branchTarget, clazz);
            new JvmInstructionCfaEdge(currentNode, jumpNode, methodCode, offset);
        }

        private void connectBranch(int offset, Clazz clazz, CodeAttribute methodCode, BranchInstruction instruction) {
            JvmCfaNode currentNode = this.connect(offset, clazz);
            this.previousEdge = new JvmAssumeCfaEdge(methodCode, offset, false);
            this.previousEdge.setSource(currentNode);
            int branchTarget = offset + instruction.branchOffset;
            JvmCfaNode jumpNode = ((JvmCfa)this.cfa).addNodeIfAbsent(this.signature, branchTarget, clazz);
            new JvmAssumeCfaEdge(currentNode, jumpNode, methodCode, offset, true);
        }

        private void connectSwitch(int offset, Clazz clazz, CodeAttribute methodCode, SwitchInstruction instruction) throws IllegalArgumentException {
            if (!(instruction instanceof TableSwitchInstruction) && !(instruction instanceof LookUpSwitchInstruction)) {
                throw new IllegalArgumentException("Unexpected switch instruction type");
            }
            JvmCfaNode currentNode = this.connect(offset, clazz);
            this.previousEdge = null;
            int branchTarget = offset + instruction.defaultOffset;
            JvmCfaNode jumpNode = ((JvmCfa)this.cfa).addNodeIfAbsent(this.signature, branchTarget, clazz);
            new JvmAssumeDefaultCfaEdge(currentNode, jumpNode, methodCode, offset);
            for (int index = 0; index < instruction.jumpOffsets.length; ++index) {
                branchTarget = offset + instruction.jumpOffsets[index];
                int caseAssumption = instruction instanceof TableSwitchInstruction ? ((TableSwitchInstruction)instruction).lowCase + index : ((LookUpSwitchInstruction)instruction).cases[index];
                jumpNode = ((JvmCfa)this.cfa).addNodeIfAbsent(this.signature, branchTarget, clazz);
                new JvmAssumeCaseCfaEdge(currentNode, jumpNode, methodCode, offset, caseAssumption);
            }
        }

        private void connectThrow(int offset, Clazz clazz, CodeAttribute methodCode) {
            JvmCfaNode currentNode = this.connect(offset, clazz);
            this.previousEdge = null;
            Optional<Object> firstCatch = Optional.empty();
            if (methodCode.exceptionTable != null) {
                firstCatch = Arrays.stream(methodCode.exceptionTable).filter(e -> e.isApplicable(offset)).findFirst();
            }
            if (firstCatch.isPresent()) {
                new JvmInstructionCfaEdge(currentNode, ((JvmCfa)this.cfa).getFunctionCatchNode(this.signature, ((ExceptionInfo)firstCatch.get()).u2handlerPC), methodCode, offset);
            } else {
                JvmCfaNode exitNode = ((JvmCfa)this.cfa).getFunctionExceptionExitNode(this.signature, clazz);
                new JvmInstructionCfaEdge(currentNode, exitNode, methodCode, offset);
            }
        }
    }
}

