/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;

public class DuplicateClassPrinter
implements ClassVisitor {
    private final WarningPrinter notePrinter;

    public DuplicateClassPrinter(WarningPrinter notePrinter) {
        this.notePrinter = notePrinter;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.notePrinter.print(programClass.getName(), "Note: duplicate definition of program class [" + ClassUtil.externalClassName(programClass.getName()) + "]");
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        this.notePrinter.print(libraryClass.getName(), "Note: duplicate definition of library class [" + ClassUtil.externalClassName(libraryClass.getName()) + "]");
    }
}

