/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationDependenciesBuildOperationType;
import org.gradle.api.internal.artifacts.result.DefaultResolvedComponentResult;
import org.gradle.api.internal.artifacts.result.ResolvedComponentResultInternal;
import org.gradle.api.internal.attributes.AbstractAttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Actions;
import org.gradle.internal.operations.trace.CustomOperationTraceSerialization;
import org.jspecify.annotations.Nullable;

class ResolveConfigurationResolutionBuildOperationResult
implements ResolveConfigurationDependenciesBuildOperationType.Result,
CustomOperationTraceSerialization {
    private final Supplier<? extends ResolvedComponentResult> rootSource;
    private final AttributeContainer requestedAttributes;

    public ResolveConfigurationResolutionBuildOperationResult(Supplier<? extends ResolvedComponentResult> rootSource, ImmutableAttributes requestedAttributes, AttributesFactory attributesFactory) {
        this.rootSource = rootSource;
        this.requestedAttributes = new LazyDesugaringAttributeContainer((AttributeContainer)requestedAttributes, attributesFactory);
    }

    public ResolvedComponentResult getRootComponent() {
        return this.rootSource.get();
    }

    public String getRepositoryId(ResolvedComponentResult resolvedComponentResult) {
        return ((ResolvedComponentResultInternal)resolvedComponentResult).getRepositoryId();
    }

    public Object getCustomOperationTraceSerializableModel() {
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("resolvedDependenciesCount", Integer.valueOf(this.getRootComponent().getDependencies().size()));
        HashMap components = new HashMap();
        DefaultResolvedComponentResult.eachElement(this.rootSource.get(), (Action<? super ResolvedComponentResult>)((Action)component -> components.put(component.getId().getDisplayName(), Collections.singletonMap("repoId", this.getRepositoryId((ResolvedComponentResult)component)))), (Action<? super DependencyResult>)Actions.doNothing(), new HashSet<ResolvedComponentResult>());
        model.put("components", components);
        ImmutableList.Builder requestedAttributesBuilder = new ImmutableList.Builder();
        for (Attribute att : this.requestedAttributes.keySet()) {
            requestedAttributesBuilder.add((Object)ImmutableMap.of((Object)"name", (Object)att.getName(), (Object)"value", (Object)this.requestedAttributes.getAttribute(att).toString()));
        }
        model.put("requestedAttributes", (Serializable)requestedAttributesBuilder.build());
        return model;
    }

    public AttributeContainer getRequestedAttributes() {
        return this.requestedAttributes;
    }

    private static final class LazyDesugaringAttributeContainer
    extends AbstractAttributeContainer
    implements ImmutableAttributes {
        private final AttributeContainer source;
        private final AttributesFactory attributesFactory;
        private ImmutableAttributes desugared;

        private LazyDesugaringAttributeContainer(@Nullable AttributeContainer source, AttributesFactory attributesFactory) {
            this.source = source;
            this.attributesFactory = attributesFactory;
        }

        public ImmutableSet<Attribute<?>> keySet() {
            return this.getDesugared().keySet();
        }

        @Deprecated
        public <T> AttributeContainer attribute(Attribute<T> key, T value) {
            return this.getDesugared().attribute(key, value);
        }

        @Deprecated
        public <T> AttributeContainer attributeProvider(Attribute<T> key, Provider<? extends T> provider) {
            return this.getDesugared().attributeProvider(key, provider);
        }

        public <T> @Nullable T getAttribute(Attribute<T> key) {
            if (!this.isValidAttributeRequest(key)) {
                return null;
            }
            return (T)this.getDesugared().getAttribute(key);
        }

        public boolean isEmpty() {
            return this.getDesugared().isEmpty();
        }

        public boolean contains(Attribute<?> key) {
            return this.getDesugared().contains(key);
        }

        public AttributeContainer getAttributes() {
            return this.getDesugared().getAttributes();
        }

        public ImmutableAttributes asImmutable() {
            return this.getDesugared();
        }

        public Map<Attribute<?>, ?> asMap() {
            return this.getDesugared().asMap();
        }

        public <T> AttributeValue<T> findEntry(Attribute<T> key) {
            return this.getDesugared().findEntry(key);
        }

        public AttributeValue<?> findEntry(String name) {
            return this.getDesugared().findEntry(name);
        }

        public @Nullable Attribute<?> findAttribute(String name) {
            return this.getDesugared().findAttribute(name);
        }

        public String toString() {
            return this.getDesugared().toString();
        }

        public boolean equals(Object obj) {
            return this.getDesugared().equals(obj);
        }

        public int hashCode() {
            return this.getDesugared().hashCode();
        }

        private ImmutableAttributes getDesugared() {
            if (this.desugared == null) {
                this.desugarAttributes();
            }
            return this.desugared;
        }

        private void desugarAttributes() {
            AttributeContainerInternal result = this.attributesFactory.mutable();
            if (this.source != null) {
                for (Attribute attribute : this.source.keySet()) {
                    String name = attribute.getName();
                    Class type = attribute.getType();
                    Object attributeValue = this.source.getAttribute(attribute);
                    if (type.equals(Boolean.class)) {
                        result.attribute(attribute, (Object)((Boolean)attributeValue));
                        continue;
                    }
                    if (type.equals(String.class)) {
                        result.attribute(attribute, (Object)((String)attributeValue));
                        continue;
                    }
                    if (type.equals(Integer.class)) {
                        result.attribute(attribute, (Object)((Integer)attributeValue));
                        continue;
                    }
                    Attribute stringAtt = Attribute.of((String)name, String.class);
                    String stringValue = attributeValue instanceof Named ? ((Named)attributeValue).getName() : (attributeValue instanceof Object[] ? Arrays.toString((Object[])attributeValue) : attributeValue.toString());
                    result.attribute(stringAtt, (Object)stringValue);
                }
            }
            this.desugared = result.asImmutable();
        }
    }
}

