/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Transformer;
import org.gradle.api.internal.plugins.AppEntryPoint;
import org.gradle.api.internal.plugins.DefaultJavaAppStartScriptGenerationDetails;
import org.gradle.api.internal.plugins.ExecutableJar;
import org.gradle.api.internal.plugins.MainClass;
import org.gradle.api.internal.plugins.MainModule;
import org.gradle.jvm.application.scripts.JavaAppStartScriptGenerationDetails;
import org.gradle.util.internal.CollectionUtils;

public class StartScriptTemplateBindingFactory
implements Transformer<Map<String, String>, JavaAppStartScriptGenerationDetails> {
    private final boolean windows;

    private StartScriptTemplateBindingFactory(boolean windows) {
        this.windows = windows;
    }

    public static StartScriptTemplateBindingFactory windows() {
        return new StartScriptTemplateBindingFactory(true);
    }

    public static StartScriptTemplateBindingFactory unix() {
        return new StartScriptTemplateBindingFactory(false);
    }

    public Map<String, String> transform(JavaAppStartScriptGenerationDetails details) {
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put(ScriptBindingParameter.APP_NAME.getKey(), details.getApplicationName());
        binding.put(ScriptBindingParameter.OPTS_ENV_VAR.getKey(), details.getOptsEnvironmentVar());
        binding.put(ScriptBindingParameter.EXIT_ENV_VAR.getKey(), details.getExitEnvironmentVar());
        AppEntryPoint entryPoint = StartScriptTemplateBindingFactory.getEntryPoint(details);
        String entryPointArgs = this.encodeEntryPoint(entryPoint);
        binding.put(ScriptBindingParameter.ENTRY_POINT_ARGS.getKey(), entryPointArgs);
        binding.put(ScriptBindingParameter.MAIN_CLASS_NAME.getKey(), StartScriptTemplateBindingFactory.getMainClassName(entryPoint, entryPointArgs));
        binding.put(ScriptBindingParameter.MODULE_ENTRY_POINT.getKey(), entryPoint instanceof MainModule ? StartScriptTemplateBindingFactory.getModuleEntryPoint((MainModule)entryPoint) : null);
        binding.put(ScriptBindingParameter.DEFAULT_JVM_OPTS.getKey(), this.createJoinedDefaultJvmOpts(details.getDefaultJvmOpts()));
        binding.put(ScriptBindingParameter.APP_NAME_SYS_PROP.getKey(), details.getAppNameSystemProperty());
        binding.put(ScriptBindingParameter.APP_HOME_REL_PATH.getKey(), this.createJoinedAppHomeRelativePath(details.getScriptRelPath()));
        binding.put(ScriptBindingParameter.CLASSPATH.getKey(), this.createJoinedPath(details.getClasspath()));
        binding.put(ScriptBindingParameter.MODULE_PATH.getKey(), this.createJoinedPath(details.getModulePath()));
        return binding;
    }

    private static String getMainClassName(AppEntryPoint entryPoint, String entryPointArgs) {
        if (entryPoint instanceof MainClass) {
            return ((MainClass)entryPoint).getMainClassName();
        }
        if (entryPoint instanceof MainModule) {
            return entryPointArgs;
        }
        return "";
    }

    private static AppEntryPoint getEntryPoint(JavaAppStartScriptGenerationDetails details) {
        if (details instanceof DefaultJavaAppStartScriptGenerationDetails) {
            return ((DefaultJavaAppStartScriptGenerationDetails)details).getEntryPoint();
        }
        return new MainClass(details.getMainClassName());
    }

    private String encodeEntryPoint(AppEntryPoint entryPoint) {
        if (entryPoint instanceof MainClass) {
            return ((MainClass)entryPoint).getMainClassName();
        }
        if (entryPoint instanceof MainModule) {
            return "--module " + StartScriptTemplateBindingFactory.getModuleEntryPoint((MainModule)entryPoint);
        }
        if (entryPoint instanceof ExecutableJar) {
            String jarPathEscaped = this.encodePath(((ExecutableJar)entryPoint).getJarPath()).replace("\"", "\\\"");
            return "-jar \"" + jarPathEscaped + "\"";
        }
        throw new IllegalArgumentException("Unknown entry point type: " + entryPoint);
    }

    private static String getModuleEntryPoint(MainModule entryPoint) {
        String mainClassName = entryPoint.getMainClassName();
        boolean hasMainClass = mainClassName != null;
        return entryPoint.getMainModuleName() + (hasMainClass ? "/" + mainClassName : "");
    }

    private String createJoinedPath(Iterable<String> path) {
        if (!this.windows && !path.iterator().hasNext()) {
            return "\"\\\\\\\"\\\\\\\"\"";
        }
        return Streams.stream(path).map(this::encodePath).collect(Collectors.joining(this.getMultiPathSeparator()));
    }

    private String encodePath(String path) {
        if (this.windows) {
            return "%APP_HOME%\\" + path.replace("/", "\\");
        }
        return "$APP_HOME/" + path.replace("\\", "/");
    }

    private String createJoinedDefaultJvmOpts(Iterable<String> defaultJvmOpts) {
        if (this.windows) {
            if (defaultJvmOpts == null) {
                return "";
            }
            Iterable quotedDefaultJvmOpts = Iterables.transform((Iterable)CollectionUtils.toStringList(defaultJvmOpts), (Function)new Function<String, String>(){

                public String apply(String jvmOpt) {
                    return "\"" + StartScriptTemplateBindingFactory.this.escapeWindowsJvmOpt(jvmOpt) + "\"";
                }
            });
            Joiner spaceJoiner = Joiner.on((String)" ");
            return spaceJoiner.join(quotedDefaultJvmOpts);
        }
        if (defaultJvmOpts == null) {
            return "";
        }
        Iterable quotedDefaultJvmOpts = Iterables.transform((Iterable)CollectionUtils.toStringList(defaultJvmOpts), (Function)new Function<String, String>(){

            public String apply(String jvmOpt) {
                jvmOpt = jvmOpt.replace("\\", "\\\\");
                jvmOpt = jvmOpt.replace("\"", "\\\"");
                jvmOpt = jvmOpt.replace("'", "'\"'\"'");
                jvmOpt = jvmOpt.replace("`", "'\"`\"'");
                jvmOpt = jvmOpt.replace("$", "\\$");
                return "\"" + jvmOpt + "\"";
            }
        });
        Joiner spaceJoiner = Joiner.on((String)" ");
        if (Iterables.size((Iterable)quotedDefaultJvmOpts) > 0) {
            return "'" + spaceJoiner.join(quotedDefaultJvmOpts) + "'";
        }
        return "\"\"";
    }

    private String escapeWindowsJvmOpt(String jvmOpts) {
        boolean wasOnBackslash = false;
        StringBuilder escapedJvmOpt = new StringBuilder();
        StringCharacterIterator it = new StringCharacterIterator(jvmOpts);
        char ch = it.first();
        while (ch != '\uffff') {
            String repl = Character.toString(ch);
            if (ch == '%') {
                repl = "%%";
            } else if (ch == '\"') {
                repl = (wasOnBackslash ? Character.valueOf('\\') : "") + "\\\"";
            }
            wasOnBackslash = ch == '\\';
            escapedJvmOpt.append(repl);
            ch = it.next();
        }
        return escapedJvmOpt.toString();
    }

    String createJoinedAppHomeRelativePath(String scriptRelPath) {
        int depth = StringUtils.countMatches((CharSequence)scriptRelPath, (CharSequence)"/");
        if (depth == 0) {
            return "";
        }
        ArrayList<String> appHomeRelativePath = new ArrayList<String>(depth);
        for (int i = 0; i < depth; ++i) {
            appHomeRelativePath.add("..");
        }
        return Joiner.on((String)this.getPathElementSeparator()).join(appHomeRelativePath);
    }

    private String getPathElementSeparator() {
        return this.windows ? "\\" : "/";
    }

    private String getMultiPathSeparator() {
        return this.windows ? ";" : ":";
    }

    private static enum ScriptBindingParameter {
        APP_NAME("applicationName"),
        OPTS_ENV_VAR("optsEnvironmentVar"),
        EXIT_ENV_VAR("exitEnvironmentVar"),
        MODULE_ENTRY_POINT("moduleEntryPoint"),
        MAIN_CLASS_NAME("mainClassName"),
        ENTRY_POINT_ARGS("entryPointArgs"),
        DEFAULT_JVM_OPTS("defaultJvmOpts"),
        APP_NAME_SYS_PROP("appNameSystemProperty"),
        APP_HOME_REL_PATH("appHomeRelativePath"),
        CLASSPATH("classpath"),
        MODULE_PATH("modulePath");

        private final String key;

        private ScriptBindingParameter(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

