<?php

use MediaWiki\Config\ServiceOptions;
use MediaWiki\Extension\OATHAuth\Key\EncryptionHelper;
use MediaWiki\Extension\OATHAuth\OATHAuthModuleRegistry;
use MediaWiki\Extension\OATHAuth\OATHUserRepository;
use MediaWiki\Logger\LoggerFactory;
use MediaWiki\MediaWikiServices;
use MediaWiki\Registration\ExtensionRegistry;
use Wikimedia\ObjectCache\HashBagOStuff;

return [
	'OATHAuthModuleRegistry' => static function ( MediaWikiServices $services ): OATHAuthModuleRegistry {
		return new OATHAuthModuleRegistry(
			$services->getDBLoadBalancerFactory(),
			$services->getObjectFactory(),
			ExtensionRegistry::getInstance()->getAttribute( 'OATHAuthModules' ),
		);
	},
	'OATHUserRepository' => static function ( MediaWikiServices $services ): OATHUserRepository {
		return new OATHUserRepository(
			$services->getDBLoadBalancerFactory(),
			new HashBagOStuff( [
				'maxKey' => 5
			] ),
			$services->getService( 'OATHAuthModuleRegistry' ),
			$services->getCentralIdLookupFactory(),
			LoggerFactory::getInstance( 'authentication' )
		);
	},
	'OATHAuth.EncryptionHelper' => static function ( MediaWikiServices $services ): EncryptionHelper {
		return new EncryptionHelper(
			new ServiceOptions(
				EncryptionHelper::CONSTRUCTOR_OPTIONS,
				$services->getMainConfig(),
			),
		);
	},
];
