/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputHighlightingsSnapshot;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModel;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tB\u0011\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalTextHighlighter;", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "highlightingsSnapshotProvider", "Lkotlin/Function0;", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "model", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "(Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;)V", "highlightingsSnapshot", "(Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;)V", "editor", "Lcom/intellij/openapi/editor/highlighter/HighlighterClient;", "createIterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "startOffset", "", "setEditor", "", "MyHighlighterIterator", "intellij.terminal"})
public final class TerminalTextHighlighter
implements EditorHighlighter {
    @NotNull
    private final Function0<TerminalOutputHighlightingsSnapshot> highlightingsSnapshotProvider;
    @Nullable
    private HighlighterClient editor;

    private TerminalTextHighlighter(Function0<TerminalOutputHighlightingsSnapshot> highlightingsSnapshotProvider) {
        this.highlightingsSnapshotProvider = highlightingsSnapshotProvider;
    }

    public TerminalTextHighlighter(@NotNull TerminalOutputModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this((Function0<TerminalOutputHighlightingsSnapshot>)((Function0)() -> TerminalTextHighlighter._init_$lambda$0(model)));
    }

    public TerminalTextHighlighter(@NotNull TerminalOutputHighlightingsSnapshot highlightingsSnapshot) {
        Intrinsics.checkNotNullParameter((Object)highlightingsSnapshot, (String)"highlightingsSnapshot");
        this((Function0<TerminalOutputHighlightingsSnapshot>)((Function0)() -> TerminalTextHighlighter._init_$lambda$1(highlightingsSnapshot)));
    }

    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        TerminalOutputHighlightingsSnapshot highlightingsSnapshot = (TerminalOutputHighlightingsSnapshot)this.highlightingsSnapshotProvider.invoke();
        int curInd = highlightingsSnapshot.findHighlightingIndex(startOffset);
        HighlighterClient highlighterClient = this.editor;
        return new MyHighlighterIterator((Document)(highlighterClient != null ? highlighterClient.getDocument() : null), highlightingsSnapshot, curInd);
    }

    public void setEditor(@NotNull HighlighterClient editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    private static final TerminalOutputHighlightingsSnapshot _init_$lambda$0(TerminalOutputModel $model) {
        return $model.getHighlightingsSnapshot();
    }

    private static final TerminalOutputHighlightingsSnapshot _init_$lambda$1(TerminalOutputHighlightingsSnapshot $highlightingsSnapshot) {
        return $highlightingsSnapshot;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalTextHighlighter$MyHighlighterIterator;", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "document", "Lcom/intellij/openapi/editor/Document;", "highlightings", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;", "curInd", "", "<init>", "(Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;I)V", "getStart", "getEnd", "getTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getTokenType", "Lcom/intellij/psi/tree/IElementType;", "advance", "", "retreat", "atEnd", "", "getDocument", "intellij.terminal"})
    private static final class MyHighlighterIterator
    implements HighlighterIterator {
        @Nullable
        private final Document document;
        @NotNull
        private final TerminalOutputHighlightingsSnapshot highlightings;
        private int curInd;

        public MyHighlighterIterator(@Nullable Document document, @NotNull TerminalOutputHighlightingsSnapshot highlightings, int curInd) {
            Intrinsics.checkNotNullParameter((Object)highlightings, (String)"highlightings");
            this.document = document;
            this.highlightings = highlightings;
            this.curInd = curInd;
        }

        public int getStart() {
            return this.highlightings.get(this.curInd).getStartOffset();
        }

        public int getEnd() {
            return this.highlightings.get(this.curInd).getEndOffset();
        }

        @NotNull
        public TextAttributes getTextAttributes() {
            return this.highlightings.get(this.curInd).getTextAttributesProvider().getTextAttributes();
        }

        @Nullable
        public IElementType getTokenType() {
            return null;
        }

        public void advance() {
            if (this.curInd < this.highlightings.getSize()) {
                int n = this.curInd;
                this.curInd = n + 1;
            }
        }

        public void retreat() {
            if (this.curInd > -1) {
                int n = this.curInd;
                this.curInd = n + -1;
            }
        }

        public boolean atEnd() {
            return this.curInd < 0 || this.curInd >= this.highlightings.getSize();
        }

        @Nullable
        public Document getDocument() {
            return this.document;
        }
    }
}

