/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.xml;

import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.LanguageSpellchecking;
import com.intellij.spellchecker.tokenizer.SuppressibleSpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.xml.NoSpellchecking;
import com.intellij.spellchecker.xml.XmlTokenizerBase;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.xml.util.XmlEnumeratedValueReference;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlSpellcheckingStrategy
extends SuppressibleSpellcheckingStrategy
implements DumbAware {
    private final Tokenizer<? extends PsiElement> myXmlTextTokenizer = this.createTextTokenizer();
    private final Tokenizer<? extends PsiElement> myXmlAttributeTokenizer = this.createAttributeValueTokenizer();

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof XmlText) {
            Tokenizer<? extends PsiElement> tokenizer = this.myXmlTextTokenizer;
            if (tokenizer == null) {
                XmlSpellcheckingStrategy.$$$reportNull$$$0(0);
            }
            return tokenizer;
        }
        if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS && !this.isXmlDataCharactersParentHandledByItsStrategy(element.getParent())) {
            if (this.isInTemplateLanguageFile(element)) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    XmlSpellcheckingStrategy.$$$reportNull$$$0(1);
                }
                return tokenizer;
            }
            Tokenizer tokenizer = TEXT_TOKENIZER;
            if (tokenizer == null) {
                XmlSpellcheckingStrategy.$$$reportNull$$$0(2);
            }
            return tokenizer;
        }
        if (element instanceof XmlAttributeValue) {
            Tokenizer<? extends PsiElement> tokenizer = this.myXmlAttributeTokenizer;
            if (tokenizer == null) {
                XmlSpellcheckingStrategy.$$$reportNull$$$0(3);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            XmlSpellcheckingStrategy.$$$reportNull$$$0(4);
        }
        return tokenizer;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String name) {
        DomElement domElement;
        if (element == null) {
            XmlSpellcheckingStrategy.$$$reportNull$$$0(5);
        }
        if (name == null) {
            XmlSpellcheckingStrategy.$$$reportNull$$$0(6);
        }
        return (domElement = DomUtil.getDomElement((PsiElement)element)) != null && domElement.getAnnotation(NoSpellchecking.class) != null;
    }

    public SuppressQuickFix[] getSuppressActions(@NotNull PsiElement element, @NotNull String name) {
        if (element == null) {
            XmlSpellcheckingStrategy.$$$reportNull$$$0(7);
        }
        if (name == null) {
            XmlSpellcheckingStrategy.$$$reportNull$$$0(8);
        }
        return SuppressQuickFix.EMPTY_ARRAY;
    }

    protected Tokenizer<? extends PsiElement> createAttributeValueTokenizer() {
        return new XmlAttributeValueTokenizer((Splitter)PlainTextSplitter.getInstance());
    }

    private boolean isXmlDataCharactersParentHandledByItsStrategy(@Nullable PsiElement parent) {
        if (parent == null) {
            return false;
        }
        XmlSpellcheckingStrategy strategy = (XmlSpellcheckingStrategy)((Object)ContainerUtil.findInstance((Iterable)LanguageSpellchecking.INSTANCE.allForLanguage(parent.getLanguage()), XmlSpellcheckingStrategy.class));
        return strategy != null ? strategy.isXmlDataCharactersParentHandled(parent) : this.isXmlDataCharactersParentHandled(parent);
    }

    protected boolean isXmlDataCharactersParentHandled(@NotNull PsiElement parent) {
        if (parent == null) {
            XmlSpellcheckingStrategy.$$$reportNull$$$0(9);
        }
        return parent instanceof XmlText || parent.getNode().getElementType() == XmlElementType.XML_CDATA;
    }

    protected boolean isInTemplateLanguageFile(PsiElement element) {
        PsiFile file = element.getContainingFile();
        return file == null || file.getLanguage() instanceof TemplateLanguage;
    }

    protected Tokenizer<? extends PsiElement> createTextTokenizer() {
        return new XmlTextTokenizer((Splitter)PlainTextSplitter.getInstance());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/xml/XmlSpellcheckingStrategy";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenizer";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/xml/XmlSpellcheckingStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isXmlDataCharactersParentHandled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }

    protected static class XmlAttributeValueTokenizer
    extends XmlTextContentTokenizer<XmlAttributeValue> {
        public XmlAttributeValueTokenizer(Splitter splitter) {
            super(splitter);
        }

        @Override
        protected boolean isContentToken(IElementType tokenType) {
            return tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN || tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER || tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER || XmlTokenType.WHITESPACES.contains(tokenType);
        }

        @Override
        @NotNull
        protected @NotNull List<@NotNull XmlTokenizerBase.SpellcheckRange> getSpellcheckRanges(@NotNull XmlAttributeValue element) {
            TextRange range;
            if (element == null) {
                XmlAttributeValueTokenizer.$$$reportNull$$$0(0);
            }
            if ((range = ElementManipulators.getValueTextRange((PsiElement)element)).isEmpty()) {
                List<XmlTokenizerBase.SpellcheckRange> list2 = Collections.emptyList();
                if (list2 == null) {
                    XmlAttributeValueTokenizer.$$$reportNull$$$0(1);
                }
                return list2;
            }
            String text = ElementManipulators.getValueText((PsiElement)element);
            List<XmlTokenizerBase.SpellcheckRange> list3 = Collections.singletonList(new XmlTokenizerBase.SpellcheckRange(text, false, range.getStartOffset(), TextRange.allOf((String)text)));
            if (list3 == null) {
                XmlAttributeValueTokenizer.$$$reportNull$$$0(2);
            }
            return list3;
        }

        @Override
        public void tokenize(@NotNull XmlAttributeValue element, @NotNull TokenConsumer consumer) {
            PsiReference[] references;
            if (element == null) {
                XmlAttributeValueTokenizer.$$$reportNull$$$0(3);
            }
            if (consumer == null) {
                XmlAttributeValueTokenizer.$$$reportNull$$$0(4);
            }
            for (PsiReference reference : references = element.getReferences()) {
                if (!(reference instanceof XmlEnumeratedValueReference) || reference.resolve() == null) continue;
                return;
            }
            String valueTextTrimmed = element.getValue().trim();
            if (valueTextTrimmed.startsWith("#") && valueTextTrimmed.length() <= 9 && XmlAttributeValueTokenizer.isHexString(valueTextTrimmed.substring(1))) {
                return;
            }
            super.tokenize(element, consumer);
        }

        private static boolean isHexString(String s) {
            for (int i = 0; i < s.length(); ++i) {
                if (StringUtil.isHexDigit((char)s.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spellchecker/xml/XmlSpellcheckingStrategy$XmlAttributeValueTokenizer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spellchecker/xml/XmlSpellcheckingStrategy$XmlAttributeValueTokenizer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSpellcheckRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpellcheckRanges";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "tokenize";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    protected static class XmlTextTokenizer
    extends XmlTextContentTokenizer<XmlText> {
        public XmlTextTokenizer(Splitter splitter) {
            super(splitter);
        }

        @Override
        protected boolean isContentToken(IElementType tokenType) {
            return tokenType == XmlTokenType.XML_DATA_CHARACTERS || tokenType == XmlTokenType.XML_CDATA_START || tokenType == XmlTokenType.XML_CDATA_END || XmlTokenType.WHITESPACES.contains(tokenType);
        }
    }

    protected static abstract class XmlTextContentTokenizer<T extends XmlElement>
    extends XmlTokenizerBase<T> {
        public XmlTextContentTokenizer(Splitter splitter) {
            super(splitter);
        }

        protected abstract boolean isContentToken(IElementType var1);

        @Override
        @NotNull
        protected @NotNull List<@NotNull TextRange> getSpellcheckOuterContentRanges(@NotNull T element) {
            if (element == null) {
                XmlTextContentTokenizer.$$$reportNull$$$0(0);
            }
            SmartList result2 = new SmartList(super.getSpellcheckOuterContentRanges(element));
            element.acceptChildren((PsiElementVisitor)new XmlElementVisitor((List)result2){
                final /* synthetic */ List val$result;
                {
                    this.val$result = list2;
                }

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element.getNode().getElementType() == XmlElementType.XML_CDATA) {
                        element.acceptChildren((PsiElementVisitor)this);
                    } else if (!(element instanceof LeafPsiElement) || !this.isContentToken(element.getNode().getElementType())) {
                        this.val$result.add(element.getTextRangeInParent());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/xml/XmlSpellcheckingStrategy$XmlTextContentTokenizer$1", "visitElement"));
                }
            });
            SmartList smartList = result2;
            if (smartList == null) {
                XmlTextContentTokenizer.$$$reportNull$$$0(1);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spellchecker/xml/XmlSpellcheckingStrategy$XmlTextContentTokenizer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spellchecker/xml/XmlSpellcheckingStrategy$XmlTextContentTokenizer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSpellcheckOuterContentRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpellcheckOuterContentRanges";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

