/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit.message;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.ToolDescriptors;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeComparator;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeRenderer;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeTable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.commit.message.CommitMessageInspectionDetails;
import com.intellij.vcs.commit.message.CommitMessageInspectionProfile;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CommitMessageInspectionsPanel
extends BorderLayoutPanel
implements Disposable,
UnnamedConfigurable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<ToolDescriptors> myInitialToolDescriptors;
    @NotNull
    private final Map<HighlightDisplayKey, CommitMessageInspectionDetails> myToolDetails;
    @NotNull
    private final InspectionConfigTreeNode myRoot;
    private InspectionProfileModifiableModel myModifiableModel;
    private final InspectionsConfigTreeTable myInspectionsTable;
    private final Wrapper myDetailsPanel;
    private CommitMessageInspectionDetails myCurrentDetails;

    public CommitMessageInspectionsPanel(@NotNull Project project) {
        if (project == null) {
            CommitMessageInspectionsPanel.$$$reportNull$$$0(0);
        }
        this.myInitialToolDescriptors = new ArrayList<ToolDescriptors>();
        this.myToolDetails = new HashMap<HighlightDisplayKey, CommitMessageInspectionDetails>();
        this.myRoot = new InspectionConfigTreeNode.Group("");
        this.myDetailsPanel = new Wrapper(){

            public boolean isNull() {
                return false;
            }
        };
        this.myProject = project;
        this.myModifiableModel = this.createProfileModel();
        this.myInspectionsTable = this.createInspectionsTable();
        JBSplitter splitter = new JBSplitter("CommitMessageInspectionsPanelSplitter", 0.5f);
        splitter.setShowDividerIcon(false);
        splitter.setFirstComponent((JComponent)this.myInspectionsTable);
        splitter.setSecondComponent((JComponent)this.myDetailsPanel);
        this.addToCenter((Component)splitter);
        this.setPreferredSize((Dimension)JBUI.size((int)650, (int)120));
    }

    @NotNull
    private InspectionProfileModifiableModel createProfileModel() {
        CommitMessageInspectionProfile profile = CommitMessageInspectionProfile.getInstance(this.myProject);
        return new InspectionProfileModifiableModel((InspectionProfileImpl)profile);
    }

    private void initToolDescriptors() {
        this.myInitialToolDescriptors.clear();
        for (ScopeToolState state : this.myModifiableModel.getDefaultStates(this.myProject)) {
            this.myInitialToolDescriptors.add(ToolDescriptors.fromScopeToolState((ScopeToolState)state, (InspectionProfileModifiableModel)this.myModifiableModel, (Project)this.myProject));
        }
    }

    private void buildInspectionsModel() {
        this.myRoot.removeAllChildren();
        for (ToolDescriptors toolDescriptors : this.myInitialToolDescriptors) {
            this.myRoot.add((MutableTreeNode)((Object)new MyInspectionTreeNode(toolDescriptors)));
        }
        TreeUtil.sortRecursively((MutableTreeNode)this.myRoot, (Comparator)InspectionsConfigTreeComparator.INSTANCE);
    }

    @NotNull
    private InspectionsConfigTreeTable createInspectionsTable() {
        InspectionsConfigTreeTable table = InspectionsConfigTreeTable.create((InspectionsConfigTreeTable.InspectionsConfigTreeTableSettings)new MyInspectionsTableSettings(this.myRoot, this.myProject), (Disposable)this);
        table.setRootVisible(false);
        table.setTreeCellRenderer((TreeCellRenderer)((Object)new MyInspectionsTreeRenderer()));
        table.setSelectionMode(0);
        table.getTree().getSelectionModel().setSelectionMode(1);
        table.getTree().addTreeSelectionListener(e -> this.updateDetailsPanel());
        table.setBorder(IdeBorderFactory.createBorder());
        InspectionsConfigTreeTable inspectionsConfigTreeTable = table;
        if (inspectionsConfigTreeTable == null) {
            CommitMessageInspectionsPanel.$$$reportNull$$$0(1);
        }
        return inspectionsConfigTreeTable;
    }

    private void updateDetailsPanel() {
        MyInspectionTreeNode node = this.getSelectedNode();
        if (node == null && this.myCurrentDetails != null || node != null && (this.myCurrentDetails == null || node.getKey() != this.myCurrentDetails.getKey())) {
            this.setDetails(node);
        }
        if (this.myCurrentDetails != null) {
            this.myCurrentDetails.update();
        }
    }

    private void setDetails(@Nullable MyInspectionTreeNode node) {
        this.myCurrentDetails = node != null ? this.myToolDetails.computeIfAbsent(node.getKey(), key -> this.createDetails(node)) : null;
        this.myDetailsPanel.setContent(this.myCurrentDetails != null ? this.myCurrentDetails.createComponent() : null);
        this.myDetailsPanel.repaint();
    }

    @NotNull
    private CommitMessageInspectionDetails createDetails(@NotNull MyInspectionTreeNode node) {
        if (node == null) {
            CommitMessageInspectionsPanel.$$$reportNull$$$0(2);
        }
        CommitMessageInspectionDetails details = new CommitMessageInspectionDetails(this.myProject, (InspectionProfileImpl)this.myModifiableModel, node.getDefaultDescriptor());
        details.addListener(severity -> this.myInspectionsTable.updateUI());
        CommitMessageInspectionDetails commitMessageInspectionDetails = details;
        if (commitMessageInspectionDetails == null) {
            CommitMessageInspectionsPanel.$$$reportNull$$$0(3);
        }
        return commitMessageInspectionDetails;
    }

    @Nullable
    private MyInspectionTreeNode getSelectedNode() {
        TreePath selectedPath = this.myInspectionsTable.getTree().getPathForRow(this.myInspectionsTable.getSelectedRow());
        return selectedPath != null ? (MyInspectionTreeNode)((Object)selectedPath.getLastPathComponent()) : null;
    }

    public void dispose() {
        this.clearToolDetails();
    }

    @Nullable
    public JComponent createComponent() {
        return this;
    }

    public void reset() {
        this.clearToolDetails();
        this.myModifiableModel.getAllTools().forEach(ScopeToolState::resetConfigPanel);
        this.myModifiableModel = this.createProfileModel();
        this.initToolDescriptors();
        TreeState state = TreeState.createOn((JTree)this.myInspectionsTable.getTree(), (DefaultMutableTreeNode)this.myRoot);
        this.buildInspectionsModel();
        ((DefaultTreeModel)this.myInspectionsTable.getTree().getModel()).reload();
        state.applyTo((JTree)this.myInspectionsTable.getTree(), (Object)this.myRoot);
    }

    private void clearToolDetails() {
        for (CommitMessageInspectionDetails details : this.myToolDetails.values()) {
            Disposer.dispose((Disposable)details);
        }
        this.myToolDetails.clear();
        this.setDetails(null);
    }

    public boolean isModified() {
        return ContainerUtil.exists(this.myInitialToolDescriptors, toolDescriptors -> SingleInspectionProfilePanel.areToolDescriptorsChanged((Project)this.myProject, (InspectionProfileModifiableModel)this.myModifiableModel, (ToolDescriptors)toolDescriptors)) || ContainerUtil.exists(this.myToolDetails.values(), CommitMessageInspectionDetails::isModified);
    }

    public void apply() throws ConfigurationException {
        for (CommitMessageInspectionDetails details : this.myToolDetails.values()) {
            details.apply();
        }
        this.myModifiableModel.commit();
        ((CommitMessageInspectionProfile.ProfileListener)this.myProject.getMessageBus().syncPublisher(CommitMessageInspectionProfile.TOPIC)).profileChanged();
        this.reset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/commit/message/CommitMessageInspectionsPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/commit/message/CommitMessageInspectionsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createInspectionsTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDetails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDetails";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    private static class MyInspectionTreeNode
    extends InspectionConfigTreeNode.Tool {
        MyInspectionTreeNode(@NotNull ToolDescriptors descriptors) {
            if (descriptors == null) {
                MyInspectionTreeNode.$$$reportNull$$$0(0);
            }
            super(() -> descriptors);
        }

        @NotNull
        public Descriptor getDefaultDescriptor() {
            Descriptor descriptor = Objects.requireNonNull(super.getDefaultDescriptor());
            if (descriptor == null) {
                MyInspectionTreeNode.$$$reportNull$$$0(1);
            }
            return descriptor;
        }

        @NotNull
        public ToolDescriptors getDescriptors() {
            ToolDescriptors toolDescriptors = Objects.requireNonNull(super.getDescriptors());
            if (toolDescriptors == null) {
                MyInspectionTreeNode.$$$reportNull$$$0(2);
            }
            return toolDescriptors;
        }

        protected boolean calculateIsProperSettings() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/commit/message/CommitMessageInspectionsPanel$MyInspectionTreeNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/commit/message/CommitMessageInspectionsPanel$MyInspectionTreeNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private class MyInspectionsTableSettings
    extends InspectionsConfigTreeTable.InspectionsConfigTreeTableSettings {
        MyInspectionsTableSettings(@NotNull InspectionConfigTreeNode root, Project project) {
            if (root == null) {
                MyInspectionsTableSettings.$$$reportNull$$$0(0);
            }
            if (project == null) {
                MyInspectionsTableSettings.$$$reportNull$$$0(1);
            }
            super((TreeNode)root, project);
        }

        @NotNull
        protected InspectionProfileImpl getInspectionProfile() {
            InspectionProfileModifiableModel inspectionProfileModifiableModel = CommitMessageInspectionsPanel.this.myModifiableModel;
            if (inspectionProfileModifiableModel == null) {
                MyInspectionsTableSettings.$$$reportNull$$$0(2);
            }
            return inspectionProfileModifiableModel;
        }

        protected void onChanged(@NotNull InspectionConfigTreeNode node) {
            if (node == null) {
                MyInspectionsTableSettings.$$$reportNull$$$0(3);
            }
        }

        public void updateRightPanel() {
            CommitMessageInspectionsPanel.this.updateDetailsPanel();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/commit/message/CommitMessageInspectionsPanel$MyInspectionsTableSettings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/commit/message/CommitMessageInspectionsPanel$MyInspectionsTableSettings";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInspectionProfile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onChanged";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyInspectionsTreeRenderer
    extends InspectionsConfigTreeRenderer {
        private MyInspectionsTreeRenderer() {
        }

        @Nullable
        protected String getFilter() {
            return null;
        }
    }
}

