import React from 'react';
import { AddSVGProps } from '../types';
export declare const getPoint: ({ sides, size, center, rotate, side, }: {
    side: number;
} & Pick<PolygonProps, "center" | "size" | "rotate" | "sides">) => {
    x: number;
    y: number;
};
export declare const getPoints: ({ sides, size, center, rotate, }: NonNullable<Pick<PolygonProps, 'sides' | 'size' | 'center' | 'rotate'>>) => {
    x: number;
    y: number;
}[];
export declare type PolygonProps = {
    /** Number of polygon sides. */
    sides?: number;
    /** Size of the shape. */
    size?: number;
    /** Points to use to render the polygon. If this is defined, `sides`, `size`, `rotate`, and `center` are ignored. */
    points?: [number, number][];
    /** className to apply to polygon element. */
    className?: string;
    /** Rotation transform to apply to polygon. */
    rotate?: number;
    /** Render function override which is passed the generated polygon points. */
    children?: (args: {
        points: [number, number][];
    }) => React.ReactNode;
    /** Reference to polygon element. */
    innerRef?: React.Ref<SVGPolygonElement>;
    /** Polygon center position. */
    center?: {
        x: number;
        y: number;
    };
};
export default function Polygon({ sides, size, center, rotate, className, children, innerRef, points, ...restProps }: AddSVGProps<PolygonProps, SVGPolygonElement>): JSX.Element;
//# sourceMappingURL=Polygon.d.ts.map