import { BoxProps, ElementProps, Factory, StylesApiProps } from '@mantine/core';
import { CalendarHeaderSettings, CalendarHeaderStylesNames } from '../CalendarHeader';
import { YearsListSettings, YearsListStylesNames } from '../YearsList';
export type DecadeLevelStylesNames = YearsListStylesNames | CalendarHeaderStylesNames;
export interface DecadeLevelBaseSettings extends YearsListSettings {
    /** Dayjs label format to display decade label or a function that returns decade label based on date value, defaults to "YYYY" */
    decadeLabelFormat?: string | ((startOfDecade: Date, endOfDecade: Date) => React.ReactNode);
}
export interface DecadeLevelSettings extends DecadeLevelBaseSettings, Omit<CalendarHeaderSettings, 'onLevelClick' | 'hasNextLevel'> {
}
export interface DecadeLevelProps extends BoxProps, DecadeLevelSettings, Omit<StylesApiProps<DecadeLevelFactory>, 'classNames' | 'styles'>, ElementProps<'div'> {
    classNames?: Partial<Record<string, string>>;
    styles?: Partial<Record<string, React.CSSProperties>>;
    __staticSelector?: string;
    /** Decade that is currently displayed */
    decade: Date;
    /** Aria-label for change level control */
    levelControlAriaLabel?: string;
}
export type DecadeLevelFactory = Factory<{
    props: DecadeLevelProps;
    ref: HTMLDivElement;
    stylesNames: DecadeLevelStylesNames;
}>;
export declare const DecadeLevel: import("@mantine/core").MantineComponent<{
    props: DecadeLevelProps;
    ref: HTMLDivElement;
    stylesNames: DecadeLevelStylesNames;
}>;
