'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var hooks = require('@mantine/hooks');
var createEventHandler = require('../../../core/utils/create-event-handler/create-event-handler.cjs');
require('clsx');
require('../../../core/MantineProvider/Mantine.context.cjs');
require('../../../core/MantineProvider/default-theme.cjs');
require('../../../core/MantineProvider/MantineProvider.cjs');
require('../../../core/MantineProvider/MantineThemeProvider/MantineThemeProvider.cjs');
var useProps = require('../../../core/MantineProvider/use-props/use-props.cjs');
require('../../../core/MantineProvider/MantineCssVariables/MantineCssVariables.cjs');
require('../../../core/Box/Box.cjs');
var factory = require('../../../core/factory/factory.cjs');
require('../../../core/DirectionProvider/DirectionProvider.cjs');
var Popover = require('../../Popover/Popover.cjs');
require('../../Popover/PopoverDropdown/PopoverDropdown.cjs');
require('../../Popover/PopoverTarget/PopoverTarget.cjs');
var Menu_context = require('../Menu.context.cjs');
var MenuSub_context = require('../MenuSub/MenuSub.context.cjs');
var Menu_module = require('../Menu.module.css.cjs');

const defaultProps = {};
const MenuSubDropdown = factory.factory((props, ref) => {
  const {
    classNames,
    className,
    style,
    styles,
    vars,
    onMouseEnter,
    onMouseLeave,
    onKeyDown,
    children,
    ...others
  } = useProps.useProps("MenuSubDropdown", defaultProps, props);
  const wrapperRef = React.useRef(null);
  const ctx = Menu_context.useMenuContext();
  const subCtx = MenuSub_context.useSubMenuContext();
  const handleMouseEnter = createEventHandler.createEventHandler(onMouseEnter, subCtx?.open);
  const handleMouseLeave = createEventHandler.createEventHandler(onMouseLeave, subCtx?.close);
  return /* @__PURE__ */ jsxRuntime.jsx(
    Popover.Popover.Dropdown,
    {
      ...others,
      onMouseEnter: handleMouseEnter,
      onMouseLeave: handleMouseLeave,
      role: "menu",
      "aria-orientation": "vertical",
      ref: hooks.useMergedRef(ref, wrapperRef),
      ...ctx.getStyles("dropdown", {
        className,
        style,
        styles,
        classNames,
        withStaticClass: false
      }),
      tabIndex: -1,
      "data-menu-dropdown": true,
      children
    }
  );
});
MenuSubDropdown.classes = Menu_module;
MenuSubDropdown.displayName = "@mantine/core/MenuSubDropdown";

exports.MenuSubDropdown = MenuSubDropdown;
//# sourceMappingURL=MenuSubDropdown.cjs.map
