import { PropsWithChildren } from "react";
import { DrawerProps } from "@mantine/core";
type TDrawerProps = {
    width?: number;
    closedWidth?: number;
    title: string;
    showChevronBtn?: boolean;
    isOpen?: boolean;
    onClose?: () => void;
    invisibleWhenClosed?: boolean;
    drawerProps?: Partial<DrawerProps>;
};
type TDrawerHandle = {
    setOpen: () => void;
    setClose: () => void;
};
declare const Drawer: import("react").ForwardRefExoticComponent<TDrawerProps & {
    children?: import("react").ReactNode | undefined;
} & import("react").RefAttributes<TDrawerHandle>>;
type TDrawerWithOpenerProps = PropsWithChildren<{
    Opener: React.FC<{
        setOpen: () => void;
    }>;
}> & TDrawerProps;
declare const DrawerWithOpener: ({ Opener, ...props }: TDrawerWithOpenerProps) => import("react/jsx-runtime").JSX.Element;
export { Drawer, DrawerWithOpener };
//# sourceMappingURL=Drawer.d.ts.map