import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import { bind as _bind } from 'bind-event-listener';
import { CONTRAST_MODE_ATTRIBUTE } from '../constants';
import { moreContrastMediaQuery } from './theme-loading';
var isMatchMediaAvailable = typeof window !== 'undefined' && 'matchMedia' in window;

/**
 * Updates the current theme when the system contrast preference changes. Should be bound
 * to an event listener listening on the '(prefers-contrast: more)' query
 * @param e The event representing a change in system theme.
 */
function checkNativeListener(e) {
  var element = document.documentElement;
  element.setAttribute(CONTRAST_MODE_ATTRIBUTE, e.matches ? 'more' : 'no-preference');
}
var contrastModeMql = isMatchMediaAvailable && window.matchMedia(moreContrastMediaQuery);
var ContrastModeObserver = /*#__PURE__*/function () {
  function ContrastModeObserver() {
    _classCallCheck(this, ContrastModeObserver);
    _defineProperty(this, "unbindContrastChangeListener", null);
  }
  return _createClass(ContrastModeObserver, [{
    key: "getContrastMode",
    value: function getContrastMode() {
      if (!contrastModeMql) {
        return 'no-preference';
      }
      return contrastModeMql !== null && contrastModeMql !== void 0 && contrastModeMql.matches ? 'more' : 'no-preference';
    }
  }, {
    key: "bind",
    value: function bind() {
      if (contrastModeMql && this.unbindContrastChangeListener === null) {
        this.unbindContrastChangeListener = _bind(contrastModeMql, {
          type: 'change',
          listener: checkNativeListener
        });
      }
    }
  }, {
    key: "unbind",
    value: function unbind() {
      if (this.unbindContrastChangeListener) {
        this.unbindContrastChangeListener();
        this.unbindContrastChangeListener = null;
      }
    }
  }]);
}();
/**
 * A singleton contrast mode observer - binds "auto" switching logic to a single `mediaQueryList` listener
 * that can be unbound by any consumer when no longer needed.
 */
var SingletonContrastModeObserver = new ContrastModeObserver();
export default SingletonContrastModeObserver;