/**
 * Our internal configuration for breakpoints configuration.
 *
 * We explicitly use `-0.01rem` for "max" values to both ensure we do not overlap our media queries, but also don't skip any fractional pixels.  There is a chance this is not safe in some browsers, eg. Safari has weird rounding.
 * @see: https://tzi.fr/css/prevent-double-breakpoint/
 *
 * @experimental Unsafe for direct consumption outside of the design system itself; please use our `media` export instead for media queries.
 */
export declare const UNSAFE_BREAKPOINTS_CONFIG: {
    readonly xxs: {
        readonly gridItemGutter: "var(--ds-space-200)";
        readonly gridMargin: "var(--ds-space-200)";
        readonly min: "0rem";
        readonly max: "29.99rem";
    };
    readonly xs: {
        readonly gridItemGutter: "var(--ds-space-200)";
        readonly gridMargin: "var(--ds-space-200)";
        readonly min: "30rem";
        readonly max: "47.99rem";
    };
    readonly sm: {
        readonly gridItemGutter: "var(--ds-space-200)";
        readonly gridMargin: "var(--ds-space-300)";
        readonly min: "48rem";
        readonly max: "63.99rem";
    };
    readonly md: {
        readonly gridItemGutter: "var(--ds-space-300)";
        readonly gridMargin: "var(--ds-space-400)";
        readonly min: "64rem";
        readonly max: "89.99rem";
    };
    readonly lg: {
        readonly gridItemGutter: "var(--ds-space-400)";
        readonly gridMargin: "var(--ds-space-400)";
        readonly min: "90rem";
        readonly max: "110.49rem";
    };
    readonly xl: {
        readonly gridItemGutter: "var(--ds-space-400)";
        readonly gridMargin: "var(--ds-space-500)";
        readonly min: "110.5rem";
        readonly max: null;
    };
};
/**
 * The list of breakpoints in order from smallest to largest.  You may need to clone and reverse this list if you want the opposite.
 *
 * This is intentional for cascading with `min-width` or `media.above`. Media queries go from lowest width to highest.
 *
 * @experimental Unsafe for consumption outside of the design system itself.
 */
export declare const UNSAFE_BREAKPOINTS_ORDERED_LIST: [
    "xxs",
    "xs",
    "sm",
    "md",
    "lg",
    "xl"
];
/**
 * This is our smallest breakpoint with a few nuances to it:
 * 1. It is the default value for shorthands, eg. `<GridItem span={6} />` maps to `{ [SMALLEST_BREAKPOINT]: props.span }`
 * 2. It's omitted in `media.below` as there's nothing below `0px`.
 */
export declare const SMALLEST_BREAKPOINT: "xxs";
