export const knownVariables: Record<string, string[]> = {
	'--adg3-color-R50': ['danger'],
	'--adg3-color-R75': ['danger'],
	'--adg3-color-R100': ['danger'],
	'--adg3-color-R200': ['danger'],
	'--adg3-color-R300': ['danger'],
	'--adg3-color-R400': ['danger'],
	'--adg3-color-R500': ['danger'],
	'--adg3-color-Y50': ['warning'],
	'--adg3-color-Y75': ['warning'],
	'--adg3-color-Y100': ['warning'],
	'--adg3-color-Y200': ['warning'],
	'--adg3-color-Y300': ['warning'],
	'--adg3-color-Y400': ['warning'],
	'--adg3-color-Y500': ['warning'],
	'--adg3-color-G50': ['success'],
	'--adg3-color-G75': ['success'],
	'--adg3-color-G100': ['success'],
	'--adg3-color-G200': ['success'],
	'--adg3-color-G300': ['success'],
	'--adg3-color-G400': ['success'],
	'--adg3-color-G500': ['success'],
	'--adg3-color-B50': ['brand'],
	'--adg3-color-B75': ['brand'],
	'--adg3-color-B100': ['brand'],
	'--adg3-color-B200': ['brand'],
	'--adg3-color-B300': ['brand'],
	'--adg3-color-B400': ['brand'],
	'--adg3-color-B500': ['brand'],
	'--adg3-color-P50': ['discovery'],
	'--adg3-color-P75': ['discovery'],
	'--adg3-color-P100': ['discovery'],
	'--adg3-color-P200': ['discovery'],
	'--adg3-color-P300': ['discovery'],
	'--adg3-color-P400': ['discovery'],
	'--adg3-color-P500': ['discovery'],
	'--adg3-color-T50': ['accent', 'teal'],
	'--adg3-color-T75': ['accent', 'teal'],
	'--adg3-color-T100': ['accent', 'teal'],
	'--adg3-color-T200': ['accent', 'teal'],
	'--adg3-color-T300': ['accent', 'teal'],
	'--adg3-color-T400': ['accent', 'teal'],
	'--adg3-color-T500': ['accent', 'teal'],
	'--adg3-color-N0': ['inverse'],
	'--adg3-color-N10': [],
	'--adg3-color-N20': [],
	'--adg3-color-N30': [],
	'--adg3-color-N40': [],
	'--adg3-color-N50': [],
	'--adg3-color-N60': [],
	'--adg3-color-N70': [],
	'--adg3-color-N80': [],
	'--adg3-color-N90': [],
	'--adg3-color-N100': [],
	'--adg3-color-N200': ['text', 'subtlest'],
	'--adg3-color-N300': [],
	'--adg3-color-N400': ['text', 'subtle'],
	'--adg3-color-N500': [],
	'--adg3-color-N600': [],
	'--adg3-color-N700': ['text'],
	'--adg3-color-N800': ['text'],
	'--adg3-color-N900': ['text'],
	'--adg3-color-N10A': [],
	'--adg3-color-N20A': [],
	'--adg3-color-N30A': [],
	'--adg3-color-N40A': [],
	'--adg3-color-N50A': [],
	'--adg3-color-N60A': [],
	'--adg3-color-N70A': [],
	'--adg3-color-N80A': [],
	'--adg3-color-N90A': [],
	'--adg3-color-N100A': [],
	'--adg3-color-N200A': [],
	'--adg3-color-N300A': [],
	'--adg3-color-N400A': [],
	'--adg3-color-N500A': [],
	'--adg3-color-N600A': [],
	'--adg3-color-N700A': [],
	'--adg3-color-N800A': [],
	'--adg3-color-DN900': [],
	'--adg3-color-DN800': [],
	'--adg3-color-DN700': [],
	'--adg3-color-DN600': [],
	'--adg3-color-DN500': [],
	'--adg3-color-DN400': [],
	'--adg3-color-DN300': [],
	'--adg3-color-DN200': [],
	'--adg3-color-DN100': [],
	'--adg3-color-DN90': [],
	'--adg3-color-DN80': [],
	'--adg3-color-DN70': [],
	'--adg3-color-DN60': [],
	'--adg3-color-DN50': [],
	'--adg3-color-DN40': [],
	'--adg3-color-DN30': [],
	'--adg3-color-DN20': [],
	'--adg3-color-DN10': [],
	'--adg3-color-DN0': [],
	'--adg3-color-DN800A': [],
	'--adg3-color-DN700A': [],
	'--adg3-color-DN600A': [],
	'--adg3-color-DN500A': [],
	'--adg3-color-DN400A': [],
	'--adg3-color-DN300A': [],
	'--adg3-color-DN200A': [],
	'--adg3-color-DN100A': [],
	'--adg3-color-DN90A': [],
	'--adg3-color-DN80A': [],
	'--adg3-color-DN70A': [],
	'--adg3-color-DN60A': [],
	'--adg3-color-DN50A': [],
	'--adg3-color-DN40A': [],
	'--adg3-color-DN30A': [],
	'--adg3-color-DN20A': [],
	'--adg3-color-DN10A': [],

	'--adg3-color-background-light': ['elevation', 'surface'],
	'--adg3-color-background-dark': ['elevation', 'surface'],
	'--adg3-color-text-light': ['text'],
	'--adg3-color-text-dark': ['text'],
	'--adg3-color-subtleText-light': ['text', 'subtle'],
	'--adg3-color-subtleText-dark': ['text', 'subtle'],
	'--adg3-color-placeholderText-light': ['text', 'subtlest'],
	'--adg3-color-placeholderText-dark': ['text', 'subtlest'],
	'--adg3-color-heading-light': ['text'],
	'--adg3-color-heading-dark': ['text'],
	'--adg3-color-subtleHeading-light': ['text', 'subtle'],
	'--adg3-color-subtleHeading-dark': ['text', 'subtle'],
	'--adg3-color-codeBlock-light': ['elevation', 'surface', 'sunken'],
	'--adg3-color-codeBlock-dark': ['elevation', 'surface', 'sunken'],
	'--adg3-color-link-light': ['link'],
	'--adg3-color-link-dark': ['link'],
	'--adg3-color-linkHover-light': ['link'],
	'--adg3-color-linkHover-dark': ['link'],
	'--adg3-color-linkActive-light': ['link', 'pressed'],
	'--adg3-color-linkActive-dark': ['link', 'pressed'],
	'--adg3-color-linkOutline-light': ['link', 'focused'],
	'--adg3-color-linkOutline-dark': ['link', 'focused'],
	'--adg3-color-primary-light': ['brand'],
	'--adg3-color-primary-dark': ['brand'],
	'--adg3-color-blue-light': ['accent', 'subtler', 'blue'],
	'--adg3-color-blue-dark': ['accent', 'bolder', 'blue'],
	'--adg3-color-teal-light': ['accent', 'subtler', 'teal'],
	'--adg3-color-teal-dark': ['accent', 'bolder', 'teal'],
	'--adg3-color-purple-light': ['accent', 'subtler', 'purple'],
	'--adg3-color-purple-dark': ['accent', 'bolder', 'purple'],
	'--adg3-color-red-light': ['accent', 'subtler', 'red'],
	'--adg3-color-red-dark': ['accent', 'bolder', 'red'],
	'--adg3-color-yellow-light': ['accent', 'subtler', 'yellow'],
	'--adg3-color-yellow-dark': ['accent', 'bolder', 'yellow'],
	'--adg3-color-green-light': ['accent', 'subtler', 'green'],
	'--adg3-color-green-dark': ['accent', 'bolder', 'green'],
	'--adg3-color-N20-transparent': [],

	/* Alias variables */
	'--jpo-theme-color': ['brand'],
	'--jpo-text-default-color': ['text'],
	'--jpo-text-secondary-color': ['text', 'subtle'],
	'--jpo-text-muted-color': ['text', 'disabled'],
	'--jpo-text-error-color': ['text', 'danger'],
	'--jpo-bg-default-color': ['elevation', 'surface'],
	'--jpo-bg-reverse-color': ['background', 'inverse'],
	'--jpo-bg-warning-color': ['background', 'warning', 'subtle'],
	'--jpo-bg-dark-color': ['background', 'netural', 'bold'],
	'--jpo-border-default-color': ['border'],
	'--jpo-border-secondary-color': ['border', 'subtle'],
};

export const knownNamedColors: Record<string, string[]> = {
	aliceblue: ['blue'],
	antiquewhite: [],
	aqua: ['teal'],
	aquamarine: ['teal'],
	azure: ['teal', 'subtlest'],
	beige: [],
	bisque: [],
	black: [],
	blanchedalmond: [],
	blue: ['blue'],
	blueviolet: ['blue'],
	brown: [],
	burlywood: [],
	cadetblue: ['blue'],
	chartreuse: [],
	chocolate: [],
	coral: [],
	cornflowerblue: ['blue'],
	cornsilk: [],
	crimson: ['red'],
	cyan: ['accent', 'teal', 'subtle'],
	darkblue: ['accent', 'blue', 'bold'],
	darkcyan: ['accent', 'teal', 'bold'],
	darkgoldenrod: [],
	darkgray: [],
	darkgrey: [],
	darkgreen: ['green'],
	darkkhaki: [],
	darkmagenta: ['magenta', 'bold'],
	darkolivegreen: ['green'],
	darkorange: [],
	darkorchid: [],
	darkred: ['accent', 'red', 'bold'],
	darksalmon: [],
	darkseagreen: ['green'],
	darkslateblue: [],
	darkslategray: [],
	darkslategrey: [],
	darkturquoise: ['teal', 'bold'],
	darkviolet: ['purple', 'bold'],
	deeppink: ['magenta'],
	deepskyblue: ['blue'],
	dimgray: [],
	dimgrey: [],
	dodgerblue: [],
	firebrick: ['red', 'bold'],
	floralwhite: [],
	forestgreen: ['green'],
	fuchsia: ['magenta', 'subtle'],
	gainsboro: [],
	ghostwhite: [],
	gold: ['yellow'],
	goldenrod: [],
	gray: [],
	grey: [],
	green: ['green'],
	greenyellow: [],
	honeydew: [],
	hotpink: ['magenta'],
	indianred: [],
	indigo: ['purple'],
	ivory: [],
	khaki: [],
	lavender: ['purple'],
	lavenderblush: ['purple'],
	lawngreen: ['green'],
	lemonchiffon: [],
	lightblue: [],
	lightcoral: [],
	lightcyan: [],
	lightgoldenrodyellow: [],
	lightgray: [],
	lightgrey: [],
	lightgreen: ['green', 'accent'],
	lightpink: ['magenta'],
	lightsalmon: ['pink', 'subtler'],
	lightseagreen: ['green'],
	lightskyblue: ['blue', 'accent'],
	lightslategray: [],
	lightslategrey: [],
	lightsteelblue: ['blue'],
	lightyellow: [],
	lime: ['green', 'subtler'],
	limegreen: ['green'],
	linen: [],
	magenta: ['magenta'],
	maroon: [],
	mediumaquamarine: [],
	mediumblue: [],
	mediumorchid: [],
	mediumpurple: [],
	mediumseagreen: ['green'],
	mediumslateblue: [],
	mediumspringgreen: ['green'],
	mediumturquoise: [],
	mediumvioletred: [],
	midnightblue: [],
	mintcream: [],
	mistyrose: [],
	moccasin: [],
	navajowhite: [],
	navy: ['blue', 'bold'],
	oldlace: [],
	olive: [],
	olivedrab: [],
	orange: [],
	orangered: [],
	orchid: ['purple'],
	palegoldenrod: [],
	palegreen: ['green'],
	paleturquoise: [],
	palevioletred: [],
	papayawhip: [],
	peachpuff: [],
	peru: [],
	pink: ['magenta'],
	plum: [],
	powderblue: ['blue', 'subtle'],
	purple: ['purple'],
	rebeccapurple: ['purple', 'accent'],
	red: ['red', 'accent'],
	rosybrown: [],
	royalblue: [],
	saddlebrown: [],
	salmon: [],
	sandybrown: [],
	seagreen: ['green'],
	seashell: [],
	sienna: [],
	silver: [],
	skyblue: ['blue', 'subtlest'],
	slateblue: [],
	slategray: [],
	slategrey: [],
	snow: [],
	springgreen: ['green'],
	steelblue: ['blue'],
	tan: [],
	teal: ['accent', 'teal'],
	thistle: [],
	tomato: ['red'],
	turquoise: [],
	violet: ['purple'],
	wheat: [],
	white: ['elevation', 'surface'],
	whitesmoke: [],
	yellow: ['yellow'],
	yellowgreen: ['yellow'],
};

export const knownRawColors: Record<string, string[]> = {
	'#cccccc': ['gray'],
	'#aaaaaa': ['gray', 'subtlest'],
	'#bbbbbb': ['gray', 'subtle'],
	'#ffffff': ['elevation', 'surface'],
	'#f0f0f0': ['elevation', 'surface'],
	'#eeeeee': ['elevation', 'surface', 'sunken'],
	'#ff0000': ['danger'],
	'#d04437': ['danger'],
	'#c00c00': ['danger'],
	'#5243aa': ['discovery'],
	'#ffc712': ['warning'],
	'#00f00f': ['brand'],
	'#3b73af': ['brand'],
	'#326ca6': ['brand'],
	'#0052cc': ['brand'],
};
