import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
import React, { useCallback, useEffect, useRef } from 'react';
import { bind } from 'bind-event-listener';
import { combine } from '@atlaskit/pragmatic-drag-and-drop/combine';
import { monitorForElements } from '@atlaskit/pragmatic-drag-and-drop/element/adapter';
import { error, warning } from '../dev-warning';
import { cancelPointerDrag } from './cancel-drag';
import { RbdInvariant } from './rbd-invariant';
/**
 * This component holds the actual error boundary logic.
 */
function ErrorBoundaryInner(_ref) {
  var children = _ref.children,
    dragController = _ref.dragController;
  var isDraggingRef = useRef(false);
  var handleWindowError = useCallback(function (event) {
    var dragState = dragController.getDragState();
    if (!dragState.isDragging) {
      return;
    }
    if (dragState.mode === 'FLUID') {
      cancelPointerDrag();
    }
    if (dragState.mode === 'SNAP') {
      dragController.stopDrag({
        reason: 'CANCEL'
      });
    }
    if (process.env.NODE_ENV !== 'production') {
      warning("\n          An error was caught by our window 'error' event listener while a drag was occurring.\n          The active drag has been aborted.\n        ");
    }
    var err = event.error;
    if (err instanceof RbdInvariant) {
      // Marking the event as dealt with.
      // This will prevent any 'uncaught' error warnings in the console
      event.preventDefault();
      if (process.env.NODE_ENV !== 'production') {
        error(err.message);
      }
    }
  }, [dragController]);
  useEffect(function () {
    return combine(monitorForElements({
      onDragStart: function onDragStart() {
        isDraggingRef.current = true;
      },
      onDrop: function onDrop() {
        isDraggingRef.current = false;
      }
    }),
    // @ts-expect-error - type narrowing isn't working on the error param
    bind(window, {
      type: 'error',
      listener: handleWindowError
    }));
  }, [handleWindowError]);
  return children;
}

/**
 * Cancels drags when errors occur.
 */
// We have to use a class component to create an error boundary
// eslint-disable-next-line @repo/internal/react/no-class-components
export var ErrorBoundary = /*#__PURE__*/function (_React$Component) {
  function ErrorBoundary() {
    _classCallCheck(this, ErrorBoundary);
    return _callSuper(this, ErrorBoundary, arguments);
  }
  _inherits(ErrorBoundary, _React$Component);
  return _createClass(ErrorBoundary, [{
    key: "componentDidCatch",
    value: function componentDidCatch(err) {
      if (err instanceof RbdInvariant) {
        if (process.env.NODE_ENV !== 'production') {
          error(err.message);
        }
        return;
      }

      // throwing error for other error boundaries
      throw err;
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement(ErrorBoundaryInner, {
        contextId: this.props.contextId,
        dragController: this.props.dragController
      }, this.props.children);
    }
  }], [{
    key: "getDerivedStateFromError",
    value: function getDerivedStateFromError() {
      // Intentionally blank, because this method needs to be defined
    }
  }]);
}(React.Component);