import { Client } from './Client';
import { type FeatureFlagValue, type WithDocComments } from './types';
export { type EvaluationDetails, EvaluationReason } from './compat/types';
export type { LocalOverrides } from './PersistentOverrideAdapter';
export { DynamicConfig } from './compat/DynamicConfig';
export type { AnalyticsWebClient, BaseClientOptions, CheckGateOptions, ClientOptions, CustomAttributes, FromValuesClientOptions, FrontendExperimentsResult, GetExperimentOptions, GetExperimentValueOptions, Identifiers, InitializeValues, OptionsWithDefaults, UpdateUserCompletionCallback, Provider, } from './types';
export { FeatureGateEnvironment, PerimeterType } from './types';
export { CLIENT_VERSION } from './version';
declare global {
    interface Window {
        __FEATUREGATES_JS__: StaticFeatureGatesClient;
        __CRITERION__?: {
            addFeatureFlagAccessed?: (flagName: string, flagValue: FeatureFlagValue) => void;
            addUFOHold?: (id: string, name: string, labelStack: string, startTime: number) => void;
            removeUFOHold?: (id: string) => void;
            getFeatureFlagOverride?: (flagName: string) => boolean | undefined;
            getExperimentValueOverride?: <T>(experimentName: string, parameterName: string) => T;
        };
    }
}
/**
 * Access the FeatureGates object via the default export.
 * ```ts
 * import FeatureGates from '@atlaskit/feature-gate-js-client';
 * ```
 */
declare class FeatureGates {
    private static client;
    private static hasCheckGateErrorOccurred;
    private static hasGetExperimentValueErrorOccurred;
    static checkGate: Client['checkGate'];
    static isGateExists(gateName: string): boolean;
    static isExperimentExists(experimentName: string): boolean;
    static getExperimentValue: Client['getExperimentValue'];
    static initializeCalled: () => boolean;
    static initializeCompleted: () => boolean;
    static initialize: (clientOptions: import("./types").ClientOptions, identifiers: import("./types").Identifiers, customAttributes?: import("./types").CustomAttributes | undefined) => Promise<void>;
    static initializeWithProvider: (clientOptions: import("./types").BaseClientOptions, provider: import("./types").Provider, identifiers: import("./types").Identifiers, customAttributes?: import("./types").CustomAttributes | undefined) => Promise<void>;
    static initializeFromValues: (clientOptions: import("./types").FromValuesClientOptions, identifiers: import("./types").Identifiers, customAttributes?: import("./types").CustomAttributes | undefined, initializeValues?: Record<string, unknown>) => Promise<void>;
    static manuallyLogGateExposure: (gateName: string) => void;
    static getExperiment: (experimentName: string, options?: import("./types").GetExperimentOptions) => import("./compat/DynamicConfig").DynamicConfig;
    static manuallyLogExperimentExposure: (experimentName: string) => void;
    static manuallyLogLayerExposure: (layerName: string, parameterName: string) => void;
    static shutdownStatsig: () => void;
    static overrideGate: (gateName: string, value: boolean) => void;
    static clearGateOverride: (gateName: string) => void;
    static overrideConfig: (experimentName: string, values: Record<string, unknown>) => void;
    static clearConfigOverride: (experimentName: string) => void;
    static setOverrides: (overrides: Partial<import("./PersistentOverrideAdapter").LocalOverrides>) => void;
    static getOverrides: () => import("./PersistentOverrideAdapter").LocalOverrides;
    static clearAllOverrides: () => void;
    static isCurrentUser: (identifiers: import("./types").Identifiers, customAttributes?: import("./types").CustomAttributes | undefined) => boolean;
    static onGateUpdated: (gateName: string, callback: (value: boolean) => void, options?: import("./types").CheckGateOptions) => () => void;
    static onExperimentValueUpdated: <T>(experimentName: string, parameterName: string, defaultValue: T, callback: (value: T) => void, options?: import("./types").GetExperimentValueOptions<T>) => () => void;
    static onAnyUpdated: (callback: () => void) => () => void;
    static updateUser: (fetchOptions: import("./fetcher").FetcherOptions, identifiers: import("./types").Identifiers, customAttributes?: import("./types").CustomAttributes | undefined) => Promise<void>;
    static updateUserWithProvider: (identifiers: import("./types").Identifiers, customAttributes?: import("./types").CustomAttributes | undefined) => Promise<void>;
    static updateUserWithValues: (identifiers: import("./types").Identifiers, customAttributes?: import("./types").CustomAttributes | undefined, initializeValues?: Record<string, unknown>) => Promise<void>;
    static getPackageVersion: () => string;
    static getLayer: (layerName: string, options?: import("./types").GetLayerOptions) => import("..").Layer;
    static getLayerValue: <T>(layerName: string, parameterName: string, defaultValue: T, options?: import("./types").GetLayerValueOptions<T>) => T;
}
type StaticFeatureGatesClient = WithDocComments<typeof FeatureGates, Client>;
declare let boundFGJS: StaticFeatureGatesClient;
/**
 * @property {FeatureGates} FeatureGate default export
 */
export default boundFGJS;
