import React from 'react';
import { type ThemeState } from '@atlaskit/tokens';
export type Theme = Omit<ThemeState, 'colorMode' | 'contrastMode'>;
export type ColorMode = 'light' | 'dark' | 'auto';
type ReconciledColorMode = Exclude<ColorMode, 'auto'>;
/**
 * __UNSAFE_useColorModeForMigration()__
 *
 * Returns the current color mode when inside the app provider.
 * Unlike useColorMode, this utility returns undefined, instead of throwing an error, when the app provider is missing.
 * This allows it to be used by components that need to operate with and without an app provider.
 */
export declare function UNSAFE_useColorModeForMigration(): ReconciledColorMode | undefined;
/**
 * __useColorMode()__
 *
 * Returns the current color mode when inside the app provider.
 */
export declare function useColorMode(): ReconciledColorMode;
/**
 * __useSetColorMode()__
 *
 * Returns the color mode setter when inside the app provider.
 */
export declare function useSetColorMode(): (value: ColorMode) => void;
/**
 * __useTheme()__
 *
 * Returns the current theme settings when inside the app provider.
 */
export declare function useTheme(): Partial<Theme>;
/**
 * __useSetTheme()__
 *
 * Returns the theme setter when inside the app provider.
 */
export declare function useSetTheme(): (value: Partial<Theme>) => void;
interface ThemeProviderProps {
    defaultColorMode: ColorMode;
    defaultTheme?: Partial<Theme>;
    children: React.ReactNode;
}
/**
 * __Theme provider__
 *
 * Provides global theming configuration.
 *
 * @internal
 */
declare function ThemeProvider({ children, defaultColorMode, defaultTheme }: ThemeProviderProps): React.JSX.Element;
export default ThemeProvider;
