"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _excluded = ["analyticsId", "analyticsData"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = (0, _getPrototypeOf2.default)(o), (0, _possibleConstructorReturn2.default)(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], (0, _getPrototypeOf2.default)(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/**
 * The withAnalytics HOC wraps a component and provides the `fireAnalyticsEvent`
 * and `firePrivateAnalyticsEvent` methods to it as props. It contains the logic
 * for how to fire events, including handling the analyticsId and analyticsData
 * props. The `map` argument may be an object or a function that returns an object.
 * The properties of the `map` object/result can be strings (the name of the event
 * that will be fired) or functions (which are responsible for firing the event).
 * You can specify a default `analyticsId` and `analyticsData` with the `defaultProps`
 * param. Please be aware that specifying a default `analyticsId` will cause public
 * events to always fire for your component unless it has been set to a falsy by
 * the component consumer.
 *
 * @param WrappedComponent
 * @param map
 * @param defaultProps
 * @param withDelegation
 */
var withAnalytics = function withAnalytics(WrappedComponent) {
  var _WithAnalytics;
  var map = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var defaultProps = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var withDelegation = arguments.length > 3 ? arguments[3] : undefined;
  return _WithAnalytics = /*#__PURE__*/function (_Component) {
    function WithAnalytics(props) {
      var _this;
      (0, _classCallCheck2.default)(this, WithAnalytics);
      _this = _callSuper(this, WithAnalytics, [props]);
      (0, _defineProperty2.default)(_this, "delegateAnalyticsEvent", function (analyticsId, data, isPrivate) {
        var _ref = _this.context,
          onAnalyticsEvent = _ref.onAnalyticsEvent;
        if (!onAnalyticsEvent) {
          return;
        }
        onAnalyticsEvent(analyticsId, data, isPrivate);
      });
      (0, _defineProperty2.default)(_this, "fireAnalyticsEvent", function (name, data) {
        var _this$props = _this.props,
          analyticsData = _this$props.analyticsData,
          analyticsId = _this$props.analyticsId;
        var _ref2 = _this.context,
          onAnalyticsEvent = _ref2.onAnalyticsEvent;
        if (!analyticsId || !onAnalyticsEvent) {
          return;
        }
        var eventData = _objectSpread(_objectSpread({}, analyticsData), data);
        onAnalyticsEvent("".concat(analyticsId, ".").concat(name), eventData, false);
      });
      (0, _defineProperty2.default)(_this, "privateAnalyticsEvent", function (name, data) {
        var _ref3 = _this.context,
          onAnalyticsEvent = _ref3.onAnalyticsEvent;
        if (!onAnalyticsEvent) {
          return;
        }
        onAnalyticsEvent("".concat(name), data, true);
      });
      (0, _defineProperty2.default)(_this, "getParentAnalyticsData", function (name) {
        var _ref4 = _this.context,
          getParentAnalyticsData = _ref4.getParentAnalyticsData;
        var parentData = {};
        if (typeof getParentAnalyticsData === 'function' && _this.props.analyticsId) {
          var analyticsId = _this.props.analyticsId;
          parentData = getParentAnalyticsData("".concat(analyticsId, ".").concat(name), false);
        }
        return parentData;
      });
      _this.state = {
        evaluatedMap: {}
      };
      return _this;
    }
    (0, _inherits2.default)(WithAnalytics, _Component);
    return (0, _createClass2.default)(WithAnalytics, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.setState({
          evaluatedMap: typeof map === 'function' ? map(this.fireAnalyticsEvent) : map
        });
      }
    }, {
      key: "render",
      value: function render() {
        var _this2 = this;
        var _this$props2 = this.props,
          analyticsId = _this$props2.analyticsId,
          analyticsData = _this$props2.analyticsData,
          componentProps = (0, _objectWithoutProperties2.default)(_this$props2, _excluded);
        Object.keys(this.state.evaluatedMap).forEach(function (prop) {
          var handler = _this2.state.evaluatedMap[prop];
          var originalProp = componentProps[prop];
          componentProps[prop] = function () {
            if (typeof handler === 'function') {
              handler.apply(void 0, arguments);
            } else {
              _this2.fireAnalyticsEvent(handler);
            }
            if (typeof originalProp === 'function') {
              originalProp.apply(void 0, arguments);
            }
          };
        });
        return /*#__PURE__*/_react.default.createElement(WrappedComponent, (0, _extends2.default)({
          fireAnalyticsEvent: this.fireAnalyticsEvent,
          firePrivateAnalyticsEvent: this.privateAnalyticsEvent,
          getParentAnalyticsData: this.getParentAnalyticsData,
          delegateAnalyticsEvent: withDelegation ? this.delegateAnalyticsEvent : undefined,
          analyticsId: analyticsId,
          ref: this.props.innerRef
        }, componentProps));
      }
    }]);
  }(_react.Component), (0, _defineProperty2.default)(_WithAnalytics, "displayName", "WithAnalytics(".concat(WrappedComponent.displayName || WrappedComponent.name, ")")), (0, _defineProperty2.default)(_WithAnalytics, "contextTypes", {
    onAnalyticsEvent: _propTypes.default.func,
    getParentAnalyticsData: _propTypes.default.func
  }), (0, _defineProperty2.default)(_WithAnalytics, "defaultProps", {
    analyticsId: defaultProps.analyticsId,
    analyticsData: defaultProps.analyticsData
  }), _WithAnalytics;
};
var _default = exports.default = withAnalytics;