/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.ArrayFunctionBuiltins;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.ArrayAllocationSite;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.SparseArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractConstantArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantByteArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantEmptyPrototypeArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantIntArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.LazyArray;
import com.oracle.truffle.js.runtime.array.dyn.LazyRegexResultArray;
import com.oracle.truffle.js.runtime.array.dyn.LazyRegexResultIndicesArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedIntArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import java.util.ArrayList;
import java.util.List;

public final class JSArray
extends JSAbstractArray
implements JSConstructorFactory.WithFunctionsAndSpecies,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("Array");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("Array.prototype");
    public static final JSArray INSTANCE = new JSArray();
    static final ArrayLengthProxyProperty ARRAY_LENGTH_PROPERTY_PROXY = new ArrayLengthProxyProperty();

    private JSArray() {
    }

    public static JSArrayObject createConstant(JSContext context2, JSRealm realm, Object[] elements) {
        return JSArray.create(context2, realm, ScriptArray.createConstantArray(elements), elements, elements.length);
    }

    public static JSArrayObject createEmpty(JSContext context2, JSRealm realm, int length2) {
        if (length2 < 0) {
            throw Errors.createRangeErrorInvalidArrayLength();
        }
        return JSArray.createEmptyChecked(context2, realm, length2);
    }

    private static JSArrayObject createEmptyChecked(JSContext context2, JSRealm realm, int length2) {
        return JSArray.createConstantEmptyArray(context2, realm, length2);
    }

    public static JSArrayObject createEmpty(JSContext context2, JSRealm realm, long length2) {
        if (!JSRuntime.isValidArrayLength(length2)) {
            throw Errors.createRangeErrorInvalidArrayLength();
        }
        if (length2 > Integer.MAX_VALUE) {
            return JSArray.createSparseArray(context2, realm, length2);
        }
        return JSArray.createEmptyChecked(context2, realm, length2);
    }

    public static JSArrayObject createEmptyChecked(JSContext context2, JSRealm realm, long length2) {
        assert (0L <= length2 && length2 <= Integer.MAX_VALUE);
        return JSArray.createConstantEmptyArray(context2, realm, (int)length2);
    }

    public static JSArrayObject createEmptyChecked(JSContext context2, JSRealm realm, JSDynamicObject proto, long length2) {
        assert (0L <= length2 && length2 <= Integer.MAX_VALUE);
        return JSArray.createConstantEmptyArray(context2, realm, proto, null, (int)length2);
    }

    public static JSArrayObject createEmptyZeroLength(JSContext context2, JSRealm realm) {
        return JSArray.createConstantEmptyArray(context2, realm);
    }

    public static JSArrayObject create(JSContext context2, JSRealm realm, ScriptArray arrayType, Object array, long length2) {
        return JSArray.create(context2, realm, arrayType, array, length2, 0);
    }

    public static JSArrayObject create(JSContext context2, JSRealm realm, ScriptArray arrayType, Object array, long length2, int usedLength) {
        return JSArray.create(context2, realm, arrayType, array, length2, usedLength, 0, 0);
    }

    public static JSArrayObject create(JSContext context2, JSRealm realm, ScriptArray arrayType, Object array, long length2, int usedLength, int indexOffset, int arrayOffset) {
        return JSArray.create(context2, realm, arrayType, array, length2, usedLength, indexOffset, arrayOffset, 0);
    }

    public static JSArrayObject create(JSContext context2, JSRealm realm, ScriptArray arrayType, Object array, long length2, int usedLength, int indexOffset, int arrayOffset, int holeCount) {
        return JSArray.createDefaultProto(context2, realm, arrayType, array, null, length2, usedLength, indexOffset, arrayOffset, holeCount);
    }

    public static JSArrayObject create(JSContext context2, JSRealm realm, JSDynamicObject proto, ScriptArray arrayType, Object array, long length2) {
        return JSArray.create(context2, realm, proto, arrayType, array, length2, 0);
    }

    public static JSArrayObject create(JSContext context2, JSRealm realm, JSDynamicObject proto, ScriptArray arrayType, Object array, long length2, int usedLength) {
        return JSArray.create(context2, realm, proto, arrayType, array, length2, usedLength, 0, 0);
    }

    public static JSArrayObject create(JSContext context2, JSRealm realm, JSDynamicObject proto, ScriptArray arrayType, Object array, long length2, int usedLength, int indexOffset, int arrayOffset) {
        return JSArray.create(context2, realm, proto, arrayType, array, length2, usedLength, indexOffset, arrayOffset, 0);
    }

    public static JSArrayObject create(JSContext context2, JSRealm realm, JSDynamicObject proto, ScriptArray arrayType, Object array, long length2, int usedLength, int indexOffset, int arrayOffset, int holeCount) {
        return JSArray.createWithProto(context2, realm, proto, arrayType, array, null, length2, usedLength, indexOffset, arrayOffset, holeCount);
    }

    public static JSArrayObject createDefaultProto(JSContext context2, JSRealm realm, ScriptArray arrayType, Object array, ArrayAllocationSite site, long length2, int usedLength, int indexOffset, int arrayOffset, int holeCount) {
        JSObjectFactory factory = context2.getArrayFactory();
        return JSArray.createImpl(factory, realm, factory.getPrototype(realm), arrayType, array, site, length2, usedLength, indexOffset, arrayOffset, holeCount);
    }

    public static JSArrayObject createWithProto(JSContext context2, JSRealm realm, JSDynamicObject prototype, ScriptArray arrayType, Object array, ArrayAllocationSite site, long length2, int usedLength, int indexOffset, int arrayOffset, int holeCount) {
        JSObjectFactory factory = context2.getArrayFactory();
        return JSArray.createImpl(factory, realm, prototype, arrayType, array, site, length2, usedLength, indexOffset, arrayOffset, holeCount);
    }

    private static JSArrayObject createImpl(JSObjectFactory factory, JSRealm realm, JSDynamicObject prototype, ScriptArray arrayType, Object array, ArrayAllocationSite site, long length2, int usedLength, int indexOffset, int arrayOffset, int holeCount) {
        assert (JSRuntime.isRepresentableAsUnsignedInt(length2));
        Shape shape = factory.getShape(realm, prototype);
        JSArrayObject newObj = factory.initProto(new JSArrayObject(shape, prototype, arrayType, array, site, length2, usedLength, indexOffset, arrayOffset, holeCount), realm, prototype);
        return factory.trackAllocation(newObj);
    }

    public static boolean isJSArray(Object obj) {
        return obj instanceof JSArrayObject;
    }

    public static boolean isJSFastArray(Object obj) {
        return JSArray.isJSArray(obj) && JSArray.isJSFastArray((JSArrayObject)obj);
    }

    public static boolean isJSFastArray(JSDynamicObject obj) {
        return JSArray.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public TruffleString getClassName(JSDynamicObject object) {
        return this.getClassName();
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSContext ctx = realm.getContext();
        Shape protoShape = JSShape.createPrototypeShape(ctx, INSTANCE, realm.getObjectPrototype());
        JSArrayObject arrayPrototype = JSArrayObject.createEmpty(protoShape, realm.getObjectPrototype(), ConstantEmptyPrototypeArray.createConstantEmptyPrototypeArray());
        JSObjectUtil.setOrVerifyPrototype(ctx, arrayPrototype, realm.getObjectPrototype());
        JSDynamicObject.setObjectFlags(arrayPrototype, JSDynamicObject.getObjectFlags(arrayPrototype) | 0x10);
        assert (JSArray.isArrayPrototype(arrayPrototype));
        JSObjectUtil.putConstructorProperty(arrayPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, arrayPrototype, ArrayPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putProxyProperty(arrayPrototype, LENGTH, ARRAY_LENGTH_PROPERTY_PROXY, JSAttributes.notConfigurableNotEnumerableWritable());
        if (ctx.getEcmaScriptVersion() >= 6) {
            JSObjectUtil.putDataProperty(arrayPrototype, Symbol.SYMBOL_ITERATOR, JSDynamicObject.getOrNull(arrayPrototype, Strings.VALUES), JSAttributes.getDefaultNotEnumerable());
            JSObjectUtil.putDataProperty(arrayPrototype, Symbol.SYMBOL_UNSCOPABLES, JSArray.createUnscopables(ctx, JSArray.unscopableNameList(ctx)), JSAttributes.configurableNotEnumerableNotWritable());
        }
        return arrayPrototype;
    }

    private static List<TruffleString> unscopableNameList(JSContext context2) {
        ArrayList<TruffleString> names = new ArrayList<TruffleString>();
        if (context2.getEcmaScriptVersion() >= 13) {
            names.add(Strings.AT);
        }
        names.add(Strings.COPY_WITHIN);
        names.add(Strings.ENTRIES);
        names.add(Strings.FILL);
        names.add(Strings.FIND);
        names.add(Strings.FIND_INDEX);
        if (context2.getEcmaScriptVersion() >= 14) {
            names.add(Strings.FIND_LAST);
            names.add(Strings.FIND_LAST_INDEX);
        }
        if (context2.getEcmaScriptVersion() >= 10) {
            names.add(Strings.FLAT);
            names.add(Strings.FLAT_MAP);
        }
        if (context2.getEcmaScriptVersion() >= 15) {
            names.add(Strings.GROUP);
            names.add(Strings.GROUP_TO_MAP);
        }
        if (context2.getEcmaScriptVersion() >= 7) {
            names.add(Strings.INCLUDES);
        }
        names.add(Strings.KEYS);
        if (context2.getEcmaScriptVersion() >= 14) {
            names.add(Strings.TO_REVERSED);
            names.add(Strings.TO_SORTED);
            names.add(Strings.TO_SPLICED);
        }
        names.add(Strings.VALUES);
        assert (JSArray.isSorted(names));
        return names;
    }

    private static boolean isSorted(List<TruffleString> list2) {
        for (int i = 0; i < list2.size() - 1; ++i) {
            if (list2.get(i).compareCharsUTF16Uncached(list2.get(i + 1)) <= 0) continue;
            return false;
        }
        return true;
    }

    private static JSObject createUnscopables(JSContext context2, List<TruffleString> unscopableNames) {
        JSObject unscopables = JSOrdinary.createWithNullPrototypeInit(context2);
        for (TruffleString name : unscopableNames) {
            JSObjectUtil.putDataProperty(unscopables, name, true, JSAttributes.getDefault());
        }
        return unscopables;
    }

    @Override
    public Shape makeInitialShape(JSContext context2, JSDynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context2);
        initialShape = Shape.newBuilder(initialShape).addConstantProperty(LENGTH, ARRAY_LENGTH_PROPERTY_PROXY, JSAttributes.notConfigurableNotEnumerableWritable() | 0x10).build();
        return initialShape;
    }

    @Override
    public List<Object> getOwnPropertyKeys(JSDynamicObject thisObj, boolean strings, boolean symbols) {
        return JSArray.ownPropertyKeysFastArray(thisObj, strings, symbols);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, ArrayFunctionBuiltins.BUILTINS);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean setLength(JSDynamicObject store, Object value2, Node originatingNode) {
        long arrLength = 0L;
        arrLength = value2 instanceof Integer && (Integer)value2 >= 0 ? (long)((Integer)value2).intValue() : JSArray.toArrayLengthOrRangeError(value2, originatingNode);
        assert (arrLength >= 0L);
        return !JSAbstractArray.arrayGetArrayType(store).isLengthNotWritable() && ((JSAbstractArray)JSObject.getJSClass(store)).setLength(store, arrLength, false);
    }

    public static JSArrayObject createConstantEmptyArray(JSContext context2, JSRealm realm, int capacity) {
        AbstractConstantArray arrayType = ScriptArray.createConstantEmptyArray();
        return JSArray.create(context2, realm, arrayType, ScriptArray.EMPTY_OBJECT_ARRAY, capacity);
    }

    public static JSArrayObject createConstantEmptyArray(JSContext context2, JSRealm realm) {
        return JSArray.createConstantEmptyArray(context2, realm, 0);
    }

    public static JSArrayObject createConstantEmptyArray(JSContext context2, JSRealm realm, JSDynamicObject prototype, ArrayAllocationSite site) {
        return JSArray.createConstantEmptyArray(context2, realm, prototype, site, 0);
    }

    public static JSArrayObject createConstantEmptyArray(JSContext context2, JSRealm realm, JSDynamicObject prototype, ArrayAllocationSite site, int capacity) {
        AbstractConstantArray arrayType = ScriptArray.createConstantEmptyArray();
        return JSArray.createWithProto(context2, realm, prototype, arrayType, ScriptArray.EMPTY_OBJECT_ARRAY, site, capacity, 0, 0, 0, 0);
    }

    public static JSArrayObject createConstantByteArray(JSContext context2, JSRealm realm, byte[] byteArray) {
        ConstantByteArray arrayType = ConstantByteArray.createConstantByteArray();
        return JSArray.create(context2, realm, arrayType, byteArray, byteArray.length);
    }

    public static JSArrayObject createConstantIntArray(JSContext context2, JSRealm realm, int[] intArray) {
        ConstantIntArray arrayType = ConstantIntArray.createConstantIntArray();
        return JSArray.create(context2, realm, arrayType, intArray, intArray.length);
    }

    public static JSArrayObject createConstantDoubleArray(JSContext context2, JSRealm realm, double[] doubleArray) {
        ConstantDoubleArray arrayType = ConstantDoubleArray.createConstantDoubleArray();
        return JSArray.create(context2, realm, arrayType, doubleArray, doubleArray.length);
    }

    public static JSArrayObject createConstantObjectArray(JSContext context2, JSRealm realm, Object[] objectArray) {
        ConstantObjectArray arrayType = ConstantObjectArray.createConstantObjectArray();
        return JSArray.create(context2, realm, arrayType, objectArray, objectArray.length);
    }

    public static JSArrayObject createZeroBasedHolesObjectArray(JSContext context2, JSRealm realm, Object[] objectArray, int usedLength, int arrayOffset, int holeCount) {
        return JSArray.create(context2, realm, HolesObjectArray.createHolesObjectArray(), objectArray, objectArray.length, usedLength, 0, arrayOffset, holeCount);
    }

    public static JSArrayObject createZeroBasedIntArray(JSContext context2, JSRealm realm, int[] intArray) {
        return JSArray.create(context2, realm, ZeroBasedIntArray.createZeroBasedIntArray(), intArray, intArray.length, intArray.length, 0, 0);
    }

    public static JSArrayObject createZeroBasedDoubleArray(JSContext context2, JSRealm realm, double[] doubleArray) {
        return JSArray.create(context2, realm, ZeroBasedDoubleArray.createZeroBasedDoubleArray(), doubleArray, doubleArray.length, doubleArray.length, 0, 0);
    }

    public static JSArrayObject createZeroBasedIntArray(JSContext context2, JSRealm realm, JSDynamicObject proto, int[] intArray) {
        return JSArray.create(context2, realm, proto, ZeroBasedIntArray.createZeroBasedIntArray(), intArray, (long)intArray.length, intArray.length, 0, 0);
    }

    public static JSArrayObject createZeroBasedDoubleArray(JSContext context2, JSRealm realm, JSDynamicObject proto, double[] doubleArray) {
        return JSArray.create(context2, realm, proto, ZeroBasedDoubleArray.createZeroBasedDoubleArray(), doubleArray, (long)doubleArray.length, doubleArray.length, 0, 0);
    }

    public static JSArrayObject createZeroBasedObjectArray(JSContext context2, JSRealm realm, Object[] objectArray) {
        return JSArray.create(context2, realm, ZeroBasedObjectArray.createZeroBasedObjectArray(), objectArray, objectArray.length, objectArray.length, 0, 0);
    }

    public static JSArrayObject createZeroBasedJSObjectArray(JSContext context2, JSRealm realm, JSDynamicObject[] objectArray) {
        return JSArray.create(context2, realm, ZeroBasedJSObjectArray.createZeroBasedJSObjectArray(), objectArray, objectArray.length, objectArray.length, 0, 0);
    }

    public static JSArrayObject createSparseArray(JSContext context2, JSRealm realm, long length2) {
        return JSArray.create(context2, realm, SparseArray.createSparseArray(), SparseArray.createArrayMap(), length2);
    }

    public static JSArrayObject createSparseArray(JSContext context2, JSRealm realm, JSDynamicObject proto, long length2) {
        return JSArray.create(context2, realm, proto, SparseArray.createSparseArray(), SparseArray.createArrayMap(), length2);
    }

    public static JSArrayObject createLazyRegexArray(JSContext context2, JSRealm realm, int length2) {
        assert (JSRuntime.isRepresentableAsUnsignedInt(length2));
        Object[] array = new Object[length2];
        return JSArray.create(context2, realm, LazyRegexResultArray.createLazyRegexResultArray(), array, length2);
    }

    public static JSArrayObject createLazyRegexArray(JSContext context2, JSRealm realm, int length2, Object regexResult, TruffleString input, JSDynamicObject groups, JSDynamicObject indicesGroups) {
        assert (JSRuntime.isRepresentableAsUnsignedInt(length2));
        JSArrayObject obj = JSArray.createLazyRegexArray(context2, realm, length2);
        JSObjectUtil.putHiddenProperty(obj, LAZY_REGEX_RESULT_ID, regexResult);
        JSObjectUtil.putHiddenProperty(obj, LAZY_REGEX_ORIGINAL_INPUT_ID, input);
        JSObjectUtil.putProxyProperty(obj, JSRegExp.INDEX, JSRegExp.LAZY_INDEX_PROXY, JSAttributes.getDefault());
        JSObjectUtil.putDataProperty(obj, JSRegExp.INPUT, input, JSAttributes.getDefault());
        JSObjectUtil.putDataProperty(obj, JSRegExp.GROUPS, groups, JSAttributes.getDefault());
        if (context2.isOptionRegexpMatchIndices()) {
            JSArrayObject indices = JSArray.createLazyRegexIndicesArray(context2, realm, length2, regexResult, indicesGroups);
            JSObjectUtil.putDataProperty(obj, JSRegExp.INDICES, indices, JSAttributes.getDefault());
        }
        assert (JSArray.isJSArray(obj));
        return obj;
    }

    public static JSArrayObject createLazyRegexIndicesArray(JSContext context2, JSRealm realm, int length2) {
        assert (JSRuntime.isRepresentableAsUnsignedInt(length2));
        Object[] array = new Object[length2];
        return JSArray.create(context2, realm, LazyRegexResultIndicesArray.createLazyRegexResultIndicesArray(), array, length2);
    }

    private static JSArrayObject createLazyRegexIndicesArray(JSContext context2, JSRealm realm, int length2, Object regexResult, JSDynamicObject indicesGroups) {
        assert (JSRuntime.isRepresentableAsUnsignedInt(length2));
        Object[] array = new Object[length2];
        JSArrayObject obj = JSArray.create(context2, realm, LazyRegexResultIndicesArray.createLazyRegexResultIndicesArray(), array, length2);
        JSObjectUtil.putHiddenProperty(obj, LAZY_REGEX_RESULT_ID, regexResult);
        JSObjectUtil.putDataProperty(obj, JSRegExp.GROUPS, indicesGroups, JSAttributes.getDefault());
        assert (JSArray.isJSArray(obj));
        return obj;
    }

    public static JSArrayObject createLazyArray(JSContext context2, JSRealm realm, List<?> list2, int size) {
        assert (list2.size() == size);
        return JSArray.create(context2, realm, LazyArray.createLazyArray(), list2, size);
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getArrayPrototype();
    }

    public static boolean isArrayPrototype(JSDynamicObject object) {
        return JSArray.isJSArray(object) && JSShape.isArrayPrototypeOrDerivative(object);
    }

    public static final class ArrayLengthProxyProperty
    extends PropertyProxy {
        @Override
        public Object get(JSDynamicObject store) {
            assert (JSArray.isJSArray(store));
            long length2 = INSTANCE.getLength(store);
            return (double)length2;
        }

        @Override
        public boolean set(JSDynamicObject store, Object value2) {
            assert (JSArray.isJSArray(store));
            return JSArray.setLength(store, value2, null);
        }
    }
}

