/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.components.DiagramContainerUi;
import com.intellij.diagram.components.DiagramNodeContainer;
import com.intellij.diagram.components.QuickDocHintHandler;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.components.BaseGraphStructureViewBuilder;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ComponentUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class DiagramNodeQuickDocHintManager
extends QuickDocHintHandler<Object> {
    @NotNull
    private final DiagramBuilder myBuilder;
    @NotNull
    private final DiagramNode<?> myNode;

    public DiagramNodeQuickDocHintManager(@NotNull DiagramNode<?> node, @NotNull DiagramBuilder builder) {
        if (node == null) {
            DiagramNodeQuickDocHintManager.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            DiagramNodeQuickDocHintManager.$$$reportNull$$$0(1);
        }
        this.myNode = node;
        this.myBuilder = builder;
    }

    @NotNull
    protected abstract Rectangle getDocOwnerBounds(Object var1);

    @NotNull
    protected DiagramBuilder getBuilder() {
        DiagramBuilder diagramBuilder = this.myBuilder;
        if (diagramBuilder == null) {
            DiagramNodeQuickDocHintManager.$$$reportNull$$$0(2);
        }
        return diagramBuilder;
    }

    @NotNull
    protected DiagramNode<?> getNode() {
        DiagramNode<?> diagramNode = this.myNode;
        if (diagramNode == null) {
            DiagramNodeQuickDocHintManager.$$$reportNull$$$0(3);
        }
        return diagramNode;
    }

    @Override
    public int getShowQuickDocHintDelay() {
        return DiagramContainerUi.getInstance().getShowQuickDocHintDelay();
    }

    @Override
    public @NotNull Promise<@Nullable JBPopup> createQuickDocHintFor(@NotNull Object element, @Nullable Consumer<ComponentPopupBuilder> popupCustomizer) {
        DiagramElementManager<?> elementManager;
        String tooltip;
        if (element == null) {
            DiagramNodeQuickDocHintManager.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)(tooltip = (elementManager = this.getBuilder().getProvider().getElementManager()).getNodeTooltip(element)))) {
            Promise<JBPopup> promise = DiagramContainerUi.getInstance().createQuickDocHintFor(element, popupCustomizer);
            if (promise == null) {
                DiagramNodeQuickDocHintManager.$$$reportNull$$$0(5);
            }
            return promise;
        }
        Promise<JBPopup> promise = DiagramContainerUi.getInstance().createSimpleHtmlTextHint(tooltip, popupCustomizer);
        if (promise == null) {
            DiagramNodeQuickDocHintManager.$$$reportNull$$$0(6);
        }
        return promise;
    }

    @Override
    @NotNull
    protected Component getHintPopupOwner(@NotNull JBPopup hintPopup) {
        if (hintPopup == null) {
            DiagramNodeQuickDocHintManager.$$$reportNull$$$0(7);
        }
        JComponent jComponent = this.myBuilder.getView().getCanvasComponent();
        if (jComponent == null) {
            DiagramNodeQuickDocHintManager.$$$reportNull$$$0(8);
        }
        return jComponent;
    }

    @Override
    protected void onQuickDocHintShown(@NotNull JBPopup hintPopup, Object element) {
        if (hintPopup == null) {
            DiagramNodeQuickDocHintManager.$$$reportNull$$$0(9);
        }
        DiagramContainerUi.getInstance().onQuickDocHintShown(new MyQuickDocPopupHandler(hintPopup));
    }

    @Override
    @NotNull
    protected MouseEvent preprocessEvent(@NotNull MouseEvent event) {
        if (event == null) {
            DiagramNodeQuickDocHintManager.$$$reportNull$$$0(10);
        }
        Point eventLocationOnNode = event.getPoint();
        SwingUtilities.convertPointToScreen(eventLocationOnNode, event.getComponent());
        DiagramNodeContainer container = (DiagramNodeContainer)((Object)ComponentUtil.getParentOfType(DiagramNodeContainer.class, (Component)event.getComponent()));
        if (container == null) {
            MouseEvent mouseEvent = event;
            if (mouseEvent == null) {
                DiagramNodeQuickDocHintManager.$$$reportNull$$$0(11);
            }
            return mouseEvent;
        }
        Node node = this.getBuilder().getNode(container.getNode());
        if (node == null) {
            MouseEvent mouseEvent = event;
            if (mouseEvent == null) {
                DiagramNodeQuickDocHintManager.$$$reportNull$$$0(12);
            }
            return mouseEvent;
        }
        Point nodeScreenCoords = GraphCanvasLocationService.getInstance().getNodeCoordinatesOnScreen(node, this.getBuilder().getGraphBuilder());
        double zoom = this.getBuilder().getView().getZoom();
        return new MouseEvent(event.getComponent(), event.getID(), event.getWhen(), event.getModifiersEx(), event.getX(), event.getY(), (int)Math.ceil((double)(eventLocationOnNode.x + 1) * zoom) + nodeScreenCoords.x, (int)Math.ceil((double)(eventLocationOnNode.y + 1) * zoom) + nodeScreenCoords.y, event.getClickCount(), event.isPopupTrigger(), event.getButton());
    }

    @Override
    @NotNull
    protected Point getQuickDocHintScreenLocation(@NotNull JBPopup hintPopup, Object docOwner) {
        ToolWindow structureViewWindow;
        ToolWindowAnchor structureViewAnchor;
        if (hintPopup == null) {
            DiagramNodeQuickDocHintManager.$$$reportNull$$$0(13);
        }
        Rectangle nodeBounds = GraphCanvasLocationService.getInstance().getNodeBoundsOnCanvas(Objects.requireNonNull(this.myBuilder.getNode(this.myNode)), this.myBuilder.getGraphBuilder());
        Rectangle itemBounds = this.getDocOwnerBounds(docOwner);
        double zoom = this.myBuilder.getView().getZoom();
        itemBounds.x = (int)((double)itemBounds.x * zoom);
        itemBounds.y = (int)((double)itemBounds.y * zoom);
        itemBounds.width = (int)((double)itemBounds.width * zoom);
        itemBounds.height = (int)((double)itemBounds.height * zoom);
        boolean doShowPopupOnTheRightOfTheNode = BaseGraphStructureViewBuilder.isLocalViewBuilder(this.myBuilder.getGraphBuilder()) ? (structureViewAnchor = Objects.requireNonNull(structureViewWindow = ToolWindowManager.getInstance((Project)this.myBuilder.getProject()).getToolWindow("Structure")).getAnchor()) == ToolWindowAnchor.LEFT : nodeBounds.getMinX() + nodeBounds.getWidth() / 2.0 < this.myBuilder.getView().getCanvasSize().getWidth() / 2.0;
        Dimension hintPopupSize = Objects.requireNonNullElseGet(hintPopup.getSize(), () -> hintPopup.getContent().getPreferredSize());
        Point hintLocation = new Point(nodeBounds.x + (doShowPopupOnTheRightOfTheNode ? (int)itemBounds.getMaxX() : (int)itemBounds.getMinX() - hintPopupSize.width), nodeBounds.y + (int)itemBounds.getMinY());
        SwingUtilities.convertPointToScreen(hintLocation, this.myBuilder.getView().getCanvasComponent());
        Point point = hintLocation;
        if (point == null) {
            DiagramNodeQuickDocHintManager.$$$reportNull$$$0(14);
        }
        return point;
    }

    @Override
    protected boolean isPopupDisabled() {
        EditMode editMode = this.myBuilder.getGraphBuilder().getEditMode();
        return !editMode.isActive() || editMode.getEditNodeMode().isActive() || editMode.getHotSpotMode().isActive() || super.isPopupDisabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 8, 11, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/components/DiagramNodeQuickDocHintManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintPopup";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/components/DiagramNodeQuickDocHintManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createQuickDocHintFor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHintPopupOwner";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessEvent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickDocHintScreenLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createQuickDocHintFor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHintPopupOwner";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onQuickDocHintShown";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEvent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getQuickDocHintScreenLocation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 8, 11, 12, 14 -> new IllegalStateException(string);
        };
    }

    private final class MyQuickDocPopupHandler
    implements DiagramContainerUi.QuickDocHintHandler {
        @NotNull
        private final JBPopup myHintPopup;

        MyQuickDocPopupHandler(JBPopup popup) {
            if (popup == null) {
                MyQuickDocPopupHandler.$$$reportNull$$$0(0);
            }
            this.myHintPopup = popup;
        }

        @Override
        @NotNull
        public JBPopup getPopup() {
            JBPopup jBPopup = this.myHintPopup;
            if (jBPopup == null) {
                MyQuickDocPopupHandler.$$$reportNull$$$0(1);
            }
            return jBPopup;
        }

        @Override
        @NotNull
        public Point getBestLocation() {
            Point point = DiagramNodeQuickDocHintManager.this.getQuickDocHintScreenLocation(this.myHintPopup, DiagramNodeQuickDocHintManager.this.getActiveHintDocOwner());
            if (point == null) {
                MyQuickDocPopupHandler.$$$reportNull$$$0(2);
            }
            return point;
        }

        @Override
        public void onClickInsidePopup() {
            DiagramNodeQuickDocHintManager.this.setKeepPopupOnMouseMove(true);
        }

        @Override
        public void closeHint() {
            DiagramNodeQuickDocHintManager.this.closeActiveHintIfPresent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "popup";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/components/DiagramNodeQuickDocHintManager$MyQuickDocPopupHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/components/DiagramNodeQuickDocHintManager$MyQuickDocPopupHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPopup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBestLocation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

