/*
 * Decompiled with CFR 0.152.
 */
package training.editor;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import java.lang.ref.WeakReference;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import training.lang.LangSupport;
import training.learn.LearnBundle;
import training.learn.lesson.LessonManager;
import training.util.PerformActionUtil;
import training.util.UtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R#\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0016\u0010\r\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Ltraining/editor/LearnProjectFileEditorListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "ref", "Ljava/lang/ref/WeakReference;", "Ltraining/lang/LangSupport;", "getRef", "()Ljava/lang/ref/WeakReference;", "ref$delegate", "Lkotlin/Lazy;", "langSupport", "getLangSupport", "()Ltraining/lang/LangSupport;", "fileOpened", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nLearnProjectFileEditorListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LearnProjectFileEditorListener.kt\ntraining/editor/LearnProjectFileEditorListener\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,58:1\n13402#2,2:59\n*S KotlinDebug\n*F\n+ 1 LearnProjectFileEditorListener.kt\ntraining/editor/LearnProjectFileEditorListener\n*L\n36#1:59,2\n*E\n"})
final class LearnProjectFileEditorListener
implements FileEditorManagerListener {
    @NotNull
    private final Lazy ref$delegate;

    public LearnProjectFileEditorListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.ref$delegate = LazyKt.lazy(() -> LearnProjectFileEditorListener.ref_delegate$lambda$0(project));
    }

    private final WeakReference<LangSupport> getRef() {
        Lazy lazy = this.ref$delegate;
        return (WeakReference)lazy.getValue();
    }

    private final LangSupport getLangSupport() {
        return (LangSupport)this.getRef().get();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        LangSupport langSupport = this.getLangSupport();
        if (langSupport == null) {
            return;
        }
        LangSupport langSupport2 = langSupport;
        Project project = source.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (ScratchUtil.isScratch((VirtualFile)file)) {
            return;
        }
        if (!langSupport2.blockProjectFileModification(project2, file)) {
            return;
        }
        FileEditor[] fileEditorArray = source.getAllEditors(file);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
        Object[] $this$forEach$iv = fileEditorArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorEx editorEx;
            FileEditor it = (FileEditor)element$iv;
            boolean bl = false;
            TextEditor textEditor = it instanceof TextEditor ? (TextEditor)it : null;
            Object object = textEditor != null ? textEditor.getEditor() : null;
            if ((object instanceof EditorEx ? (EditorEx)object : null) == null) continue;
            editorEx = editorEx;
            boolean bl2 = false;
            HyperlinkListener listener = arg_0 -> LearnProjectFileEditorListener.fileOpened$lambda$3$lambda$2$lambda$1(editorEx, project2, arg_0);
            Object[] objectArray = new Object[]{LearnBundle.INSTANCE.message("toolwindow.stripe.Learn", new Object[0])};
            String hint = LearnBundle.INSTANCE.message("learn.project.read.only.hint", objectArray);
            EditorModificationUtil.setReadOnlyHint((Editor)((Editor)editorEx), (String)hint, (HyperlinkListener)listener);
            editorEx.setViewer(true);
        }
    }

    private static final WeakReference ref_delegate$lambda$0(Project $project) {
        return new WeakReference<LangSupport>(UtilsKt.findLanguageSupport($project));
    }

    private static final void fileOpened$lambda$3$lambda$2$lambda$1(EditorEx $editorEx, Project $project, HyperlinkEvent event) {
        if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            String string = event.getDescription();
            if (Intrinsics.areEqual((Object)string, (Object)"ift.close")) {
                PerformActionUtil.performAction$default(PerformActionUtil.INSTANCE, "CloseProject", (Editor)$editorEx, $project, false, null, 16, null);
            } else if (Intrinsics.areEqual((Object)string, (Object)"ift.toolwindow")) {
                ToolWindow toolWindow = UtilsKt.learningToolWindow($project);
                if (toolWindow != null) {
                    toolWindow.show();
                }
                LessonManager.Companion.getInstance().focusTask();
            }
        }
    }
}

