/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssSupportsCondition;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssInvalidFunctionInspection
extends CssBaseInspection {
    private static final CssInspectionsUtil.CssInvalidValueRangeProvider INVALID_VALUE_RANGE_PROVIDER = new CssFunctionInvalidValueRangeProvider();

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssInvalidFunctionInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(){

            @Override
            public void visitCssFunction(@NotNull CssFunction function) {
                PsiElement parent;
                if (function == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((parent = function.getParent()) instanceof CssPseudoSelector || parent instanceof CssSupportsCondition) {
                    return;
                }
                String name = function.getName();
                if (name.equals("var")) {
                    return;
                }
                PsiElement functionNameElement = function.getFunctionNameElement();
                if (name.isEmpty() || functionNameElement == null) {
                    return;
                }
                Collection<? extends CssFunctionDescriptor> descriptors = function.getDescriptors();
                if (descriptors.isEmpty()) {
                    holder.registerProblem(functionNameElement, CssBundle.message("css.inspections.invalid.function.unknown.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    return;
                }
                Collection<? extends CssFunctionDescriptor> filteredByContextDescriptors = CssInspectionsUtil.filterDescriptorsByContextAndCheck(descriptors, functionNameElement, holder);
                CssInspectionsUtil.checkDescriptorValue(filteredByContextDescriptors, function, holder, "css.inspections.function.mismatched.parameters", INVALID_VALUE_RANGE_PROVIDER, false, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/psi/css/inspections/invalid/CssInvalidFunctionInspection$1", "visitCssFunction"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssInvalidFunctionInspection", "buildVisitor"));
    }

    private static class CssFunctionInvalidValueRangeProvider
    extends CssInspectionsUtil.CssInvalidValueRangeProvider {
        private CssFunctionInvalidValueRangeProvider() {
        }

        @Override
        public TextRange calculateInvalidRange(@NotNull CssValueOwner valueOwner, @Nullable PsiElement lastMatchedElement, @NotNull TextRange defaultValue) {
            if (valueOwner == null) {
                CssFunctionInvalidValueRangeProvider.$$$reportNull$$$0(0);
            }
            if (defaultValue == null) {
                CssFunctionInvalidValueRangeProvider.$$$reportNull$$$0(1);
            }
            if (valueOwner instanceof CssFunction) {
                CssFunction function = (CssFunction)valueOwner;
                TextRange functionTextRange = function.getTextRange();
                int functionStartOffset = functionTextRange.getStartOffset();
                if (lastMatchedElement != null) {
                    TextRange range;
                    PsiElement rParenthesis;
                    int endOfValue;
                    int startOfInvalidElements = lastMatchedElement.getTextRange().getEndOffset();
                    if (startOfInvalidElements == (endOfValue = Math.max(function.getTrimmedValueTextRange().getEndOffset(), startOfInvalidElements)) && (rParenthesis = function.getRParenthesis()) != null) {
                        endOfValue = rParenthesis.getTextRange().getEndOffset();
                    }
                    if (!(range = TextRange.create((int)startOfInvalidElements, (int)endOfValue)).isEmpty()) {
                        return range.shiftRight(-functionStartOffset);
                    }
                }
            }
            return super.calculateInvalidRange(valueOwner, lastMatchedElement, defaultValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "valueOwner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defaultValue";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidFunctionInspection$CssFunctionInvalidValueRangeProvider";
            objectArray[2] = "calculateInvalidRange";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

