/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.jetbrains.plugins.webDeployment.DeploymentMode;
import com.jetbrains.plugins.webDeployment.DeploymentPathChecker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeploymentPathUtils {
    private static final Logger LOG = Logger.getInstance(DeploymentPathUtils.class);
    public static final FileObject[] NO_CHILDREN = new FileObject[0];

    private DeploymentPathUtils() {
    }

    @Nullable
    public static FileObject getExcludedFile(ExecutionContext context, FileObject source, FileObject target) {
        FileObject remoteFile;
        FileObject localFile;
        String serverId = context.getServer().getId();
        List<ExcludedPath> paths = context.getConfig().getExcludedPaths(serverId);
        if (context.isServerSideModification()) {
            localFile = source;
            remoteFile = target;
        } else {
            localFile = target;
            remoteFile = source;
        }
        for (ExcludedPath path : paths) {
            if (path.isLocal()) {
                if (!path.isParentForLocalPath(DeploymentPathUtils.getLocalPath(localFile))) continue;
                LOG.debug("Skipping excluded local path in process: " + localFile.getName().getPath());
                return localFile;
            }
            if (!path.isParentForRemotePath(remoteFile.getName(), false, context.getServer())) continue;
            LOG.debug("Skipping excluded remote path in process: " + remoteFile.getName().getPath());
            return remoteFile;
        }
        return null;
    }

    public static FileType getType(FileObject target, boolean targetExists) throws FileSystemException {
        return targetExists ? target.getType() : FileType.IMAGINARY;
    }

    public static void refreshRemoteFile(FileObject file, ExecutionContextBase context) throws FileSystemException {
        DeploymentPathUtils.refreshRemoteFile(file, context, true);
    }

    private static void refreshRemoteFile(FileObject file, ExecutionContextBase context, boolean refreshFile) throws FileSystemException {
        if (PublishUtils.DISABLE_FILESYSTEM_CACHE) {
            context.addAffectedRoot(file.getName(), true);
            return;
        }
        FileObject parent = file.getParent();
        if (parent != null) {
            parent.refresh();
            if (refreshFile) {
                file.refresh();
            }
            if (!file.exists()) {
                DeploymentPathUtils.refreshRemoteFile(parent, context, false);
            }
            context.addAffectedRoot(parent.getName(), true);
        } else {
            file.refresh();
            context.addAffectedRoot(file.getName(), true);
        }
    }

    public static ErrorsAndExclusions processOutgoing(FileObject source, List<TransferOperation> result, ExecutionContext context) throws FileSystemException {
        String errorMessage = DeploymentPathUtils.getErrorMessageForUnsupportedName(source.getName(), context.getServer());
        if (errorMessage != null) {
            return ErrorsAndExclusions.reportErrors(Collections.singletonList(errorMessage));
        }
        Pair<DeploymentPathMapping, Boolean> mappingPair = context.isServerSideModification() ? context.getConfig().getNearestMappingForLocal(source, false, true, false, (Mappable)context.getServer()) : context.getConfig().getNearestMappingDeploy2Local(source, false, (Mappable)context.getServer());
        if (mappingPair.getFirst() == null && Boolean.TRUE == mappingPair.getSecond()) {
            return ErrorsAndExclusions.reportExcluded(source, context.isServerSideModification(), context);
        }
        DeploymentPathMapping mapping = (DeploymentPathMapping)mappingPair.getFirst();
        if (mapping != null) {
            FileObject target = context.isServerSideModification() ? context.findRemoteFile(mapping.mapToDeployPath(source, (Mappable)context.getServer()), true) : DeploymentPathUtils.getLocalFile(mapping.mapToLocalPath(source.getName(), (Mappable)context.getServer()));
            return new DeploymentPathProcessor(context, result, true).processPath(source, target, mapping);
        }
        Pair<List<DeploymentPathMapping>, Boolean> childMappingsPair = context.isServerSideModification() ? context.getConfig().getChildMappingsForLocal(source, true, false, (Mappable)context.getServer()) : context.getConfig().getChildMappingsDeploy2Local(source, (Mappable)context.getServer());
        ErrorsAndExclusions errorsAndExclusions = new ErrorsAndExclusions();
        if (((List)childMappingsPair.getFirst()).isEmpty() && Boolean.TRUE == childMappingsPair.getSecond()) {
            errorsAndExclusions.addExcludedPath(source, context.isServerSideModification(), context);
        }
        for (DeploymentPathMapping childMapping : (List)childMappingsPair.getFirst()) {
            FileObject targetChild;
            FileObject sourceChild;
            context.getProgressIndicator().checkCanceled();
            if (context.isServerSideModification()) {
                sourceChild = DeploymentPathUtils.getLocalFile(childMapping.getLocalPath());
                targetChild = context.findRemoteFile(childMapping.getFullDeployPath(context.getServer()), true);
            } else {
                sourceChild = context.findRemoteFile(childMapping.getFullDeployPath(context.getServer()), true);
                targetChild = DeploymentPathUtils.getLocalFile(childMapping.getLocalPath());
            }
            ErrorsAndExclusions e = new DeploymentPathProcessor(context, result, true).processPath(sourceChild, targetChild, childMapping);
            errorsAndExclusions.addAll(e);
        }
        return errorsAndExclusions;
    }

    public static ErrorsAndExclusions processIncoming(FileObject target, ExecutionContext context, List<TransferOperation> result) throws FileSystemException {
        Pair<DeploymentPathMapping, Boolean> mappingPair = context.isServerSideModification() ? context.getConfig().getNearestMappingDeploy2Local(target, false, (Mappable)context.getServer()) : context.getConfig().getNearestMappingForLocal(target, false, true, false, (Mappable)context.getServer());
        if (mappingPair.getFirst() == null && Boolean.TRUE == mappingPair.getSecond()) {
            return ErrorsAndExclusions.reportExcluded(target, context.isServerSideModification(), context);
        }
        DeploymentPathMapping mapping = (DeploymentPathMapping)mappingPair.getFirst();
        if (mapping != null) {
            FileObject source = context.isServerSideModification() ? DeploymentPathUtils.getLocalFile(mapping.mapToLocalPath(target.getName(), (Mappable)context.getServer())) : context.findRemoteFile(mapping.mapToDeployPath(target, (Mappable)context.getServer()), true);
            return new DeploymentPathProcessor(context, result, false).processPath(source, target, mapping);
        }
        Pair<List<DeploymentPathMapping>, Boolean> childMappings = context.isServerSideModification() ? context.getConfig().getChildMappingsDeploy2Local(target, (Mappable)context.getServer()) : context.getConfig().getChildMappingsForLocal(target, true, false, (Mappable)context.getServer());
        if (((List)childMappings.getFirst()).isEmpty() && Boolean.TRUE == childMappings.getSecond()) {
            return ErrorsAndExclusions.reportExcluded(target, context.isServerSideModification(), context);
        }
        ErrorsAndExclusions errorsAndExclusions = new ErrorsAndExclusions();
        for (DeploymentPathMapping childMapping : (List)childMappings.getFirst()) {
            FileObject targetChild;
            FileObject sourceChild;
            context.getProgressIndicator().checkCanceled();
            if (context.isServerSideModification()) {
                sourceChild = DeploymentPathUtils.getLocalFile(childMapping.getLocalPath());
                targetChild = context.findRemoteFile(childMapping.getFullDeployPath(context.getServer()), true);
            } else {
                sourceChild = context.findRemoteFile(childMapping.getFullDeployPath(context.getServer()), true);
                targetChild = DeploymentPathUtils.getLocalFile(childMapping.getLocalPath());
            }
            ErrorsAndExclusions e = new DeploymentPathProcessor(context, result, false).processPath(sourceChild, targetChild, childMapping);
            errorsAndExclusions.addAll(e);
        }
        return errorsAndExclusions;
    }

    @Nullable
    public static FileObject getLocalFile(String localPath) {
        File file = new File(localPath);
        try {
            return RemoteConnectionManager.getInstance().getManager().toFileObject(file);
        }
        catch (FileSystemException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public static String getFileName(WebServerConfig.RemotePath remotePath) {
        String path = remotePath.path.replace(File.separatorChar, '/');
        int i = path.lastIndexOf(47);
        return i != -1 ? path.substring(i + 1) : path;
    }

    @Nullable
    public static String getPathRemainder(String parentPath, String childPath, boolean caseSensitive) {
        if (StringUtil.isEmpty((String)parentPath)) {
            return null;
        }
        LOG.assertTrue(StringUtil.isNotEmpty((String)childPath));
        String parentPathIndependent = parentPath.replace(File.separatorChar, '/');
        String childPathIndependent = childPath.replace(File.separatorChar, '/');
        if (!caseSensitive) {
            parentPathIndependent = StringUtil.toLowerCase((String)parentPathIndependent);
            childPathIndependent = StringUtil.toLowerCase((String)childPathIndependent);
        }
        Object[] parentComponents = parentPathIndependent.split("/");
        Object[] childComponents = childPathIndependent.split("/");
        if (!ArrayUtil.startsWith((Object[])childComponents, (Object[])parentComponents)) {
            return null;
        }
        childComponents = childPath.replace(File.separatorChar, '/').split("/");
        String[] remainder = new String[childComponents.length - parentComponents.length];
        System.arraycopy(childComponents, parentComponents.length, remainder, 0, remainder.length);
        return StringUtil.join((String[])remainder, (String)"/");
    }

    public static boolean isAncestor(String ancestorPath, String path, boolean caseSensitive) {
        return DeploymentPathUtils.getPathRemainder(ancestorPath, path, caseSensitive) != null;
    }

    public static String getParentPath(WebServerConfig.RemotePath path) {
        return DeploymentPathUtils.getParentPath(path.path);
    }

    public static String getParentPath(String path) {
        String pathIndependent = path.replace(File.separatorChar, '/');
        int i = pathIndependent.lastIndexOf(47);
        return i != -1 ? path.substring(0, i) : path;
    }

    public static String getLocalPath(FileObject file) {
        return DeploymentPathUtils.getLocalPath(file.getName());
    }

    public static String getLocalPath(FileName filename) {
        Object path = filename.getPath();
        if (SystemInfo.isWindows) {
            path = filename.getRootURI().startsWith("file:////wsl") ? StringUtil.trimStart((String)filename.getRootURI(), (String)"file://") + StringUtil.trimStart((String)path, (String)"/") : StringUtil.trimStart((String)filename.getRootURI(), (String)"file:///") + StringUtil.trimStart((String)path, (String)"/");
        }
        return FileUtil.toSystemDependentName((String)path);
    }

    @NlsSafe
    public static String join(@NlsSafe @NotNull String head, @NlsSafe @NotNull String tail) {
        if (head == null) {
            DeploymentPathUtils.$$$reportNull$$$0(0);
        }
        if (tail == null) {
            DeploymentPathUtils.$$$reportNull$$$0(1);
        }
        return DeploymentPathUtils.join(head, tail, '/');
    }

    @NlsSafe
    public static String join(@NlsSafe @NotNull String head, @NlsSafe @NotNull String tail, char separator) {
        if (head == null) {
            DeploymentPathUtils.$$$reportNull$$$0(2);
        }
        if (tail == null) {
            DeploymentPathUtils.$$$reportNull$$$0(3);
        }
        if (tail.isEmpty()) {
            return head;
        }
        head = head.replace('/', separator).replace('\\', separator);
        tail = tail.replace('/', separator).replace('\\', separator);
        tail = StringUtil.trimEnd((String)tail, (String)String.valueOf(separator));
        if (!head.isEmpty() && head.charAt(head.length() - 1) == separator) {
            head = head.substring(0, head.length() - 1);
        }
        if (!tail.isEmpty() && tail.charAt(0) == separator) {
            tail = tail.substring(1);
        }
        return head + separator + tail;
    }

    @NlsSafe
    public static String joinWebPath(@NlsSafe @NotNull String serverUrl, @NlsSafe String path) {
        if (serverUrl == null) {
            DeploymentPathUtils.$$$reportNull$$$0(4);
        }
        if (!((String)serverUrl).contains(":")) {
            serverUrl = "http://" + (String)serverUrl;
        }
        return DeploymentPathUtils.join((String)serverUrl, path);
    }

    public static FileObject[] getChildren(FileObject file) throws FileSystemException {
        try {
            return file.getChildren();
        }
        catch (FileSystemException e) {
            file.refresh();
            throw e;
        }
        catch (Throwable t) {
            file.refresh();
            LOG.warn(t);
            return NO_CHILDREN;
        }
    }

    @Nullable
    public static TransferOperation.CreateFolder createCreateTargetFolderOperationIfNeeded(@NotNull FileObject target, @NotNull ThrowableComputable<FileType, ? extends FileSystemException> targetTypeComputable, @NotNull ExecutionContext context) throws FileSystemException {
        if (target == null) {
            DeploymentPathUtils.$$$reportNull$$$0(5);
        }
        if (targetTypeComputable == null) {
            DeploymentPathUtils.$$$reportNull$$$0(6);
        }
        if (context == null) {
            DeploymentPathUtils.$$$reportNull$$$0(7);
        }
        if ((context.getConfig().isCreateEmptyDirectories() || context.getConfig().getFolderPermissions() != -1) && targetTypeComputable.compute() != FileType.FOLDER) {
            return new TransferOperation.CreateFolder(target);
        }
        return null;
    }

    @Nullable
    public static TransferOperation.ChangePermissions createChangePermissionsOperationIfNeeded(@NotNull FileObject target, @NotNull ThrowableComputable<FileType, ? extends FileSystemException> targetTypeComputable, @NotNull ExecutionContext context) throws FileSystemException {
        if (target == null) {
            DeploymentPathUtils.$$$reportNull$$$0(8);
        }
        if (targetTypeComputable == null) {
            DeploymentPathUtils.$$$reportNull$$$0(9);
        }
        if (context == null) {
            DeploymentPathUtils.$$$reportNull$$$0(10);
        }
        if (context.isServerSideModification() && context.getConfig().getFolderPermissions() != -1 && targetTypeComputable.compute() == FileType.FOLDER) {
            return new TransferOperation.ChangePermissions(target);
        }
        return null;
    }

    @Nls
    @Nullable
    public static String getErrorMessageForUnsupportedName(@NotNull FileName fileName, @NotNull Mappable mappable) {
        if (fileName == null) {
            DeploymentPathUtils.$$$reportNull$$$0(11);
        }
        if (mappable == null) {
            DeploymentPathUtils.$$$reportNull$$$0(12);
        }
        if (fileName.getPath().contains("\\")) {
            String presentablePath = mappable.getAccessType().isProtocolBased() ? fileName.getPath() : DeploymentPathUtils.getLocalPath(fileName);
            return WDBundle.message("path.0.is.not.supported.because.it.contains", presentablePath);
        }
        return null;
    }

    public static void createDeleteMissingItemsOperations(FileObject target, boolean targetExists, DeploymentPathMapping mapping, ErrorsAndExclusions errorsAndExclusions, List<TransferOperation> operations, ExecutionContext context) throws FileSystemException {
        FileObject[] targetChildren;
        DeploymentMode mode = context.getDeploymentMode();
        if (!mode.isDeleteMissingItemsPossible(context)) {
            return;
        }
        for (FileObject targetChild : targetChildren = DeploymentPathUtils.getType(target, targetExists) == FileType.FOLDER ? DeploymentPathUtils.getChildren(target) : NO_CHILDREN) {
            PublishConfig publishConfig;
            FileObject sourceChild;
            if (context.getConfig().isExcludedByName(context.isServerSideModification() ? context.getServer().getPresentablePath(targetChild) : DeploymentPathUtils.getLocalPath(targetChild))) continue;
            if (context.isServerSideModification()) {
                childMapping = context.getConfig().getNearestMappingDeploy2Local(targetChild, false, (Mappable)context.getServer());
                if (childMapping.getFirst() == null && ((Boolean)childMapping.getSecond()).booleanValue()) {
                    errorsAndExclusions.addExcludedPath(targetChild, false, context);
                    continue;
                }
                if (mapping != childMapping.getFirst()) {
                    continue;
                }
            } else {
                childMapping = context.getConfig().getNearestMappingForLocal(targetChild, false, true, false, (Mappable)context.getServer());
                if (childMapping.getFirst() == null && ((Boolean)childMapping.getSecond()).booleanValue()) {
                    errorsAndExclusions.addExcludedPath(targetChild, true, context);
                    continue;
                }
                if (mapping != childMapping.getFirst()) continue;
            }
            if ((sourceChild = context.isServerSideModification() ? mapping.mapToLocalFile(targetChild, context.getServer()) : context.findRemoteFile(mapping.mapToDeployPath(targetChild, (Mappable)context.getServer()), DeploymentPathUtils.getType(target, targetExists) != FileType.IMAGINARY)).exists()) continue;
            if (context.isServerSideModification()) {
                childMapping = context.getConfig().getNearestMappingForLocal(sourceChild, false, true, false, (Mappable)context.getServer());
                if (childMapping.getFirst() == null && ((Boolean)childMapping.getSecond()).booleanValue()) {
                    errorsAndExclusions.addExcludedPath(sourceChild, true, context);
                    continue;
                }
            } else {
                childMapping = context.getConfig().getNearestMappingDeploy2Local(sourceChild, false, (Mappable)context.getServer());
                if (childMapping.getFirst() == null && ((Boolean)childMapping.getSecond()).booleanValue()) {
                    errorsAndExclusions.addExcludedPath(sourceChild, false, context);
                    continue;
                }
            }
            if (targetChild.getType() == FileType.FILE) {
                mode.sourceNotExist(targetChild, context, operations, false);
                continue;
            }
            Pair<List<DeploymentPathMapping>, Boolean> descendantMappings = context.isServerSideModification() ? context.getConfig().getChildMappingsDeploy2Local(targetChild, (Mappable)context.getServer()) : context.getConfig().getChildMappingsForLocal(targetChild, true, false, (Mappable)context.getServer());
            boolean canDelete = true;
            for (DeploymentPathMapping descendantMapping : (List)descendantMappings.getFirst()) {
                FileObject descendant = context.isServerSideModification() ? context.findRemoteFile(descendantMapping.getFullDeployPath(context.getServer()), DeploymentPathUtils.getType(target, targetExists) != FileType.IMAGINARY) : DeploymentPathUtils.getLocalFile(descendantMapping.getLocalPath());
                if (descendant == null || !descendant.exists()) continue;
                canDelete = false;
                break;
            }
            if (!canDelete) continue;
            PublishConfig publishConfig2 = publishConfig = context.getProject() != null ? PublishConfig.getInstance(context.getProject()) : context.getConfig();
            operations.add(publishConfig.isConfirmBeforeDeletion() ? new TransferOperation.UserConfirmedDelete(target, target.getType()) : new TransferOperation.Delete(targetChild, targetChild.getType() == FileType.FOLDER, true));
        }
    }

    @NotNull
    public static TransferTask.ListBased.ResultWithErrors createSpeculativeUploadTransferOperations(@NotNull ExecutionContext context, @NotNull Collection<? extends VirtualFile> roots) throws FileSystemException {
        if (context == null) {
            DeploymentPathUtils.$$$reportNull$$$0(13);
        }
        if (roots == null) {
            DeploymentPathUtils.$$$reportNull$$$0(14);
        }
        List<TransferOperation> operations = new ArrayList<TransferOperation>();
        ErrorsAndExclusions errorsAndExclusions = new ErrorsAndExclusions();
        for (VirtualFile virtualFile : roots) {
            FileObject source = DeploymentPathUtils.getLocalFile(virtualFile.getPath());
            if (source == null) {
                errorsAndExclusions.addError(WDBundle.message("error.message.failed.to.resolve.local.path.0", virtualFile.getPath()));
                continue;
            }
            DeploymentPathChecker checker = new DeploymentPathChecker();
            checker.initProcessing();
            DeploymentPathUtils.createSpeculativeUploadTransferOperations(source, context, operations, errorsAndExclusions, null, checker);
        }
        operations = DeploymentPathUtils.mergeIfNeeded(context, operations);
        return new TransferTask.ListBased.ResultWithErrors(operations, errorsAndExclusions);
    }

    public static List<TransferOperation> mergeIfNeeded(ExecutionContextBase context, List<TransferOperation> operations) throws FileSystemException {
        if (operations.size() == 1) {
            return operations;
        }
        ArrayList<TransferOperation> mergedList = new ArrayList<TransferOperation>(operations.size());
        if (context.getServer().isUseRsync()) {
            TransferOperation.RsyncMultiFileUploading copyMerged = new TransferOperation.RsyncMultiFileUploading();
            TransferOperation.RsyncMultiFileDownloading copyMergedDownload = new TransferOperation.RsyncMultiFileDownloading();
            for (TransferOperation operation : operations) {
                if (operation instanceof TransferOperation.RsyncMultiFileDownloading || operation instanceof TransferOperation.RsyncMultiFileUploading) {
                    mergedList.add(operation);
                    continue;
                }
                if (operation instanceof TransferOperation.RsyncCopy) {
                    TransferOperation.RsyncCopy rsyncOperation = (TransferOperation.RsyncCopy)operation;
                    if (rsyncOperation.mySource instanceof LocalFile) {
                        if (rsyncOperation.myTargetName != null) {
                            copyMerged.add(rsyncOperation.mySource, rsyncOperation.myTargetName);
                            continue;
                        }
                        if (rsyncOperation.myTargetPath != null) {
                            copyMerged.add(rsyncOperation.mySource, rsyncOperation.myTargetPath);
                            continue;
                        }
                        copyMerged.add(rsyncOperation.mySource, rsyncOperation.myTarget);
                        continue;
                    }
                    if (rsyncOperation.myTargetName != null) {
                        copyMergedDownload.add(rsyncOperation.mySource, rsyncOperation.myTargetName);
                        continue;
                    }
                    if (rsyncOperation.myTargetPath != null) {
                        copyMergedDownload.add(rsyncOperation.mySource, rsyncOperation.myTargetPath.path);
                        continue;
                    }
                    copyMergedDownload.add(rsyncOperation.mySource, rsyncOperation.myTarget);
                    continue;
                }
                mergedList.add(operation);
            }
            mergedList.add(copyMerged);
            mergedList.add(copyMergedDownload);
            return mergedList;
        }
        if (context.getServer().getNumberOfConnections() > 1) {
            TransferOperation.ParallelFilesUpload parallelOperation = null;
            for (TransferOperation operation : operations) {
                if (operation instanceof TransferOperation.AsynchronousOperation) {
                    if (parallelOperation == null) {
                        parallelOperation = new TransferOperation.ParallelFilesUpload(((TransferOperation.AsynchronousOperation)((Object)operation)).getParentSource());
                    }
                    parallelOperation.add(operation);
                    continue;
                }
                if (parallelOperation != null) {
                    mergedList.add(parallelOperation);
                    parallelOperation = null;
                }
                mergedList.add(operation);
            }
            if (parallelOperation != null) {
                mergedList.add(parallelOperation);
            }
            return mergedList;
        }
        return operations;
    }

    private static void createSpeculativeUploadTransferOperations(@NotNull FileObject localSource, @NotNull ExecutionContext context, @NotNull List<TransferOperation> operations, @NotNull ErrorsAndExclusions errorsAndExclusions, @Nullable TransferOperation.SpeculativeCreateRemoteDirectoryAndResolveChildren parentOperation, @NotNull DeploymentPathChecker checker) throws FileSystemException {
        String errorMessage;
        if (localSource == null) {
            DeploymentPathUtils.$$$reportNull$$$0(15);
        }
        if (context == null) {
            DeploymentPathUtils.$$$reportNull$$$0(16);
        }
        if (operations == null) {
            DeploymentPathUtils.$$$reportNull$$$0(17);
        }
        if (errorsAndExclusions == null) {
            DeploymentPathUtils.$$$reportNull$$$0(18);
        }
        if (checker == null) {
            DeploymentPathUtils.$$$reportNull$$$0(19);
        }
        if ((errorMessage = DeploymentPathUtils.getErrorMessageForUnsupportedName(localSource.getName(), context.getServer())) != null) {
            errorsAndExclusions.addError(errorMessage);
            return;
        }
        Pair<DeploymentPathMapping, Boolean> mappingPair = context.getConfig().getNearestMappingForLocal(localSource, false, true, false, (Mappable)context.getServer());
        if (mappingPair.getFirst() == null && Boolean.TRUE == mappingPair.getSecond()) {
            errorsAndExclusions.addExcludedPath(localSource, context.isServerSideModification(), context);
            return;
        }
        if (mappingPair.getFirst() == null) {
            Pair<List<DeploymentPathMapping>, Boolean> childMappingsPair = context.getConfig().getChildMappingsForLocal(localSource, true, false, (Mappable)context.getServer());
            if (((List)childMappingsPair.getFirst()).isEmpty() && Boolean.TRUE == childMappingsPair.getSecond()) {
                errorsAndExclusions.addExcludedPath(localSource, context.isServerSideModification(), context);
                return;
            }
            for (DeploymentPathMapping childMapping : (List)childMappingsPair.getFirst()) {
                context.getProgressIndicator().checkCanceled();
                FileObject sourceChild = DeploymentPathUtils.getLocalFile(childMapping.getLocalPath());
                if (sourceChild == null) continue;
                DeploymentPathUtils.createSpeculativeUploadTransferOperations(sourceChild, context, operations, errorsAndExclusions, null, checker);
            }
            return;
        }
        FileObject alreadyProcessedFileObject = checker.getAlreadyProcessedFileObject(localSource);
        if (alreadyProcessedFileObject != null) {
            errorsAndExclusions.addError(WDBundle.message("skipping.duplicate.path.0.looks.like.a.recursive.symlink.to.1", localSource.getName().getPath(), alreadyProcessedFileObject.getName().getPath()));
            return;
        }
        DeploymentPathMapping mapping = (DeploymentPathMapping)mappingPair.getFirst();
        FileName targetName = context.findRemoteFileName(mapping.mapToDeployPath(localSource, (Mappable)context.getServer()));
        DeploymentPathUtils.generateSpeculativeTransferOperationsForUpload(localSource, context, operations, errorsAndExclusions, parentOperation, checker, mapping, targetName);
    }

    private static void generateSpeculativeTransferOperationsForUpload(@NotNull FileObject localSource, @NotNull ExecutionContext context, @NotNull List<TransferOperation> operations, @NotNull ErrorsAndExclusions errorsAndExclusions, @Nullable TransferOperation.SpeculativeCreateRemoteDirectoryAndResolveChildren parentOperation, @NotNull DeploymentPathChecker checker, DeploymentPathMapping mapping, FileName targetName) throws FileSystemException {
        FileType localType;
        if (localSource == null) {
            DeploymentPathUtils.$$$reportNull$$$0(20);
        }
        if (context == null) {
            DeploymentPathUtils.$$$reportNull$$$0(21);
        }
        if (operations == null) {
            DeploymentPathUtils.$$$reportNull$$$0(22);
        }
        if (errorsAndExclusions == null) {
            DeploymentPathUtils.$$$reportNull$$$0(23);
        }
        if (checker == null) {
            DeploymentPathUtils.$$$reportNull$$$0(24);
        }
        if ((localType = localSource.getType()) != FileType.IMAGINARY && context.getServer().isUseRsync()) {
            operations.add(new TransferOperation.RsyncCopy(localSource, targetName));
            return;
        }
        switch (localType) {
            case FILE: {
                TransferOperation.SpeculativeFileUpload operation = new TransferOperation.SpeculativeFileUpload(localSource, targetName);
                if (parentOperation != null) {
                    parentOperation.addChildOperation(operation);
                }
                operations.add(operation);
                return;
            }
            case FOLDER: {
                FileObject[] children = localSource.getChildren();
                if (!context.getConfig().isCreateEmptyDirectories() && children.length == 0) {
                    return;
                }
                TransferOperation.SpeculativeCreateRemoteDirectoryAndResolveChildren operation = new TransferOperation.SpeculativeCreateRemoteDirectoryAndResolveChildren(localSource, targetName, mapping);
                if (parentOperation != null) {
                    parentOperation.addChildOperation(operation);
                }
                operations.add(operation);
                for (FileObject child : children) {
                    DeploymentPathUtils.createSpeculativeUploadTransferOperations(child, context, operations, errorsAndExclusions, operation, checker);
                }
            }
            case IMAGINARY: {
                return;
            }
        }
    }

    @NotNull
    public static TransferTask.ListBased.ResultWithErrors createSpeculativeUploadTransferOperationsOnRemoteFiles(ExecutionContext context, Collection<FileObject> roots) throws FileSystemException {
        ArrayList<TransferOperation> operations = new ArrayList<TransferOperation>();
        ErrorsAndExclusions errorsAndExclusions = new ErrorsAndExclusions();
        for (FileObject root : roots) {
            DeploymentPathUtils.refreshRemoteFile(root, context);
            DeploymentPathChecker checker = new DeploymentPathChecker();
            checker.initProcessing();
            DeploymentPathUtils.createSpeculativeUploadTransferOperationsOnRemoteFile(root, context, operations, errorsAndExclusions, checker);
        }
        return new TransferTask.ListBased.ResultWithErrors(operations, errorsAndExclusions);
    }

    private static void createSpeculativeUploadTransferOperationsOnRemoteFile(@NotNull FileObject root, @NotNull ExecutionContext context, @NotNull List<TransferOperation> operations, @NotNull ErrorsAndExclusions errorsAndExclusions, @NotNull DeploymentPathChecker checker) throws FileSystemException {
        FileName targetName;
        String errorMessage;
        if (root == null) {
            DeploymentPathUtils.$$$reportNull$$$0(25);
        }
        if (context == null) {
            DeploymentPathUtils.$$$reportNull$$$0(26);
        }
        if (operations == null) {
            DeploymentPathUtils.$$$reportNull$$$0(27);
        }
        if (errorsAndExclusions == null) {
            DeploymentPathUtils.$$$reportNull$$$0(28);
        }
        if (checker == null) {
            DeploymentPathUtils.$$$reportNull$$$0(29);
        }
        if ((errorMessage = DeploymentPathUtils.getErrorMessageForUnsupportedName(targetName = root.getName(), context.getServer())) != null) {
            errorsAndExclusions.addError(errorMessage);
            return;
        }
        Pair<DeploymentPathMapping, Boolean> mappingPair = context.getConfig().getNearestMappingDeploy2Local(root, false, (Mappable)context.getServer());
        if (mappingPair.getFirst() == null && Boolean.TRUE == mappingPair.getSecond()) {
            errorsAndExclusions.addExcludedPath(root, context.isServerSideModification(), context);
            return;
        }
        if (mappingPair.getFirst() == null) {
            Pair<List<DeploymentPathMapping>, Boolean> childMappingsPair = context.getConfig().getChildMappingsDeploy2Local(root, (Mappable)context.getServer());
            if (((List)childMappingsPair.getFirst()).isEmpty() && Boolean.TRUE == childMappingsPair.getSecond()) {
                errorsAndExclusions.addExcludedPath(root, context.isServerSideModification(), context);
                return;
            }
            for (DeploymentPathMapping childMapping : (List)childMappingsPair.getFirst()) {
                context.getProgressIndicator().checkCanceled();
                FileObject sourceChild = DeploymentPathUtils.getLocalFile(childMapping.getLocalPath());
                if (sourceChild == null) continue;
                DeploymentPathUtils.createSpeculativeUploadTransferOperationsOnRemoteFile(sourceChild, context, operations, errorsAndExclusions, checker);
            }
            return;
        }
        DeploymentPathMapping mapping = (DeploymentPathMapping)mappingPair.getFirst();
        String localPath = mapping.mapToLocalPath(root, (Mappable)context.getServer());
        FileObject localSource = DeploymentPathUtils.getLocalFile(localPath);
        if (localSource == null) {
            errorsAndExclusions.addError(WDBundle.message("error.message.failed.to.resolve.local.path.0", localPath));
            return;
        }
        FileObject alreadyProcessedFileObject = checker.getAlreadyProcessedFileObject(localSource);
        if (alreadyProcessedFileObject != null) {
            errorsAndExclusions.addError(WDBundle.message("skipping.duplicate.path.0.looks.like.a.recursive.symlink.to.1", localSource.getName().getPath(), alreadyProcessedFileObject.getName().getPath()));
            return;
        }
        DeploymentPathUtils.generateSpeculativeTransferOperationsForUpload(localSource, context, operations, errorsAndExclusions, null, checker, mapping, targetName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "head";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tail";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverUrl";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetTypeComputable";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localSource";
                break;
            }
            case 17: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operations";
                break;
            }
            case 18: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorsAndExclusions";
                break;
            }
            case 19: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/DeploymentPathUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "join";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "joinWebPath";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createCreateTargetFolderOperationIfNeeded";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createChangePermissionsOperationIfNeeded";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getErrorMessageForUnsupportedName";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "createSpeculativeUploadTransferOperations";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "generateSpeculativeTransferOperationsForUpload";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "createSpeculativeUploadTransferOperationsOnRemoteFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ErrorsAndExclusions {
        private final Collection<@Nls String> myErrors = new ArrayList<String>();
        private final Collection<String> myPaths = new HashSet<String>();

        public boolean addAll(ErrorsAndExclusions other) {
            boolean changed = this.myErrors.addAll(other.myErrors);
            return changed |= this.myPaths.addAll(other.myPaths);
        }

        public void importDataFrom(@NotNull TransferTask.ListBased.ResultWithErrors resultWithErrors) {
            if (resultWithErrors == null) {
                ErrorsAndExclusions.$$$reportNull$$$0(0);
            }
            this.myErrors.addAll(resultWithErrors.errorMessages);
            this.myPaths.addAll(resultWithErrors.excludedPaths);
        }

        public boolean addExcludedPath(FileObject path, boolean isLocal, ExecutionContext context) {
            return this.myPaths.add(isLocal ? DeploymentPathUtils.getLocalPath(path) : context.getServer().getPresentablePath(path));
        }

        public boolean addExcludedPath(WebServerConfig.RemotePath path, WebServerConfig server) {
            return this.myPaths.add(server.getPresentablePath(path));
        }

        public void addError(@Nls String message) {
            this.myErrors.add(message);
        }

        public Collection<@Nls String> getReadOnlyErrors() {
            return Collections.unmodifiableCollection(this.myErrors);
        }

        public Collection<String> getReadOnlyPaths() {
            return Collections.unmodifiableCollection(this.myPaths);
        }

        public void addAllPaths(ErrorsAndExclusions childErrorsAndExclusions) {
            this.myPaths.addAll(childErrorsAndExclusions.myPaths);
        }

        public static ErrorsAndExclusions reportErrors(Collection<@Nls String> errors) {
            ErrorsAndExclusions errorsAndExclusions = new ErrorsAndExclusions();
            errorsAndExclusions.myErrors.addAll(errors);
            return errorsAndExclusions;
        }

        public static ErrorsAndExclusions reportExcluded(FileObject excluded, Boolean local, ExecutionContext context) {
            ErrorsAndExclusions errorsAndExclusions = new ErrorsAndExclusions();
            errorsAndExclusions.addExcludedPath(excluded, local, context);
            return errorsAndExclusions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultWithErrors", "com/jetbrains/plugins/webDeployment/DeploymentPathUtils$ErrorsAndExclusions", "importDataFrom"));
        }
    }

    private static final class DeploymentPathProcessor {
        private final ExecutionContext myContext;
        private final List<TransferOperation> myResult;
        private final boolean myProcessChildMappings;
        private final DeploymentPathChecker myChecker = new DeploymentPathChecker();

        private DeploymentPathProcessor(ExecutionContext context, List<TransferOperation> result, boolean processChildMappings) {
            this.myContext = context;
            this.myResult = result;
            this.myProcessChildMappings = processChildMappings;
        }

        public ErrorsAndExclusions processPath(FileObject source, FileObject target, DeploymentPathMapping mapping) throws FileSystemException {
            this.myChecker.initProcessing();
            boolean targetExists = target.exists();
            return this.process(source, target, targetExists, mapping);
        }

        private ErrorsAndExclusions process(FileObject source, FileObject target, boolean targetExists, DeploymentPathMapping mapping) throws FileSystemException {
            String errorMessage = DeploymentPathUtils.getErrorMessageForUnsupportedName(source.getName(), this.myContext.getServer());
            if (errorMessage != null) {
                return ErrorsAndExclusions.reportErrors(Collections.singletonList(errorMessage));
            }
            FileObject excludedFile = DeploymentPathUtils.getExcludedFile(this.myContext, source, target);
            if (excludedFile != null) {
                boolean local = this.myContext.isServerSideModification() ? excludedFile == source : excludedFile == target;
                return ErrorsAndExclusions.reportExcluded(excludedFile, local, this.myContext);
            }
            ErrorsAndExclusions errorsAndExclusions = new ErrorsAndExclusions();
            if (errorsAndExclusions.addAll(this.storeCheckAndReportDuplicatePath(source))) {
                return errorsAndExclusions;
            }
            this.myContext.getProgressIndicator().checkCanceled();
            String sourcePath = this.myContext.isServerSideModification() ? DeploymentPathUtils.getLocalPath(source) : this.myContext.getServer().getPresentablePath(source);
            this.myContext.getProgressIndicator().setText(WDBundle.message("collecting.files.0", sourcePath));
            if (this.myContext.getConfig().isExcludedByName(sourcePath)) {
                return errorsAndExclusions;
            }
            DeploymentMode mode = this.myContext.getDeploymentMode();
            if (!source.exists()) {
                mode.sourceNotExist(target, this.myContext, this.myResult, true);
            } else if (source.getType() == FileType.FILE) {
                mode.sourceIsFile(source, target, this.myContext, this.myResult);
            } else {
                TransferOperation.CreateFolder createFolderOperation = DeploymentPathUtils.createCreateTargetFolderOperationIfNeeded(target, (ThrowableComputable<FileType, ? extends FileSystemException>)((ThrowableComputable)() -> DeploymentPathUtils.getType(target, targetExists)), this.myContext);
                if (createFolderOperation != null) {
                    this.myResult.add(createFolderOperation);
                } else {
                    TransferOperation.ChangePermissions changePermissionsOperation = DeploymentPathUtils.createChangePermissionsOperationIfNeeded(target, (ThrowableComputable<FileType, ? extends FileSystemException>)((ThrowableComputable)() -> DeploymentPathUtils.getType(target, targetExists)), this.myContext);
                    if (changePermissionsOperation != null) {
                        this.myResult.add(changePermissionsOperation);
                    }
                }
                if (this.myContext.getServer().isUseRsync()) {
                    this.myResult.add(new TransferOperation.RsyncCopy(source, target));
                } else {
                    FileObject[] sourceChildren;
                    for (FileObject sourceChild : sourceChildren = source.getType() == FileType.FOLDER ? DeploymentPathUtils.getChildren(source) : NO_CHILDREN) {
                        String sourceChildPath;
                        String nameErrorMessage = DeploymentPathUtils.getErrorMessageForUnsupportedName(sourceChild.getName(), this.myContext.getServer());
                        if (nameErrorMessage != null) {
                            errorsAndExclusions.addError(nameErrorMessage);
                            continue;
                        }
                        String string = sourceChildPath = this.myContext.isServerSideModification() ? DeploymentPathUtils.getLocalPath(sourceChild) : this.myContext.getServer().getPresentablePath(sourceChild);
                        if (this.myContext.getConfig().isExcludedByName(sourceChildPath)) continue;
                        Pair<DeploymentPathMapping, Boolean> childMappingPair = this.myContext.isServerSideModification() ? this.myContext.getConfig().getNearestMappingForLocal(sourceChild, false, true, false, (Mappable)this.myContext.getServer()) : this.myContext.getConfig().getNearestMappingDeploy2Local(sourceChild, false, (Mappable)this.myContext.getServer());
                        if (childMappingPair.getFirst() == null) {
                            if (Boolean.TRUE != childMappingPair.getSecond()) continue;
                            errorsAndExclusions.addExcludedPath(sourceChild, this.myContext.isServerSideModification(), this.myContext);
                            continue;
                        }
                        DeploymentPathMapping childMapping = (DeploymentPathMapping)childMappingPair.getFirst();
                        if (!this.myProcessChildMappings && childMapping != mapping) continue;
                        FileObject targetChild = this.myContext.isServerSideModification() ? this.myContext.findRemoteFile(childMapping.mapToDeployPath(sourceChild, (Mappable)this.myContext.getServer()), childMapping != mapping || DeploymentPathUtils.getType(target, targetExists) != FileType.IMAGINARY) : childMapping.mapToLocalFile(sourceChild, this.myContext.getServer());
                        FileObject excludedChildFile = DeploymentPathUtils.getExcludedFile(this.myContext, sourceChild, targetChild);
                        if (excludedChildFile != null) {
                            boolean local = this.myContext.isServerSideModification() ? excludedChildFile == sourceChild : excludedChildFile == targetChild;
                            errorsAndExclusions.addExcludedPath(excludedChildFile, local, this.myContext);
                            continue;
                        }
                        try {
                            ErrorsAndExclusions childErrorsAndExclusions = this.process(sourceChild, targetChild, DeploymentPathUtils.getType(target, targetExists) != FileType.IMAGINARY, childMapping);
                            errorsAndExclusions.addAllPaths(childErrorsAndExclusions);
                        }
                        catch (FileSystemException e) {
                            if (PublishUtils.isFatal(e)) {
                                throw e;
                            }
                            LOG.warn((Throwable)e);
                            errorsAndExclusions.myErrors.add(WDBundle.message("failed.to.process", sourceChildPath, PublishUtils.getMessage(e, false)));
                        }
                    }
                }
                DeploymentPathUtils.createDeleteMissingItemsOperations(target, targetExists, mapping, errorsAndExclusions, this.myResult, this.myContext);
            }
            return errorsAndExclusions;
        }

        private ErrorsAndExclusions storeCheckAndReportDuplicatePath(@NotNull FileObject source) {
            FileObject previousObject;
            if (source == null) {
                DeploymentPathProcessor.$$$reportNull$$$0(0);
            }
            if ((previousObject = this.myChecker.getAlreadyProcessedFileObject(source)) != null) {
                String errorMessage = WDBundle.message("skipping.duplicate.path.0.looks.like.a.recursive.symlink.to.1", source.getName().getPath(), previousObject.getName().getPath());
                LOG.warn(errorMessage);
                return ErrorsAndExclusions.reportErrors(Collections.singletonList(errorMessage));
            }
            return new ErrorsAndExclusions();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/plugins/webDeployment/DeploymentPathUtils$DeploymentPathProcessor", "storeCheckAndReportDuplicatePath"));
        }
    }
}

