/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.target.ssh.target;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ssh.config.unified.ErrorMessageAndField;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshCredentialsVerifier;
import com.intellij.ssh.ui.unified.SshCredentialsEditorEx;
import com.intellij.ssh.ui.unified.SshUiData;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.ServerDeployableWithTempCredentials;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import com.jetbrains.plugins.webDeployment.ui.auth.AuthHelper;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aP\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\r\b\u0001\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u0002H\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00020\rH\u0000\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"handleSshTargetTypeBrowsing", "", "C", "Ljava/awt/Component;", "sshUiData", "Lcom/intellij/ssh/ui/unified/SshUiData;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "component", "textComponentAccessor", "Lcom/intellij/openapi/ui/TextComponentAccessor;", "(Lcom/intellij/ssh/ui/unified/SshUiData;Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/awt/Component;Lcom/intellij/openapi/ui/TextComponentAccessor;)V", "intellij.remoteRun"})
public final class SshTargetTypeKt {
    public static final <C extends Component> void handleSshTargetTypeBrowsing(@Nullable SshUiData sshUiData, @Nullable Project project, @NlsContexts.DialogTitle @NotNull String title, @NotNull C component, @NotNull TextComponentAccessor<C> textComponentAccessor) {
        WebServerConfig.RemotePath path;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter(textComponentAccessor, (String)"textComponentAccessor");
        if (sshUiData == null) {
            Messages.showWarningDialog((Project)project, (String)RemoteSdkBundle.message("dialog.message.failed.to.find.ssh.settings", new Object[0]), (String)title);
            return;
        }
        ErrorMessageAndField errorMessageAndField = SshCredentialsEditorEx.validate((SshUiData)sshUiData, (SshCredentialsVerifier.ValidationMode)SshCredentialsVerifier.ValidationMode.WITHOUT_SLOW_KEY_CHECKS);
        if (errorMessageAndField != null) {
            Object[] objectArray = new Object[]{errorMessageAndField.errorMessage()};
            Messages.showWarningDialog((Project)project, (String)RemoteSdkBundle.message("dialog.message.please.fill.ssh.settings.0", objectArray), (String)title);
            return;
        }
        SshConfig sshConfig = sshUiData.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)sshConfig, (String)"getConfig(...)");
        SshConfig sshConfig2 = sshConfig;
        WebServerConfig server = new WebServerConfig(WebServerConfig.getNextId());
        server.setName(sshConfig2.getPresentableFullName());
        server.getFileTransferConfig().setAccessType(AccessType.SFTP);
        server.getFileTransferConfig().setSshConfig(sshConfig2);
        ServerDeployableWithTempCredentials deployable = new ServerDeployableWithTempCredentials(server, sshUiData);
        if (!AuthHelper.ensureAuthSpecified((Project)project, (Deployable)((Deployable)deployable), component)) {
            return;
        }
        ServerBrowserDialog dialog = new ServerBrowserDialog(component, (Deployable)deployable, title, false, FileTransferConfig.Origin.Default, new WebServerConfig.RemotePath(textComponentAccessor.getText(component)));
        dialog.show();
        if (dialog.isOK() && (path = dialog.getPath()) != null) {
            textComponentAccessor.setText(component, path.path);
        }
    }
}

