/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateBinder;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import com.google.inject.spi.MembersInjectorLookup;
import com.google.inject.spi.PrivateElements;
import com.google.inject.spi.ProviderLookup;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.sisu.space.BeanScanning;
import org.eclipse.sisu.space.ClassFinder;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.IndexedClassFinder;
import org.eclipse.sisu.space.QualifiedTypeBinder;
import org.eclipse.sisu.space.QualifiedTypeVisitor;
import org.eclipse.sisu.space.SpaceScanner;
import org.eclipse.sisu.space.SpaceVisitor;

public final class SpaceModule
implements Module {
    private static final String NAMED_INDEX = "META-INF/sisu/javax.inject.Named";
    public static final ClassFinder LOCAL_INDEX = new IndexedClassFinder("META-INF/sisu/javax.inject.Named", false);
    public static final ClassFinder GLOBAL_INDEX = new IndexedClassFinder("META-INF/sisu/javax.inject.Named", true);
    public static final ClassFinder LOCAL_SCAN = SpaceScanner.DEFAULT_FINDER;
    private final boolean caching;
    private final ClassSpace space;
    private final ClassFinder finder;
    private final boolean isStrict;
    private Strategy strategy = Strategy.DEFAULT;

    @Deprecated
    public SpaceModule(ClassSpace space) {
        this(space, BeanScanning.ON);
    }

    @Deprecated
    public SpaceModule(ClassSpace space, ClassFinder finder) {
        this(space, finder, false);
    }

    public SpaceModule(ClassSpace space, ClassFinder finder, boolean isStrict) {
        this.caching = false;
        this.space = space;
        this.finder = finder;
        this.isStrict = isStrict;
    }

    @Deprecated
    public SpaceModule(ClassSpace space, BeanScanning scanning) {
        this(space, scanning, false);
    }

    public SpaceModule(ClassSpace space, BeanScanning scanning, boolean isStrict) {
        this.caching = BeanScanning.CACHE == scanning;
        this.space = space;
        switch (scanning) {
            case OFF: {
                this.finder = null;
                break;
            }
            case INDEX: {
                this.finder = LOCAL_INDEX;
                break;
            }
            case GLOBAL_INDEX: {
                this.finder = GLOBAL_INDEX;
                break;
            }
            default: {
                this.finder = LOCAL_SCAN;
            }
        }
        this.isStrict = isStrict;
    }

    public Module with(Strategy _strategy) {
        this.strategy = _strategy;
        return this;
    }

    public void configure(Binder binder) {
        binder.bind(ClassSpace.class).toInstance((Object)this.space);
        if (this.caching) {
            this.recordAndReplayElements(binder);
        } else if (null != this.finder) {
            this.scanForElements(binder);
        }
    }

    void scanForElements(Binder binder) {
        new SpaceScanner(this.space, this.finder, this.isStrict).accept(this.strategy.visitor(binder));
    }

    private void recordAndReplayElements(Binder binder) {
        List recording;
        String key2 = this.space.toString();
        List<Element> elements = (List<Element>)RecordedElements.cache.get(key2);
        if (null == elements && null == (elements = RecordedElements.cache.putIfAbsent(key2, recording = Elements.getElements((Module[])new Module[]{new Module(){

            public void configure(Binder recorder) {
                SpaceModule.this.scanForElements(recorder);
            }
        }})))) {
            Elements.getModule((Iterable)recording).configure(binder);
            return;
        }
        SpaceModule.replayRecordedElements(binder, elements);
    }

    private static void replayRecordedElements(Binder binder, List<Element> elements) {
        for (Element e : elements) {
            if (e instanceof ProviderLookup) {
                binder.getProvider(((ProviderLookup)e).getKey());
                continue;
            }
            if (e instanceof MembersInjectorLookup) {
                binder.getMembersInjector(((MembersInjectorLookup)e).getType());
                continue;
            }
            if (e instanceof PrivateElements) {
                PrivateElements privateElements = (PrivateElements)e;
                PrivateBinder privateBinder = binder.withSource(e.getSource()).newPrivateBinder();
                SpaceModule.replayRecordedElements((Binder)privateBinder, privateElements.getElements());
                for (Key k : privateElements.getExposedKeys()) {
                    privateBinder.withSource(privateElements.getExposedSource(k)).expose(k);
                }
                continue;
            }
            e.applyTo(binder);
        }
    }

    public static interface Strategy {
        public static final Strategy DEFAULT = new Strategy(){

            @Override
            public SpaceVisitor visitor(Binder binder) {
                return new QualifiedTypeVisitor(new QualifiedTypeBinder(binder));
            }
        };
        public static final Strategy DEFAULT_STRICT = new Strategy(){

            @Override
            public SpaceVisitor visitor(Binder binder) {
                return new QualifiedTypeVisitor(new QualifiedTypeBinder(binder), true);
            }
        };

        public SpaceVisitor visitor(Binder var1);
    }

    private static final class RecordedElements {
        static final ConcurrentMap<String, List<Element>> cache = new ConcurrentHashMap<String, List<Element>>(16, 0.75f, 1);

        private RecordedElements() {
        }
    }
}

