/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.resolution;

import java.util.List;
import java.util.Objects;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.resolution.ArtifactResolverPostProcessor;
import org.eclipse.aether.util.ConfigUtils;

public abstract class ArtifactResolverPostProcessorSupport
implements ArtifactResolverPostProcessor {
    private static final String CONFIG_PROP_PREFIX = "aether.artifactResolver.postProcessor.";
    private final String name;

    protected ArtifactResolverPostProcessorSupport(String name2) {
        this.name = Objects.requireNonNull(name2);
    }

    @Override
    public void postProcess(RepositorySystemSession session, List<ArtifactResult> artifactResults) {
        if (this.isEnabled(session)) {
            this.doPostProcess(session, artifactResults);
        }
    }

    protected abstract void doPostProcess(RepositorySystemSession var1, List<ArtifactResult> var2);

    protected String configPropKey(String name2) {
        Objects.requireNonNull(name2);
        return CONFIG_PROP_PREFIX + this.name + "." + name2;
    }

    protected boolean isEnabled(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, CONFIG_PROP_PREFIX + this.name);
    }
}

