/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.providers;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.completion.SqlCompletionContributor;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.SqlInsertHandlers;
import com.intellij.sql.completion.options.SqlCodeCompletionSettings;
import com.intellij.sql.completion.providers.SqlCompletionProviderBase;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.ComputedInsertPolicy;
import com.intellij.sql.inspections.IdentityInsertPolicy;
import com.intellij.sql.inspections.SqlInspectionUtilsKt;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlMergeStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlInsertDmlInstructionImpl;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlColumnListCompletionProvider
extends SqlCompletionProviderBase {
    @Override
    public void doAddCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        SqlExpression expression;
        PsiFile file;
        if (parameters == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(2);
        }
        if (!((file = parameters.getOriginalFile()) instanceof SqlFile)) {
            return;
        }
        PsiElement position = parameters.getPosition();
        if (position instanceof SqlStringTokenElement || position instanceof PsiComment) {
            return;
        }
        PsiElement parent = position.getParent();
        if (parent == null) {
            return;
        }
        PsiElement prevSibling = parent.getPrevSibling();
        if (prevSibling instanceof ASTNode && ((ASTNode)prevSibling).getElementType() == SqlCommonTokens.SQL_PERIOD) {
            return;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        SqlColumnListCompletionProvider.suggestTableColumnListAtOnce(position, dialect, result2);
        SqlAsExpression aliasDefinition = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlAsExpression.class);
        if (aliasDefinition != null && SqlCodeCompletionSettings.getInstance().isSuggestAliasNames() && PsiTreeUtil.isContextAncestor((PsiElement)aliasDefinition.getNameElement(), (PsiElement)position, (boolean)false) && (expression = aliasDefinition.getExpression()) != null) {
            for (String name2 : SqlNamesGenerator.suggestAliasNames(expression)) {
                result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)SqlCompletionUtil.createLookupItem(name2, false, false, true, SqlInsertHandlers.TEMPLATE_SAFE_INSERT_HANDLER, ContainerUtil.emptyList()), (double)30.0));
            }
        }
    }

    @NotNull
    private static JBIterable<? extends DasColumn> getColumnsForTableReference(SqlReferenceExpression tableReference) {
        DasTable resolve2 = SqlCompletionContributor.retrieveTable((PsiElement)tableReference);
        if (resolve2 != null) {
            JBIterable<? extends DasColumn> jBIterable = DasUtil.getColumns(resolve2);
            if (jBIterable == null) {
                SqlColumnListCompletionProvider.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        SqlTableType tableType2 = SqlCompletionContributor.retrieveTableTypeForVariable((PsiElement)tableReference);
        if (tableType2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlColumnListCompletionProvider.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        ArrayList<DasColumn> columns = new ArrayList<DasColumn>();
        for (int i2 = 0; i2 < tableType2.getColumnCount(); ++i2) {
            PsiElement columnElement = tableType2.getColumnElement(i2);
            if (!(columnElement instanceof DasColumn)) continue;
            columns.add((DasColumn)columnElement);
        }
        JBIterable jBIterable = JBIterable.from(columns);
        if (jBIterable == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    private static List<SqlReferenceExpression> getReferenceList(@NotNull PsiElement position) {
        SqlTableColumnsList columnsList;
        if (position == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(6);
        }
        if ((columnsList = (SqlTableColumnsList)PsiTreeUtil.getParentOfType((PsiElement)position, SqlTableColumnsList.class)) != null) {
            List<SqlReferenceExpression> list = SqlImplUtil.getReferenceList(columnsList);
            if (list == null) {
                SqlColumnListCompletionProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        SqlReferenceExpression refExp = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlReferenceExpression.class);
        if (refExp == null || refExp.getParent() == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SqlColumnListCompletionProvider.$$$reportNull$$$0(8);
            }
            return list;
        }
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)refExp.getParent(), SqlReferenceExpression.class);
        if (list == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private static JBIterable<? extends DasColumn> getColumns(@NotNull PsiElement position) {
        SqlTableColumnsList columnsList;
        if (position == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(10);
        }
        if ((columnsList = (SqlTableColumnsList)PsiTreeUtil.getParentOfType((PsiElement)position, SqlTableColumnsList.class)) != null) {
            return SqlColumnListCompletionProvider.getColumnsForTableReference(columnsList.getTableReference());
        }
        return SqlColumnListCompletionProvider.getColumnsForTableReference(SqlColumnListCompletionProvider.getTableReferenceFromMergeStatement(position));
    }

    @Nullable
    private static SqlReferenceExpression getTableReferenceFromMergeStatement(@NotNull PsiElement position) {
        SqlInsertDmlInstructionImpl insert;
        if (position == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(11);
        }
        if ((insert = (SqlInsertDmlInstructionImpl)PsiTreeUtil.getParentOfType((PsiElement)position, SqlInsertDmlInstructionImpl.class)) == null) {
            return null;
        }
        SqlMergeStatement merge2 = (SqlMergeStatement)PsiTreeUtil.getParentOfType((PsiElement)insert, SqlMergeStatement.class);
        if (merge2 == null) {
            return null;
        }
        return (SqlReferenceExpression)SqlImplUtil.sqlTraverser((PsiElement)merge2).filter(SqlReferenceExpression.class).filter(r -> r.getReferenceElementType() == SqlCompositeElementTypes.SQL_TABLE_REFERENCE).first();
    }

    private static boolean isInsertStatement(@NotNull PsiElement position) {
        SqlTableColumnsList columnsList;
        if (position == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(12);
        }
        return (columnsList = (SqlTableColumnsList)PsiTreeUtil.getParentOfType((PsiElement)position, SqlTableColumnsList.class)) != null && columnsList.getParent() instanceof SqlInsertDmlInstruction;
    }

    private static void suggestTableColumnListAtOnce(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx dialect, @NotNull CompletionResultSet result2) {
        List<SqlReferenceExpression> colRefs;
        if (position == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(13);
        }
        if (dialect == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(14);
        }
        if (result2 == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(15);
        }
        if ((colRefs = SqlColumnListCompletionProvider.getReferenceList(position)).size() != 1) {
            return;
        }
        boolean canQualify = SqlCompletionUtil.canQualify((PsiElement)colRefs.get(0));
        boolean lowerPriority = SqlColumnListCompletionProvider.shouldPlaceAfterColumns(position);
        JBIterable columns = SqlColumnListCompletionProvider.getColumns(position);
        Condition notAuto = info2 -> !SqlImplUtil.isAutoVal(info2);
        Condition notComputed = info2 -> !SqlImplUtil.isComputedVal(info2);
        Condition noDefault = info2 -> StringUtil.isEmpty((String)info2.getDefault());
        Project project = position.getProject();
        Dbms dbms = SqlImplUtil.getDbms(position);
        if (SqlColumnListCompletionProvider.isInsertStatement(position)) {
            IdentityInsertPolicy identityInsertPolicy;
            ComputedInsertPolicy computedInsertPolicy = SqlInspectionUtilsKt.getComputedInsertPolicy(dbms);
            if (computedInsertPolicy != ComputedInsertPolicy.ALWAYS) {
                columns = columns.filter(notComputed);
            }
            if ((identityInsertPolicy = SqlInspectionUtilsKt.getIdentityInsertPolicy(dbms)) != IdentityInsertPolicy.ALWAYS && identityInsertPolicy != IdentityInsertPolicy.BY_SET_IDENTITY_INSERT) {
                columns = columns.filter(notAuto);
            }
        }
        if (dialect.getDbms().isMysql()) {
            SqlColumnListCompletionProvider.processMultiColumnVariants(project, dialect, result2, canQualify, lowerPriority, dbms, columns.filter(notComputed).toList(), columns.filter(notAuto).toList(), columns.filter(notAuto).filter(noDefault).toList());
        } else {
            SqlColumnListCompletionProvider.processMultiColumnVariants(project, dialect, result2, canQualify, lowerPriority, dbms, columns.filter(notAuto).toList(), columns.filter(notAuto).filter(noDefault).toList());
        }
    }

    private static boolean shouldPlaceAfterColumns(@NotNull PsiElement position) {
        if (position == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(16);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)position, SqlValuesExpression.class, (boolean)true, (Class[])new Class[]{SqlInsertDmlInstructionImpl.class}) != null || PsiTreeUtil.getParentOfType((PsiElement)position, SqlOnTargetClauseImpl.class, (boolean)true, (Class[])new Class[]{SqlCreateIndexStatement.class}) != null;
    }

    private static void processMultiColumnVariants(@NotNull Project project, @NotNull SqlLanguageDialectEx dialect, @NotNull CompletionResultSet result2, boolean canQualify, boolean lowerPriority, @NotNull Dbms dbms, List<? extends DasColumn> ... multiColumns) {
        if (project == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(17);
        }
        if (dialect == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(18);
        }
        if (result2 == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(19);
        }
        if (dbms == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(20);
        }
        LinkedHashSet sorted = ContainerUtil.newLinkedHashSet((Object[])multiColumns);
        sorted.forEach(c2 -> SqlColumnListCompletionProvider.processColumns(project, dialect, c2, result2, canQualify, lowerPriority, dbms));
    }

    private static void processColumns(@NotNull Project project, @NotNull SqlLanguageDialectEx dialect, @NotNull Iterable<? extends DasColumn> columns, @NotNull CompletionResultSet result2, boolean canQualify, boolean lowerPriority, @NotNull Dbms dbms) {
        LookupElement all2;
        if (project == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(21);
        }
        if (dialect == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(22);
        }
        if (columns == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(23);
        }
        if (result2 == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(24);
        }
        if (dbms == null) {
            SqlColumnListCompletionProvider.$$$reportNull$$$0(25);
        }
        if ((all2 = SqlCompletionUtil.createAllColumnsLookupElement(columns, project, dialect, lowerPriority ? 5 : 149, true, canQualify, ContainerUtil.emptyList(), dbms)) != null) {
            result2.addElement(all2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 15: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/completion/providers/SqlColumnListCompletionProvider";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 14: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/completion/providers/SqlColumnListCompletionProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnsForTableReference";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doAddCompletions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceList";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTableReferenceFromMergeStatement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isInsertStatement";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "suggestTableColumnListAtOnce";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldPlaceAfterColumns";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processMultiColumnVariants";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processColumns";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

