/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.GlobalStrictCredentialManager;
import com.intellij.database.access.LocalCredentialManager;
import com.intellij.database.access.OneTimeCredentialManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseCredentialsUi {
    public static final Executor EXECUTOR = DatabaseCredentialsUi::invokeLater;
    private static final Object ourEDTLock = new Object();
    static final DatabaseCredentials ourStrictInstance = new DatabaseCredentials(GlobalStrictCredentialManager.INSTANCE);

    @NotNull
    public static DialogBuilder prepareDialog(@NotNull Project project, @Nullable Icon icon, @NotNull JComponent component, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.DialogMessage @NotNull String message) {
        if (project == null) {
            DatabaseCredentialsUi.$$$reportNull$$$0(0);
        }
        if (component == null) {
            DatabaseCredentialsUi.$$$reportNull$$$0(1);
        }
        if (title == null) {
            DatabaseCredentialsUi.$$$reportNull$$$0(2);
        }
        if (message == null) {
            DatabaseCredentialsUi.$$$reportNull$$$0(3);
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        JTextPane messageField = Messages.configureMessagePaneUi((JTextPane)new JTextPane(), (String)message, (UIUtil.FontSize)UIUtil.FontSize.SMALL);
        JComponent msgPanel = Messages.wrapToScrollPaneIfNeeded((JComponent)messageField, (int)40, (int)4);
        if (icon != null) {
            msgPanel = JBUI.Panels.simplePanel().addToLeft((Component)((BorderLayoutPanel)JBUI.Panels.simplePanel().withBorder((Border)JBUI.Borders.emptyRight((int)10))).addToTop((Component)new JBLabel(icon))).addToCenter((Component)msgPanel);
        }
        panel2.add((Component)msgPanel, "Center");
        panel2.add((Component)component, "South");
        DialogBuilder builder = new DialogBuilder(project);
        builder.setTitle(title);
        builder.setCenterPanel((JComponent)panel2);
        builder.addOkAction();
        builder.addCancelAction();
        DialogBuilder dialogBuilder = builder;
        if (dialogBuilder == null) {
            DatabaseCredentialsUi.$$$reportNull$$$0(4);
        }
        return dialogBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void invokeLater(@NotNull Runnable r) {
        Application app;
        if (r == null) {
            DatabaseCredentialsUi.$$$reportNull$$$0(5);
        }
        if ((app = ApplicationManager.getApplication()).isDispatchThread()) {
            r.run();
            return;
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        Object object = ourEDTLock;
        synchronized (object) {
            ModalityState modalityState = ModalityState.defaultModalityState();
            if (indicator != null && indicator.isModal()) {
                ModalityUiUtil.invokeLaterIfNeeded((ModalityState)modalityState, (Runnable)r);
            } else {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(r, modalityState);
            }
        }
    }

    public static DatabaseCredentials newUIInstance() {
        return new DatabaseCredentials(new LocalCredentialManager());
    }

    public static DatabaseCredentials newOneTimeInstance(DatabaseCredentials backend) {
        return new DatabaseCredentials(new OneTimeCredentialManager(DatabaseCredentialsUi.strict(backend).getCredentialManager()));
    }

    @NotNull
    public static DatabaseCredentials strict(DatabaseCredentials credentials) {
        DatabaseCredentials databaseCredentials = credentials.getCredentialManager() instanceof LocalCredentialManager ? credentials : ourStrictInstance;
        if (databaseCredentials == null) {
            DatabaseCredentialsUi.$$$reportNull$$$0(6);
        }
        return databaseCredentials;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/access/DatabaseCredentialsUi";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/access/DatabaseCredentialsUi";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareDialog";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "strict";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareDialog";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

