/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt.rc;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.BeforeRunTaskAwareConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.lang.javascript.buildTools.grunt.GruntService;
import com.intellij.lang.javascript.buildTools.grunt.GruntUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileManager;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntConfigurationType;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettings;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunConfigurationEditor;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunProfileState;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Iterator;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntRunConfiguration
extends LocatableConfigurationBase
implements NodeDebugRunConfiguration,
JSRunProfileWithCompileBeforeLaunchOption,
BeforeRunTaskAwareConfiguration {
    private static final Logger LOG = Logger.getInstance(GruntRunConfiguration.class);
    private GruntRunSettings myRunSettings;

    public GruntRunConfiguration(@NotNull Project project, ConfigurationFactory factory, String name) {
        if (project == null) {
            GruntRunConfiguration.$$$reportNull$$$0(0);
        }
        super(project, factory, name);
    }

    public void onNewConfigurationCreated() {
        Iterator<VirtualFile> configuredFileIterator;
        VirtualFile gruntfile;
        GruntRunSettings runSettings = this.getRunSettings();
        if (StringUtil.isEmptyOrSpaces((String)runSettings.getGruntfilePath()) && (gruntfile = (configuredFileIterator = GruntfileManager.getInstance(this.getProject()).getBuildfiles().iterator()).hasNext() ? configuredFileIterator.next() : GruntService.getInstance(this.getProject()).detectFirstBuildfileInContentRoots(false)) != null) {
            this.myRunSettings = GruntRunSettings.builder(runSettings).setGruntfilePath(gruntfile.getPath()).build();
        }
    }

    @NotNull
    public GruntRunSettings getRunSettings() {
        if (this.myRunSettings == null) {
            this.myRunSettings = new GruntRunSettings.Builder().build();
        }
        GruntRunSettings gruntRunSettings = this.myRunSettings;
        if (gruntRunSettings == null) {
            GruntRunConfiguration.$$$reportNull$$$0(1);
        }
        return gruntRunSettings;
    }

    public void setRunSettings(@NotNull GruntRunSettings runSettings) {
        if (runSettings == null) {
            GruntRunConfiguration.$$$reportNull$$$0(2);
        }
        this.myRunSettings = runSettings;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            GruntRunConfiguration.$$$reportNull$$$0(3);
        }
        super.readExternal(element);
        this.myRunSettings = GruntRunSettings.readFromXml(element);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            GruntRunConfiguration.$$$reportNull$$$0(4);
        }
        super.writeExternal(element);
        GruntRunSettings runSettings = this.myRunSettings;
        if (runSettings != null) {
            runSettings.writeToXml(element);
        }
    }

    @Nullable
    private static GruntRunConfiguration getTemplateRunConfiguration(@NotNull Project project) {
        RunManager runManager;
        RunnerAndConfigurationSettings templateSettings;
        RunConfiguration rc;
        if (project == null) {
            GruntRunConfiguration.$$$reportNull$$$0(5);
        }
        if ((rc = (templateSettings = (runManager = RunManager.getInstance((Project)project)).getConfigurationTemplate((ConfigurationFactory)GruntConfigurationType.getInstance())).getConfiguration()) instanceof GruntRunConfiguration) {
            return (GruntRunConfiguration)rc;
        }
        LOG.warn("No Grunt.js template run configuration found: " + String.valueOf(rc));
        return null;
    }

    @NotNull
    public static GruntRunSettings getTemplateRunSettings(@NotNull Project project) {
        GruntRunConfiguration rc;
        if (project == null) {
            GruntRunConfiguration.$$$reportNull$$$0(6);
        }
        if ((rc = GruntRunConfiguration.getTemplateRunConfiguration(project)) != null) {
            GruntRunSettings gruntRunSettings = rc.getRunSettings();
            if (gruntRunSettings == null) {
                GruntRunConfiguration.$$$reportNull$$$0(7);
            }
            return gruntRunSettings;
        }
        GruntRunSettings gruntRunSettings = new GruntRunSettings.Builder().build();
        if (gruntRunSettings == null) {
            GruntRunConfiguration.$$$reportNull$$$0(8);
        }
        return gruntRunSettings;
    }

    public static void setTemplateRunSettings(@NotNull Project project, @NotNull GruntRunSettings runSettings) {
        GruntRunConfiguration rc;
        if (project == null) {
            GruntRunConfiguration.$$$reportNull$$$0(9);
        }
        if (runSettings == null) {
            GruntRunConfiguration.$$$reportNull$$$0(10);
        }
        if ((rc = GruntRunConfiguration.getTemplateRunConfiguration(project)) != null) {
            rc.setRunSettings(runSettings);
        }
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        GruntRunConfiguration.checkRunSettings(this.getProject(), this.myRunSettings);
    }

    public static void checkRunSettings(@NotNull Project project, @NotNull GruntRunSettings settings) throws RuntimeConfigurationError {
        if (project == null) {
            GruntRunConfiguration.$$$reportNull$$$0(11);
        }
        if (settings == null) {
            GruntRunConfiguration.$$$reportNull$$$0(12);
        }
        GruntNonSharedSettings nonSharedSettings = GruntRunConfiguration.getNonSharedSettings(project, settings);
        GruntUtil.checkConfiguration(project, nonSharedSettings, settings);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new GruntRunConfigurationEditor(this.getProject());
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            GruntRunConfiguration.$$$reportNull$$$0(13);
        }
        if (environment == null) {
            GruntRunConfiguration.$$$reportNull$$$0(14);
        }
        return new GruntRunProfileState(environment, this.getRunSettings(), GruntRunConfiguration.getNonSharedSettings(this.getProject(), this.myRunSettings));
    }

    @Override
    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.myRunSettings.getInterpreterRef().resolve(this.getProject());
    }

    @NotNull
    private static GruntNonSharedSettings getNonSharedSettings(@NotNull Project project, @NotNull GruntRunSettings settings) {
        if (project == null) {
            GruntRunConfiguration.$$$reportNull$$$0(15);
        }
        if (settings == null) {
            GruntRunConfiguration.$$$reportNull$$$0(16);
        }
        NodeJsInterpreter interpreter2 = settings.getInterpreterRef().resolve(project);
        GruntNonSharedSettings gruntNonSharedSettings = GruntUtil.getGruntPackage(project, interpreter2, settings.getGruntfile());
        if (gruntNonSharedSettings == null) {
            GruntRunConfiguration.$$$reportNull$$$0(17);
        }
        return gruntNonSharedSettings;
    }

    public boolean useRunExecutor() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 8, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunSettings";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateRunSettings";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonSharedSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 17: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setRunSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateRunConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateRunSettings";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTemplateRunSettings";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkRunSettings";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNonSharedSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 8, 17 -> new IllegalStateException(string);
        };
    }
}

