/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.impl;

import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementInfoImpl;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Replacer {
    private final Project project;
    @NotNull
    private final ReplaceOptions options;
    private final StructuralReplaceHandler replaceHandler;
    private final ReplacementBuilder replacementBuilder;
    private PsiElement lastAffectedElement;

    public Replacer(@NotNull Project project2, @NotNull ReplaceOptions options) {
        if (project2 == null) {
            Replacer.$$$reportNull$$$0(0);
        }
        if (options == null) {
            Replacer.$$$reportNull$$$0(1);
        }
        this.project = project2;
        this.options = options;
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(options.getMatchOptions().getFileType());
        assert (profile != null);
        this.replaceHandler = profile.getReplaceHandler(project2, options);
        assert (this.replaceHandler != null);
        this.replacementBuilder = new ReplacementBuilder(this.project, this.options);
    }

    public static int insertSubstitution(StringBuilder result2, int offset, ParameterInfo info, String image) {
        if (!image.isEmpty()) {
            result2.insert(offset + info.getStartIndex(), image);
            offset += image.length();
        }
        return offset;
    }

    public static String testReplace(String in, String what, String by, ReplaceOptions options, Project project2) {
        return Replacer.testReplace(in, what, by, options, project2, false);
    }

    public static String testReplace(String in, String what, String by, ReplaceOptions options, Project project2, boolean sourceIsFile) {
        LanguageFileType fileType = options.getMatchOptions().getFileType();
        assert (fileType != null);
        return Replacer.testReplace(in, what, by, options, project2, sourceIsFile, false, fileType, fileType.getLanguage());
    }

    public static String testReplace(String in, String what, String by, ReplaceOptions replaceOptions, Project project2, boolean sourceIsFile, boolean createPhysicalFile, @NotNull LanguageFileType sourceFileType, @NotNull Language sourceDialect) {
        if (sourceFileType == null) {
            Replacer.$$$reportNull$$$0(2);
        }
        if (sourceDialect == null) {
            Replacer.$$$reportNull$$$0(3);
        }
        replaceOptions.setReplacement(by);
        MatchOptions matchOptions = replaceOptions.getMatchOptions();
        matchOptions.fillSearchCriteria(what);
        Matcher.validate(project2, matchOptions);
        Replacer.checkReplacementPattern(project2, replaceOptions);
        Replacer replacer = new Replacer(project2, replaceOptions);
        Matcher matcher = new Matcher(project2, matchOptions);
        try {
            PsiElement nextSibling;
            PsiElement parent;
            PsiElement lastElement;
            PsiElement firstElement;
            if (matchOptions.getScope() == null) {
                PsiElement[] elements = MatcherImplUtil.createTreeFromText(in, new PatternContextInfo(sourceIsFile ? PatternTreeContext.File : PatternTreeContext.Block), sourceFileType, sourceDialect, project2, createPhysicalFile);
                firstElement = elements[0];
                lastElement = elements[elements.length - 1];
                parent = firstElement.getParent();
                matchOptions.setScope((SearchScope)new LocalSearchScope(elements));
            } else {
                parent = ((LocalSearchScope)matchOptions.getScope()).getScope()[0];
                firstElement = parent.getFirstChild();
                lastElement = parent.getLastChild();
            }
            CollectingMatchResultSink sink = new CollectingMatchResultSink();
            matcher.testFindMatches(sink);
            SmartList replacements = new SmartList();
            for (MatchResult result2 : sink.getMatches()) {
                replacements.add(replacer.buildReplacement(result2));
            }
            int startOffset = firstElement.getTextRange().getStartOffset();
            int endOffset = sourceIsFile ? 0 : parent.getTextLength() - lastElement.getTextRange().getEndOffset();
            PsiElement prevSibling = firstElement.getPrevSibling();
            if (prevSibling instanceof PsiWhiteSpace) {
                startOffset -= prevSibling.getTextLength();
            }
            if ((nextSibling = lastElement.getNextSibling()) instanceof PsiWhiteSpace) {
                endOffset -= nextSibling.getTextLength();
            }
            replacer.replaceAll((List<? extends ReplacementInfo>)replacements);
            if (firstElement == lastElement && firstElement instanceof PsiFile) {
                String string = firstElement.getText();
                return string;
            }
            String result3 = parent.getText();
            String string = result3.substring(startOffset, result3.length() - endOffset);
            return string;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IncorrectOperationException((Throwable)e);
        }
        finally {
            matchOptions.setScope(null);
        }
    }

    public void replaceAll(List<? extends ReplacementInfo> infos) {
        for (ReplacementInfo replacementInfo : infos) {
            this.replaceHandler.prepare(replacementInfo);
        }
        if (IntentionPreviewUtils.isIntentionPreviewActive()) {
            this.doReplaceAll(infos, (ProgressIndicator)new EmptyProgressIndicator());
        } else {
            ((ApplicationEx)ApplicationManager.getApplication()).runWriteActionWithCancellableProgressInDispatchThread(SSRBundle.message("structural.replace.title", new Object[0]), this.project, null, indicator -> this.doReplaceAll(infos, (ProgressIndicator)indicator));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReplaceAll(@NotNull List<? extends ReplacementInfo> infos, @NotNull ProgressIndicator indicator) {
        if (infos == null) {
            Replacer.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            Replacer.$$$reportNull$$$0(5);
        }
        indicator.setIndeterminate(false);
        try {
            int size = infos.size();
            VirtualFile lastFile = null;
            for (int i = 0; i < size; ++i) {
                indicator.checkCanceled();
                indicator.setFraction((double)((float)(i + 1) / (float)size));
                ReplacementInfo info = infos.get(i);
                PsiElement element = info.getMatch(0);
                if (element == null) continue;
                VirtualFile vFile = element.getContainingFile().getVirtualFile();
                if (vFile != null && !vFile.equals(lastFile)) {
                    indicator.setText2(vFile.getPresentableUrl());
                    lastFile = vFile;
                }
                ProgressManager.getInstance().executeNonCancelableSection(() -> {
                    PsiElement affectedElement = this.doReplace(info);
                    if (affectedElement != this.lastAffectedElement) {
                        if (this.lastAffectedElement != null) {
                            this.reformatAndPostProcess(this.lastAffectedElement);
                        }
                        this.lastAffectedElement = affectedElement;
                    }
                });
            }
        }
        finally {
            ProgressManager.getInstance().executeNonCancelableSection(() -> this.reformatAndPostProcess(this.lastAffectedElement));
        }
    }

    public void replace(@NotNull ReplacementInfo info) {
        if (info == null) {
            Replacer.$$$reportNull$$$0(6);
        }
        this.replaceHandler.prepare(info);
        this.reformatAndPostProcess(this.doReplace(info));
    }

    @Nullable
    private PsiElement doReplace(@NotNull ReplacementInfo info) {
        PsiElement element;
        if (info == null) {
            Replacer.$$$reportNull$$$0(7);
        }
        if ((element = info.getMatch(0)) == null || !element.isWritable() || !element.isValid()) {
            return null;
        }
        PsiElement elementParent = StructuralSearchUtil.getPresentableElement(element).getParent();
        CodeStyleManager.getInstance((Project)this.project).performActionWithFormatterDisabled(() -> this.replaceHandler.replace(info, this.options));
        if (!elementParent.isValid() || !elementParent.isWritable()) {
            return null;
        }
        return elementParent;
    }

    private void reformatAndPostProcess(PsiElement elementParent) {
        if (elementParent == null || !elementParent.isValid()) {
            return;
        }
        PsiFile containingFile = elementParent.getContainingFile();
        this.replaceHandler.postProcess(elementParent, this.options);
        if (containingFile != null && this.options.isToReformatAccordingToStyle()) {
            Document document;
            VirtualFile file = containingFile.getVirtualFile();
            if (file != null && (document = FileDocumentManager.getInstance().getDocument(file)) != null) {
                PsiDocumentManager.getInstance((Project)this.project).commitDocument(document);
            }
            int parentOffset = elementParent.getTextRange().getStartOffset();
            CodeStyleManager.getInstance((Project)this.project).reformatRange((PsiElement)containingFile, parentOffset, parentOffset + elementParent.getTextLength(), true);
        }
    }

    public static void handleComments(PsiElement el, PsiElement replacement, ReplacementInfo replacementInfo) {
        PsiElement firstChild;
        PsiElement lastChild = el.getLastChild();
        if (lastChild instanceof PsiComment && replacementInfo.getVariableName(lastChild) == null && !(replacement.getLastChild() instanceof PsiComment)) {
            PsiElement firstElementAfterStatementEnd = lastChild;
            for (PsiElement curElement = firstElementAfterStatementEnd.getPrevSibling(); curElement != null && (curElement instanceof PsiWhiteSpace || curElement instanceof PsiComment); curElement = curElement.getPrevSibling()) {
                firstElementAfterStatementEnd = curElement;
            }
            replacement.addRangeAfter(firstElementAfterStatementEnd, lastChild, replacement.getLastChild());
        }
        if ((firstChild = el.getFirstChild()) instanceof PsiComment && !(firstChild instanceof PsiDocCommentBase) && replacementInfo.getVariableName(firstChild) == null) {
            PsiElement lastElementBeforeStatementStart = firstChild;
            for (PsiElement curElement = lastElementBeforeStatementStart.getNextSibling(); curElement != null && (curElement instanceof PsiWhiteSpace || curElement instanceof PsiComment); curElement = curElement.getNextSibling()) {
                lastElementBeforeStatementStart = curElement;
            }
            replacement.addRangeBefore(firstChild, lastElementBeforeStatementStart, replacement.getFirstChild());
        }
    }

    public static void checkReplacementPattern(@NotNull Project project2, @NotNull ReplaceOptions options) {
        if (project2 == null) {
            Replacer.$$$reportNull$$$0(8);
        }
        if (options == null) {
            Replacer.$$$reportNull$$$0(9);
        }
        try {
            String search = options.getMatchOptions().getSearchPattern();
            String replacement = options.getReplacement();
            Template searchTemplate = TemplateManager.getInstance((Project)project2).createTemplate("", "", search);
            Template replaceTemplate = TemplateManager.getInstance((Project)project2).createTemplate("", "", replacement);
            int segmentCount = replaceTemplate.getSegmentsCount();
            for (int i = 0; i < segmentCount; ++i) {
                String searchSegmentName;
                int j;
                String replacementSegmentName = replaceTemplate.getSegmentName(i);
                int segmentCount2 = searchTemplate.getSegmentsCount();
                for (j = 0; j < segmentCount2 && !replacementSegmentName.equals(searchSegmentName = searchTemplate.getSegmentName(j)); ++j) {
                    if (!replacementSegmentName.startsWith(searchSegmentName) || replacementSegmentName.charAt(searchSegmentName.length()) != '_') continue;
                    try {
                        Integer.parseInt(replacementSegmentName.substring(searchSegmentName.length() + 1));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (j != segmentCount2) continue;
                ReplacementVariableDefinition definition = options.getVariableDefinition(replacementSegmentName);
                if (definition == null || definition.getScriptCodeConstraint().length() <= 2) {
                    throw new MalformedPatternException(SSRBundle.message("replacement.variable.is.not.defined.message", replacementSegmentName));
                }
                String scriptText = StringUtil.unquoteString((String)definition.getScriptCodeConstraint());
                try {
                    ScriptSupport.buildScript(definition.getName(), scriptText, options.getMatchOptions());
                    continue;
                }
                catch (MalformedPatternException e) {
                    throw new MalformedPatternException(SSRBundle.message("replacement.variable.is.not.valid", replacementSegmentName, e.getLocalizedMessage()));
                }
            }
            LanguageFileType fileType = options.getMatchOptions().getFileType();
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(fileType);
            if (profile != null) {
                ReadAction.run(() -> profile.checkReplacementPattern(project2, options));
            }
        }
        catch (IncorrectOperationException ex) {
            throw new MalformedPatternException(SSRBundle.message("incorrect.pattern.message", new Object[0]));
        }
    }

    @NotNull
    public ReplacementInfo buildReplacement(@NotNull MatchResult result2) {
        if (result2 == null) {
            Replacer.$$$reportNull$$$0(10);
        }
        ReplacementInfoImpl replacementInfo = new ReplacementInfoImpl(result2, this.project);
        LanguageFileType fileType = this.options.getMatchOptions().getFileType();
        assert (fileType != null);
        replacementInfo.setReplacement(this.replacementBuilder.process(result2, replacementInfo, fileType));
        ReplacementInfoImpl replacementInfoImpl = replacementInfo;
        if (replacementInfoImpl == null) {
            Replacer.$$$reportNull$$$0(11);
        }
        return replacementInfoImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceDialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/replace/impl/Replacer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/replace/impl/Replacer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildReplacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "testReplace";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doReplaceAll";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doReplace";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkReplacementPattern";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildReplacement";
                break;
            }
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }
}

