/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.datamodel.svg.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgAttributeSpec;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTextNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimElements;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimNode;
import org.jetbrains.letsPlot.datamodel.svg.util.SvgToString;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u0002\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001c\u0010\u000f\u001a\u00060\fj\u0002`\r2\u0006\u0010\u0002\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001c\u0010\u0011\u001a\u00060\fj\u0002`\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0014\u0010\u0012\u001a\u00060\fj\u0002`\r2\u0006\u0010\u0002\u001a\u00020\u0013H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/datamodel/svg/util/PrebuiltSvgSubtree;", "", "source", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "level", "", "(Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;I)V", "asString", "", "getAsString", "()Ljava/lang/String;", "generateElement", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgElement;", "generateSlimNode", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/slim/SvgSlimNode;", "generateSvgNode", "generateTextNode", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTextNode;", "datamodel"})
public final class PrebuiltSvgSubtree {
    @NotNull
    private final String asString;

    public PrebuiltSvgSubtree(@NotNull SvgNode source, int level) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        StringBuilder buffer = this.generateSvgNode(source, level);
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.asString = string;
    }

    @NotNull
    public final String getAsString() {
        return this.asString;
    }

    private final StringBuilder generateSvgNode(SvgNode source, int level) {
        StringBuilder stringBuilder;
        SvgNode svgNode = source;
        if (svgNode instanceof SvgSlimNode) {
            Intrinsics.checkNotNull((Object)source, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimNode");
            stringBuilder = this.generateSlimNode((SvgSlimNode)((Object)source), level);
        } else if (svgNode instanceof SvgElement) {
            stringBuilder = this.generateElement((SvgElement)source, level);
        } else if (svgNode instanceof SvgTextNode) {
            stringBuilder = this.generateTextNode((SvgTextNode)source);
        } else {
            throw new IllegalStateException("Can't generate dom for svg node " + Reflection.getOrCreateKotlinClass(source.getClass()).getSimpleName());
        }
        return stringBuilder;
    }

    private final StringBuilder generateSlimNode(SvgSlimNode source, int level) {
        StringBuilder buffer = new StringBuilder();
        SvgToString.Companion.crlf(buffer, level);
        buffer.append('<' + source.getElementName());
        for (SvgSlimNode.Attr attr : source.getAttributes()) {
            buffer.append(' ').append(attr.getKey()).append('=').append('\"').append(attr.getValue()).append('\"');
        }
        String string = source.getElementName();
        if (!Intrinsics.areEqual((Object)string, (Object)SvgSlimElements.INSTANCE.getGROUP())) {
            if (((Intrinsics.areEqual((Object)string, (Object)SvgSlimElements.INSTANCE.getLINE()) ? true : Intrinsics.areEqual(string, (Object)SvgSlimElements.INSTANCE.getCIRCLE())) ? true : Intrinsics.areEqual(string, (Object)SvgSlimElements.INSTANCE.getRECT())) ? true : Intrinsics.areEqual(string, (Object)SvgSlimElements.INSTANCE.getPATH())) {
                buffer.append(" />");
                return buffer;
            }
            throw new IllegalStateException("Unsupported slim node " + Reflection.getOrCreateKotlinClass(source.getClass()).getSimpleName() + " '" + source.getElementName() + '\'');
        }
        buffer.append(" >");
        for (SvgSlimNode child : source.getSlimChildren()) {
            buffer.append((CharSequence)this.generateSlimNode(child, level + 1));
        }
        SvgToString.Companion.crlf(buffer, level);
        buffer.append("</g>");
        return buffer;
    }

    private final StringBuilder generateElement(SvgElement source, int level) {
        StringBuilder buffer = new StringBuilder();
        SvgToString.Companion.crlf(buffer, level);
        buffer.append('<' + source.getElementName());
        for (SvgAttributeSpec<?> key : source.getAttributeKeys()) {
            buffer.append(' ').append(key.getName()).append('=').append('\"').append(source.getAttribute(key.getName()).get()).append('\"');
        }
        for (SvgNode child : source.children()) {
            buffer.append((CharSequence)this.generateSvgNode(child, level + 1));
        }
        SvgToString.Companion.crlf(buffer, level);
        buffer.append("</" + source.getElementName() + '>');
        return buffer;
    }

    private final StringBuilder generateTextNode(SvgTextNode source) {
        return new StringBuilder((String)source.textContent().get());
    }
}

