/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbt;

import com.intellij.dbt.DbtUtils;
import com.intellij.dbt.detection.DbtService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/dbt/DbtFileListener;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "<init>", "()V", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "intellij.dbt"})
public final class DbtFileListener
implements AsyncFileListener {
    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        for (VFileEvent vFileEvent : events) {
            ProgressManager.checkCanceled();
            if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem)) continue;
            String fileName = null;
            VirtualFile directory = null;
            if (vFileEvent instanceof VFileCreateEvent) {
                fileName = ((VFileCreateEvent)vFileEvent).getChildName();
                directory = ((VFileCreateEvent)vFileEvent).getParent();
            } else {
                if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                fileName = ((VFileDeleteEvent)vFileEvent).getFile().getName();
                directory = ((VFileDeleteEvent)vFileEvent).getFile().getParent();
            }
            if (!Intrinsics.areEqual((Object)fileName, (Object)"dbt_project.yml")) continue;
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                Module module;
                Intrinsics.checkNotNull((Object)project);
                Project project2 = project;
                ProgressManager.checkCanceled();
                if (ModuleUtilCore.findModuleForFile((VirtualFile)directory, (Project)project2) == null || DbtUtils.Companion.isUnderIgnoredDirectories(directory, module)) continue;
                DbtService dbtService = DbtService.Companion.getInstance(project2);
                if (vFileEvent instanceof VFileCreateEvent) {
                    BuildersKt.launch$default((CoroutineScope)dbtService.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(dbtService, module, directory, null){
                        int label;
                        final /* synthetic */ DbtService $dbtService;
                        final /* synthetic */ Module $module;
                        final /* synthetic */ VirtualFile $directory;
                        {
                            this.$dbtService = $dbtService;
                            this.$module = $module;
                            this.$directory = $directory;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = this.$dbtService.initializeDbtSupport(this.$module, this.$directory, (Continuation<? super Unit>)((Continuation)this));
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    continue;
                }
                if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                BuildersKt.launch$default((CoroutineScope)dbtService.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(dbtService, module, null){
                    int label;
                    final /* synthetic */ DbtService $dbtService;
                    final /* synthetic */ Module $module;
                    {
                        this.$dbtService = $dbtService;
                        this.$module = $module;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.$dbtService.removeDbtSupport(this.$module, (Continuation<? super Unit>)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
        return null;
    }
}

