/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.model.DockerObject;
import java.io.Serializable;
import java.util.Objects;

public class RestartPolicy
extends DockerObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="MaximumRetryCount")
    private Integer maximumRetryCount = 0;
    @JsonProperty(value="Name")
    private String name = "";

    public RestartPolicy() {
    }

    private RestartPolicy(int maximumRetryCount, String name2) {
        Objects.requireNonNull(name2, "name is null");
        this.maximumRetryCount = maximumRetryCount;
        this.name = name2;
    }

    public static RestartPolicy noRestart() {
        return new RestartPolicy();
    }

    public static RestartPolicy alwaysRestart() {
        return new RestartPolicy(0, "always");
    }

    public static RestartPolicy onFailureRestart(int maximumRetryCount) {
        return new RestartPolicy(maximumRetryCount, "on-failure");
    }

    public static RestartPolicy unlessStoppedRestart() {
        return new RestartPolicy(0, "unless-stopped");
    }

    public Integer getMaximumRetryCount() {
        return this.maximumRetryCount;
    }

    public String getName() {
        return this.name;
    }

    public static RestartPolicy parse(String serialized) throws IllegalArgumentException {
        try {
            String[] parts = serialized.split(":");
            String name2 = parts[0];
            if ("no".equals(name2)) {
                return RestartPolicy.noRestart();
            }
            if ("always".equals(name2)) {
                return RestartPolicy.alwaysRestart();
            }
            if ("unless-stopped".equals(name2)) {
                return RestartPolicy.unlessStoppedRestart();
            }
            if ("on-failure".equals(name2)) {
                int count = 0;
                if (parts.length == 2) {
                    count = Integer.parseInt(parts[1]);
                }
                return RestartPolicy.onFailureRestart(count);
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing RestartPolicy '" + serialized + "'");
        }
    }

    public String toString() {
        String result2 = this.name.isEmpty() ? "no" : this.name;
        return this.maximumRetryCount > 0 ? result2 + ":" + this.maximumRetryCount : result2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestartPolicy)) {
            return false;
        }
        RestartPolicy other = (RestartPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maximumRetryCount = this.getMaximumRetryCount();
        Integer other$maximumRetryCount = other.getMaximumRetryCount();
        if (this$maximumRetryCount == null ? other$maximumRetryCount != null : !((Object)this$maximumRetryCount).equals(other$maximumRetryCount)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestartPolicy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Integer $maximumRetryCount = this.getMaximumRetryCount();
        result2 = result2 * 59 + ($maximumRetryCount == null ? 43 : ((Object)$maximumRetryCount).hashCode());
        String $name = this.getName();
        result2 = result2 * 59 + ($name == null ? 43 : $name.hashCode());
        return result2;
    }
}

