/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.impl.ModuleVcsDetector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class DefaultVcsRootPolicy {
    @NotNull
    protected final Project myProject;

    protected DefaultVcsRootPolicy(@NotNull Project project) {
        if (project == null) {
            DefaultVcsRootPolicy.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public static DefaultVcsRootPolicy getInstance(Project project) {
        return (DefaultVcsRootPolicy)project.getService(DefaultVcsRootPolicy.class);
    }

    @NotNull
    public final Collection<VirtualFile> getDefaultVcsRoots() {
        Collection<VirtualFile> collection = this.getDefaultVcsRootsCandidates();
        if (collection == null) {
            DefaultVcsRootPolicy.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    protected abstract Collection<VirtualFile> getDefaultVcsRootsCandidates();

    @Nls
    public String getProjectConfigurationMessage() {
        boolean isDirectoryBased = ProjectKt.isDirectoryBased((Project)this.myProject);
        if (isDirectoryBased) {
            String fileName = ProjectKt.getStateStore((Project)this.myProject).getDirectoryStorePath().getFileName().toString();
            return VcsBundle.message((String)"settings.vcs.mapping.project.description.with.idea.directory", (Object[])new Object[]{fileName});
        }
        return VcsBundle.message((String)"settings.vcs.mapping.project.description", (Object[])new Object[0]);
    }

    protected void scheduleMappedRootsUpdate() {
        ProjectLevelVcsManagerEx vcsManager = ProjectLevelVcsManagerEx.getInstanceEx(this.myProject);
        if (StringUtil.isNotEmpty((String)vcsManager.haveDefaultMapping())) {
            vcsManager.scheduleMappedRootsUpdate();
        }
    }

    protected void scheduleRootsChangeProcessing(Collection<VirtualFile> removed, Collection<VirtualFile> added) {
        ((ModuleVcsDetector)this.myProject.getService(ModuleVcsDetector.class)).scheduleScanForNewContentRoots(removed, added);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/DefaultVcsRootPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/DefaultVcsRootPolicy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultVcsRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

