/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.testing.PyAbstractTestFactory;
import com.jetbrains.python.testing.PythonTestConfigurationType;
import com.jetbrains.python.testing.TestRunnerService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TestRunnerDetector
implements Function<Pair<Module, Collection<VirtualFile>>, TestRunnerService.ServiceState> {
    private static final Logger LOG = Logger.getInstance(TestRunnerDetector.class);

    TestRunnerDetector() {
    }

    public TestRunnerService.ServiceState fun(@NotNull Pair<Module, Collection<VirtualFile>> pair) {
        Module module;
        if (pair == null) {
            TestRunnerDetector.$$$reportNull$$$0(0);
        }
        if ((module = (Module)pair.first).isDisposed()) {
            return null;
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        String testRunner = (String)ReadAction.compute(() -> TestRunnerDetector.detectTestRunnerFromSetupPy(module));
        assert (testRunner != null) : "detectTestRunnerFromSetupPy can't return null";
        if (!testRunner.isEmpty()) {
            LOG.debug("Test runner '" + testRunner + "' was discovered from setup.py in the module '" + module.getName() + "'");
            return new TestRunnerService.ServiceState(testRunner);
        }
        Collection pyFiles = (Collection)pair.second;
        for (VirtualFile file : pyFiles) {
            if (!file.getName().startsWith("test") || (testRunner = (String)ReadAction.compute(() -> TestRunnerDetector.checkImports(file, module))).isEmpty()) continue;
            LOG.debug("Test runner '" + testRunner + "' was detected from imports in the file '" + file.getPath() + "'");
            return new TestRunnerService.ServiceState(testRunner);
        }
        Sdk sdk2 = PythonSdkUtil.findPythonSdk(module);
        if (sdk2 != null && sdk2.getSdkType() instanceof PythonSdkType) {
            PyPackageUtil.refreshAndGetPackagesModally(sdk2);
            List<PyAbstractTestFactory<?>> factories = PythonTestConfigurationType.getInstance().getTypedFactories();
            Optional<PyAbstractTestFactory> factory = factories.stream().filter(o -> o.isFrameworkInstalled(sdk2)).findFirst();
            if (factory.isPresent()) {
                testRunner = factory.get().getId();
            }
        }
        if (!testRunner.isEmpty()) {
            LOG.debug("Test runner '" + testRunner + "' was detected from SDK " + String.valueOf(sdk2));
            return new TestRunnerService.ServiceState(testRunner);
        }
        return null;
    }

    @NotNull
    private static String checkImports(@NotNull VirtualFile file, @NotNull Module module) {
        if (file == null) {
            TestRunnerDetector.$$$reportNull$$$0(1);
        }
        if (module == null) {
            TestRunnerDetector.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file);
        if (psiFile instanceof PyFile) {
            List<PyImportElement> importTargets = ((PyFile)psiFile).getImportTargets();
            for (PyImportElement importElement : importTargets) {
                String runnerId;
                String name2 = importElement.getVisibleName();
                if (name2 == null || (runnerId = TestRunnerDetector.findSdkByPackage(name2)) == null) continue;
                String string = runnerId;
                if (string == null) {
                    TestRunnerDetector.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        return "";
    }

    @Nullable
    @NonNls
    private static String findSdkByPackage(@NotNull String packageToFind) {
        if (packageToFind == null) {
            TestRunnerDetector.$$$reportNull$$$0(4);
        }
        for (PyAbstractTestFactory<?> factory : PythonTestConfigurationType.getInstance().getTypedFactories()) {
            String packageRequired = factory.getPackageRequired();
            if (packageRequired == null || !packageRequired.equals(packageToFind)) continue;
            return factory.getId();
        }
        return null;
    }

    @NotNull
    private static String detectTestRunnerFromSetupPy(@NotNull Module module) {
        PyCallExpression setupCall;
        if (module == null) {
            TestRunnerDetector.$$$reportNull$$$0(5);
        }
        if ((setupCall = PyPackageUtil.findSetupCall(module)) == null) {
            return "";
        }
        for (String argumentName : Arrays.asList("test_loader", "test_suite")) {
            String stringValue;
            String runnerId;
            PyExpression argumentValue = setupCall.getKeywordArgument(argumentName);
            if (!(argumentValue instanceof PyStringLiteralExpression) || (runnerId = TestRunnerDetector.findSdkByPackage(stringValue = ((PyStringLiteralExpression)argumentValue).getStringValue())) == null) continue;
            String string = runnerId;
            if (string == null) {
                TestRunnerDetector.$$$reportNull$$$0(6);
            }
            return string;
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/TestRunnerDetector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageToFind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/TestRunnerDetector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "checkImports";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "detectTestRunnerFromSetupPy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fun";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkImports";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSdkByPackage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "detectTestRunnerFromSetupPy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6 -> new IllegalStateException(string);
        };
    }
}

