/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.terminal.frontend.TerminalInput;
import com.intellij.terminal.frontend.TerminalOutputScrollingModel;
import com.intellij.terminal.frontend.action.TerminalFrontendDataContextUtils;
import com.jediterm.terminal.TerminalOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.SimpleTerminalController;
import org.jetbrains.plugins.terminal.block.TerminalFocusModel;
import org.jetbrains.plugins.terminal.block.TerminalPromotedDumbAwareAction;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputController;
import org.jetbrains.plugins.terminal.block.output.TerminalSelectionController;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptController;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.TerminalModel;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/terminal/frontend/action/TerminalPasteAction;", "Lorg/jetbrains/plugins/terminal/block/TerminalPromotedDumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "pasteIntoPrompt", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "pasteIntoTerminalSession", "doPasteIntoTerminalSession", "output", "Lcom/jediterm/terminal/TerminalOutputStream;", "pasteIntoInput", "input", "Lcom/intellij/terminal/frontend/TerminalInput;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.terminal.frontend"})
public final class TerminalPasteAction
extends TerminalPromotedDumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        block5: {
            TerminalOutputScrollingModel scrollingModel;
            TerminalInput input;
            EditorEx editor;
            block7: {
                block6: {
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Editor editor2 = TerminalDataContextUtils.INSTANCE.getEditor(e);
                        EditorEx editorEx = editor2 instanceof EditorEx ? (EditorEx)editor2 : null;
                        if (editorEx == null) {
                            return;
                        }
                        editor = editorEx;
                        input = TerminalFrontendDataContextUtils.INSTANCE.getTerminalInput(e);
                        if (!TerminalDataContextUtils.INSTANCE.isPromptEditor((Editor)editor)) break block4;
                        this.pasteIntoPrompt(e, e.getDataContext());
                        break block5;
                    }
                    if (!TerminalDataContextUtils.INSTANCE.isAlternateBufferEditor((Editor)editor)) break block6;
                    this.pasteIntoTerminalSession(e);
                    break block5;
                }
                if (!TerminalDataContextUtils.INSTANCE.isOutputEditor((Editor)editor)) break block7;
                Object object = TerminalDataContextUtils.INSTANCE.getTerminalSession(e);
                boolean bl = object != null && (object = ((BlockTerminalSession)object).getModel()) != null ? ((TerminalModel)object).isCommandRunning() : false;
                if (bl) {
                    this.pasteIntoTerminalSession(e);
                } else {
                    this.pasteIntoPrompt(e, null);
                }
                break block5;
            }
            if (input == null) break block5;
            this.pasteIntoInput(input);
            TerminalOutputScrollingModel terminalOutputScrollingModel = scrollingModel = (TerminalOutputScrollingModel)editor.getUserData(TerminalOutputScrollingModel.Companion.getKEY());
            if (terminalOutputScrollingModel != null) {
                terminalOutputScrollingModel.scrollToCursor(true);
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = TerminalDataContextUtils.INSTANCE.getEditor(e);
        e.getPresentation().setEnabledAndVisible(editor != null && (TerminalDataContextUtils.INSTANCE.isPromptEditor(editor) || TerminalDataContextUtils.INSTANCE.isOutputEditor(editor) || TerminalDataContextUtils.INSTANCE.isAlternateBufferEditor(editor) || TerminalDataContextUtils.INSTANCE.isOutputModelEditor(editor) || TerminalDataContextUtils.INSTANCE.isAlternateBufferModelEditor(editor)));
    }

    private final void pasteIntoPrompt(AnActionEvent e, DataContext dataContext) {
        TerminalPromptController terminalPromptController = TerminalDataContextUtils.INSTANCE.getPromptController(e);
        if (terminalPromptController == null) {
            return;
        }
        TerminalPromptController promptController = terminalPromptController;
        TerminalFocusModel terminalFocusModel = TerminalDataContextUtils.INSTANCE.getTerminalFocusModel(e);
        if (terminalFocusModel != null) {
            terminalFocusModel.focusPrompt();
        }
        promptController.performPaste(dataContext);
    }

    private final void pasteIntoTerminalSession(AnActionEvent e) {
        BlockTerminalSession blockTerminalSession = TerminalDataContextUtils.INSTANCE.getTerminalSession(e);
        if (blockTerminalSession == null) {
            throw new IllegalStateException("No TerminalSession in the data context".toString());
        }
        BlockTerminalSession session2 = blockTerminalSession;
        TerminalSelectionController terminalSelectionController = TerminalDataContextUtils.INSTANCE.getSelectionController(e);
        if (terminalSelectionController != null) {
            terminalSelectionController.clearSelection();
        }
        SimpleTerminalController simpleTerminalController = TerminalDataContextUtils.INSTANCE.getSimpleTerminalController(e);
        if (simpleTerminalController != null) {
            simpleTerminalController.clearTextSelection();
        }
        TerminalOutputController terminalOutputController = TerminalDataContextUtils.INSTANCE.getOutputController(e);
        if (terminalOutputController != null) {
            terminalOutputController.scrollToBottom();
        }
        this.doPasteIntoTerminalSession(session2.getTerminalOutputStream());
    }

    private final void doPasteIntoTerminalSession(TerminalOutputStream output) {
        String string = TerminalUiUtilsKt.getClipboardText$default(false, 1, null);
        if (string == null) {
            return;
        }
        String text = string;
        if (((CharSequence)text).length() > 0) {
            output.sendString(text, false);
        }
    }

    private final void pasteIntoInput(TerminalInput input) {
        String string = TerminalUiUtilsKt.getClipboardText$default(false, 1, null);
        if (string == null) {
            return;
        }
        String text = string;
        String sanitizedText = TerminalUiUtilsKt.sanitizeLineSeparators(text);
        input.sendBracketedString(sanitizedText);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }
}

