/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.types;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.types.Command;
import org.openhab.core.types.PrimitiveType;
import org.openhab.core.types.State;

@NonNullByDefault
public class StringType
implements PrimitiveType,
State,
Command {
    public static final StringType EMPTY = new StringType();
    private final String value;

    public StringType() {
        this("");
    }

    public StringType(@Nullable String value) {
        this.value = value != null ? value : "";
    }

    public String toString() {
        return this.toFullString();
    }

    @Override
    public String toFullString() {
        return this.value;
    }

    public static StringType valueOf(@Nullable String value) {
        return new StringType(value);
    }

    @Override
    public String format(String pattern) {
        return String.format(pattern, this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            return obj.equals(this.value);
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringType other = (StringType)obj;
        return Objects.equals(this.value, other.value);
    }
}

