// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package greengrassv2iface provides an interface to enable mocking the AWS IoT Greengrass V2 service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package greengrassv2iface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/greengrassv2"
)

// GreengrassV2API provides an interface to enable mocking the
// greengrassv2.GreengrassV2 service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS IoT Greengrass V2.
//	func myFunc(svc greengrassv2iface.GreengrassV2API) bool {
//	    // Make svc.AssociateServiceRoleToAccount request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := greengrassv2.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockGreengrassV2Client struct {
//	    greengrassv2iface.GreengrassV2API
//	}
//	func (m *mockGreengrassV2Client) AssociateServiceRoleToAccount(input *greengrassv2.AssociateServiceRoleToAccountInput) (*greengrassv2.AssociateServiceRoleToAccountOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockGreengrassV2Client{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type GreengrassV2API interface {
	AssociateServiceRoleToAccount(*greengrassv2.AssociateServiceRoleToAccountInput) (*greengrassv2.AssociateServiceRoleToAccountOutput, error)
	AssociateServiceRoleToAccountWithContext(aws.Context, *greengrassv2.AssociateServiceRoleToAccountInput, ...request.Option) (*greengrassv2.AssociateServiceRoleToAccountOutput, error)
	AssociateServiceRoleToAccountRequest(*greengrassv2.AssociateServiceRoleToAccountInput) (*request.Request, *greengrassv2.AssociateServiceRoleToAccountOutput)

	BatchAssociateClientDeviceWithCoreDevice(*greengrassv2.BatchAssociateClientDeviceWithCoreDeviceInput) (*greengrassv2.BatchAssociateClientDeviceWithCoreDeviceOutput, error)
	BatchAssociateClientDeviceWithCoreDeviceWithContext(aws.Context, *greengrassv2.BatchAssociateClientDeviceWithCoreDeviceInput, ...request.Option) (*greengrassv2.BatchAssociateClientDeviceWithCoreDeviceOutput, error)
	BatchAssociateClientDeviceWithCoreDeviceRequest(*greengrassv2.BatchAssociateClientDeviceWithCoreDeviceInput) (*request.Request, *greengrassv2.BatchAssociateClientDeviceWithCoreDeviceOutput)

	BatchDisassociateClientDeviceFromCoreDevice(*greengrassv2.BatchDisassociateClientDeviceFromCoreDeviceInput) (*greengrassv2.BatchDisassociateClientDeviceFromCoreDeviceOutput, error)
	BatchDisassociateClientDeviceFromCoreDeviceWithContext(aws.Context, *greengrassv2.BatchDisassociateClientDeviceFromCoreDeviceInput, ...request.Option) (*greengrassv2.BatchDisassociateClientDeviceFromCoreDeviceOutput, error)
	BatchDisassociateClientDeviceFromCoreDeviceRequest(*greengrassv2.BatchDisassociateClientDeviceFromCoreDeviceInput) (*request.Request, *greengrassv2.BatchDisassociateClientDeviceFromCoreDeviceOutput)

	CancelDeployment(*greengrassv2.CancelDeploymentInput) (*greengrassv2.CancelDeploymentOutput, error)
	CancelDeploymentWithContext(aws.Context, *greengrassv2.CancelDeploymentInput, ...request.Option) (*greengrassv2.CancelDeploymentOutput, error)
	CancelDeploymentRequest(*greengrassv2.CancelDeploymentInput) (*request.Request, *greengrassv2.CancelDeploymentOutput)

	CreateComponentVersion(*greengrassv2.CreateComponentVersionInput) (*greengrassv2.CreateComponentVersionOutput, error)
	CreateComponentVersionWithContext(aws.Context, *greengrassv2.CreateComponentVersionInput, ...request.Option) (*greengrassv2.CreateComponentVersionOutput, error)
	CreateComponentVersionRequest(*greengrassv2.CreateComponentVersionInput) (*request.Request, *greengrassv2.CreateComponentVersionOutput)

	CreateDeployment(*greengrassv2.CreateDeploymentInput) (*greengrassv2.CreateDeploymentOutput, error)
	CreateDeploymentWithContext(aws.Context, *greengrassv2.CreateDeploymentInput, ...request.Option) (*greengrassv2.CreateDeploymentOutput, error)
	CreateDeploymentRequest(*greengrassv2.CreateDeploymentInput) (*request.Request, *greengrassv2.CreateDeploymentOutput)

	DeleteComponent(*greengrassv2.DeleteComponentInput) (*greengrassv2.DeleteComponentOutput, error)
	DeleteComponentWithContext(aws.Context, *greengrassv2.DeleteComponentInput, ...request.Option) (*greengrassv2.DeleteComponentOutput, error)
	DeleteComponentRequest(*greengrassv2.DeleteComponentInput) (*request.Request, *greengrassv2.DeleteComponentOutput)

	DeleteCoreDevice(*greengrassv2.DeleteCoreDeviceInput) (*greengrassv2.DeleteCoreDeviceOutput, error)
	DeleteCoreDeviceWithContext(aws.Context, *greengrassv2.DeleteCoreDeviceInput, ...request.Option) (*greengrassv2.DeleteCoreDeviceOutput, error)
	DeleteCoreDeviceRequest(*greengrassv2.DeleteCoreDeviceInput) (*request.Request, *greengrassv2.DeleteCoreDeviceOutput)

	DeleteDeployment(*greengrassv2.DeleteDeploymentInput) (*greengrassv2.DeleteDeploymentOutput, error)
	DeleteDeploymentWithContext(aws.Context, *greengrassv2.DeleteDeploymentInput, ...request.Option) (*greengrassv2.DeleteDeploymentOutput, error)
	DeleteDeploymentRequest(*greengrassv2.DeleteDeploymentInput) (*request.Request, *greengrassv2.DeleteDeploymentOutput)

	DescribeComponent(*greengrassv2.DescribeComponentInput) (*greengrassv2.DescribeComponentOutput, error)
	DescribeComponentWithContext(aws.Context, *greengrassv2.DescribeComponentInput, ...request.Option) (*greengrassv2.DescribeComponentOutput, error)
	DescribeComponentRequest(*greengrassv2.DescribeComponentInput) (*request.Request, *greengrassv2.DescribeComponentOutput)

	DisassociateServiceRoleFromAccount(*greengrassv2.DisassociateServiceRoleFromAccountInput) (*greengrassv2.DisassociateServiceRoleFromAccountOutput, error)
	DisassociateServiceRoleFromAccountWithContext(aws.Context, *greengrassv2.DisassociateServiceRoleFromAccountInput, ...request.Option) (*greengrassv2.DisassociateServiceRoleFromAccountOutput, error)
	DisassociateServiceRoleFromAccountRequest(*greengrassv2.DisassociateServiceRoleFromAccountInput) (*request.Request, *greengrassv2.DisassociateServiceRoleFromAccountOutput)

	GetComponent(*greengrassv2.GetComponentInput) (*greengrassv2.GetComponentOutput, error)
	GetComponentWithContext(aws.Context, *greengrassv2.GetComponentInput, ...request.Option) (*greengrassv2.GetComponentOutput, error)
	GetComponentRequest(*greengrassv2.GetComponentInput) (*request.Request, *greengrassv2.GetComponentOutput)

	GetComponentVersionArtifact(*greengrassv2.GetComponentVersionArtifactInput) (*greengrassv2.GetComponentVersionArtifactOutput, error)
	GetComponentVersionArtifactWithContext(aws.Context, *greengrassv2.GetComponentVersionArtifactInput, ...request.Option) (*greengrassv2.GetComponentVersionArtifactOutput, error)
	GetComponentVersionArtifactRequest(*greengrassv2.GetComponentVersionArtifactInput) (*request.Request, *greengrassv2.GetComponentVersionArtifactOutput)

	GetConnectivityInfo(*greengrassv2.GetConnectivityInfoInput) (*greengrassv2.GetConnectivityInfoOutput, error)
	GetConnectivityInfoWithContext(aws.Context, *greengrassv2.GetConnectivityInfoInput, ...request.Option) (*greengrassv2.GetConnectivityInfoOutput, error)
	GetConnectivityInfoRequest(*greengrassv2.GetConnectivityInfoInput) (*request.Request, *greengrassv2.GetConnectivityInfoOutput)

	GetCoreDevice(*greengrassv2.GetCoreDeviceInput) (*greengrassv2.GetCoreDeviceOutput, error)
	GetCoreDeviceWithContext(aws.Context, *greengrassv2.GetCoreDeviceInput, ...request.Option) (*greengrassv2.GetCoreDeviceOutput, error)
	GetCoreDeviceRequest(*greengrassv2.GetCoreDeviceInput) (*request.Request, *greengrassv2.GetCoreDeviceOutput)

	GetDeployment(*greengrassv2.GetDeploymentInput) (*greengrassv2.GetDeploymentOutput, error)
	GetDeploymentWithContext(aws.Context, *greengrassv2.GetDeploymentInput, ...request.Option) (*greengrassv2.GetDeploymentOutput, error)
	GetDeploymentRequest(*greengrassv2.GetDeploymentInput) (*request.Request, *greengrassv2.GetDeploymentOutput)

	GetServiceRoleForAccount(*greengrassv2.GetServiceRoleForAccountInput) (*greengrassv2.GetServiceRoleForAccountOutput, error)
	GetServiceRoleForAccountWithContext(aws.Context, *greengrassv2.GetServiceRoleForAccountInput, ...request.Option) (*greengrassv2.GetServiceRoleForAccountOutput, error)
	GetServiceRoleForAccountRequest(*greengrassv2.GetServiceRoleForAccountInput) (*request.Request, *greengrassv2.GetServiceRoleForAccountOutput)

	ListClientDevicesAssociatedWithCoreDevice(*greengrassv2.ListClientDevicesAssociatedWithCoreDeviceInput) (*greengrassv2.ListClientDevicesAssociatedWithCoreDeviceOutput, error)
	ListClientDevicesAssociatedWithCoreDeviceWithContext(aws.Context, *greengrassv2.ListClientDevicesAssociatedWithCoreDeviceInput, ...request.Option) (*greengrassv2.ListClientDevicesAssociatedWithCoreDeviceOutput, error)
	ListClientDevicesAssociatedWithCoreDeviceRequest(*greengrassv2.ListClientDevicesAssociatedWithCoreDeviceInput) (*request.Request, *greengrassv2.ListClientDevicesAssociatedWithCoreDeviceOutput)

	ListClientDevicesAssociatedWithCoreDevicePages(*greengrassv2.ListClientDevicesAssociatedWithCoreDeviceInput, func(*greengrassv2.ListClientDevicesAssociatedWithCoreDeviceOutput, bool) bool) error
	ListClientDevicesAssociatedWithCoreDevicePagesWithContext(aws.Context, *greengrassv2.ListClientDevicesAssociatedWithCoreDeviceInput, func(*greengrassv2.ListClientDevicesAssociatedWithCoreDeviceOutput, bool) bool, ...request.Option) error

	ListComponentVersions(*greengrassv2.ListComponentVersionsInput) (*greengrassv2.ListComponentVersionsOutput, error)
	ListComponentVersionsWithContext(aws.Context, *greengrassv2.ListComponentVersionsInput, ...request.Option) (*greengrassv2.ListComponentVersionsOutput, error)
	ListComponentVersionsRequest(*greengrassv2.ListComponentVersionsInput) (*request.Request, *greengrassv2.ListComponentVersionsOutput)

	ListComponentVersionsPages(*greengrassv2.ListComponentVersionsInput, func(*greengrassv2.ListComponentVersionsOutput, bool) bool) error
	ListComponentVersionsPagesWithContext(aws.Context, *greengrassv2.ListComponentVersionsInput, func(*greengrassv2.ListComponentVersionsOutput, bool) bool, ...request.Option) error

	ListComponents(*greengrassv2.ListComponentsInput) (*greengrassv2.ListComponentsOutput, error)
	ListComponentsWithContext(aws.Context, *greengrassv2.ListComponentsInput, ...request.Option) (*greengrassv2.ListComponentsOutput, error)
	ListComponentsRequest(*greengrassv2.ListComponentsInput) (*request.Request, *greengrassv2.ListComponentsOutput)

	ListComponentsPages(*greengrassv2.ListComponentsInput, func(*greengrassv2.ListComponentsOutput, bool) bool) error
	ListComponentsPagesWithContext(aws.Context, *greengrassv2.ListComponentsInput, func(*greengrassv2.ListComponentsOutput, bool) bool, ...request.Option) error

	ListCoreDevices(*greengrassv2.ListCoreDevicesInput) (*greengrassv2.ListCoreDevicesOutput, error)
	ListCoreDevicesWithContext(aws.Context, *greengrassv2.ListCoreDevicesInput, ...request.Option) (*greengrassv2.ListCoreDevicesOutput, error)
	ListCoreDevicesRequest(*greengrassv2.ListCoreDevicesInput) (*request.Request, *greengrassv2.ListCoreDevicesOutput)

	ListCoreDevicesPages(*greengrassv2.ListCoreDevicesInput, func(*greengrassv2.ListCoreDevicesOutput, bool) bool) error
	ListCoreDevicesPagesWithContext(aws.Context, *greengrassv2.ListCoreDevicesInput, func(*greengrassv2.ListCoreDevicesOutput, bool) bool, ...request.Option) error

	ListDeployments(*greengrassv2.ListDeploymentsInput) (*greengrassv2.ListDeploymentsOutput, error)
	ListDeploymentsWithContext(aws.Context, *greengrassv2.ListDeploymentsInput, ...request.Option) (*greengrassv2.ListDeploymentsOutput, error)
	ListDeploymentsRequest(*greengrassv2.ListDeploymentsInput) (*request.Request, *greengrassv2.ListDeploymentsOutput)

	ListDeploymentsPages(*greengrassv2.ListDeploymentsInput, func(*greengrassv2.ListDeploymentsOutput, bool) bool) error
	ListDeploymentsPagesWithContext(aws.Context, *greengrassv2.ListDeploymentsInput, func(*greengrassv2.ListDeploymentsOutput, bool) bool, ...request.Option) error

	ListEffectiveDeployments(*greengrassv2.ListEffectiveDeploymentsInput) (*greengrassv2.ListEffectiveDeploymentsOutput, error)
	ListEffectiveDeploymentsWithContext(aws.Context, *greengrassv2.ListEffectiveDeploymentsInput, ...request.Option) (*greengrassv2.ListEffectiveDeploymentsOutput, error)
	ListEffectiveDeploymentsRequest(*greengrassv2.ListEffectiveDeploymentsInput) (*request.Request, *greengrassv2.ListEffectiveDeploymentsOutput)

	ListEffectiveDeploymentsPages(*greengrassv2.ListEffectiveDeploymentsInput, func(*greengrassv2.ListEffectiveDeploymentsOutput, bool) bool) error
	ListEffectiveDeploymentsPagesWithContext(aws.Context, *greengrassv2.ListEffectiveDeploymentsInput, func(*greengrassv2.ListEffectiveDeploymentsOutput, bool) bool, ...request.Option) error

	ListInstalledComponents(*greengrassv2.ListInstalledComponentsInput) (*greengrassv2.ListInstalledComponentsOutput, error)
	ListInstalledComponentsWithContext(aws.Context, *greengrassv2.ListInstalledComponentsInput, ...request.Option) (*greengrassv2.ListInstalledComponentsOutput, error)
	ListInstalledComponentsRequest(*greengrassv2.ListInstalledComponentsInput) (*request.Request, *greengrassv2.ListInstalledComponentsOutput)

	ListInstalledComponentsPages(*greengrassv2.ListInstalledComponentsInput, func(*greengrassv2.ListInstalledComponentsOutput, bool) bool) error
	ListInstalledComponentsPagesWithContext(aws.Context, *greengrassv2.ListInstalledComponentsInput, func(*greengrassv2.ListInstalledComponentsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*greengrassv2.ListTagsForResourceInput) (*greengrassv2.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *greengrassv2.ListTagsForResourceInput, ...request.Option) (*greengrassv2.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*greengrassv2.ListTagsForResourceInput) (*request.Request, *greengrassv2.ListTagsForResourceOutput)

	ResolveComponentCandidates(*greengrassv2.ResolveComponentCandidatesInput) (*greengrassv2.ResolveComponentCandidatesOutput, error)
	ResolveComponentCandidatesWithContext(aws.Context, *greengrassv2.ResolveComponentCandidatesInput, ...request.Option) (*greengrassv2.ResolveComponentCandidatesOutput, error)
	ResolveComponentCandidatesRequest(*greengrassv2.ResolveComponentCandidatesInput) (*request.Request, *greengrassv2.ResolveComponentCandidatesOutput)

	TagResource(*greengrassv2.TagResourceInput) (*greengrassv2.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *greengrassv2.TagResourceInput, ...request.Option) (*greengrassv2.TagResourceOutput, error)
	TagResourceRequest(*greengrassv2.TagResourceInput) (*request.Request, *greengrassv2.TagResourceOutput)

	UntagResource(*greengrassv2.UntagResourceInput) (*greengrassv2.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *greengrassv2.UntagResourceInput, ...request.Option) (*greengrassv2.UntagResourceOutput, error)
	UntagResourceRequest(*greengrassv2.UntagResourceInput) (*request.Request, *greengrassv2.UntagResourceOutput)

	UpdateConnectivityInfo(*greengrassv2.UpdateConnectivityInfoInput) (*greengrassv2.UpdateConnectivityInfoOutput, error)
	UpdateConnectivityInfoWithContext(aws.Context, *greengrassv2.UpdateConnectivityInfoInput, ...request.Option) (*greengrassv2.UpdateConnectivityInfoOutput, error)
	UpdateConnectivityInfoRequest(*greengrassv2.UpdateConnectivityInfoInput) (*request.Request, *greengrassv2.UpdateConnectivityInfoOutput)
}

var _ GreengrassV2API = (*greengrassv2.GreengrassV2)(nil)
