/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.item.internal.fileconverter;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.core.ConfigDescription;
import org.openhab.core.config.core.ConfigDescriptionParameter;
import org.openhab.core.config.core.ConfigDescriptionRegistry;
import org.openhab.core.config.core.ConfigUtil;
import org.openhab.core.items.GroupFunction;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.fileconverter.AbstractItemFileGenerator;
import org.openhab.core.items.fileconverter.ItemFileGenerator;
import org.openhab.core.model.core.ModelRepository;
import org.openhab.core.model.items.ItemModel;
import org.openhab.core.model.items.ItemsFactory;
import org.openhab.core.model.items.ModelBinding;
import org.openhab.core.model.items.ModelGroupFunction;
import org.openhab.core.model.items.ModelGroupItem;
import org.openhab.core.model.items.ModelItem;
import org.openhab.core.model.items.ModelProperty;
import org.openhab.core.types.State;
import org.openhab.core.types.StateDescription;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={ItemFileGenerator.class})
public class DslItemFileConverter
extends AbstractItemFileGenerator {
    private final Logger logger = LoggerFactory.getLogger(DslItemFileConverter.class);
    private final ModelRepository modelRepository;
    private final ConfigDescriptionRegistry configDescriptionRegistry;

    @Activate
    public DslItemFileConverter(@Reference ModelRepository modelRepository, @Reference ConfigDescriptionRegistry configDescriptionRegistry) {
        this.modelRepository = modelRepository;
        this.configDescriptionRegistry = configDescriptionRegistry;
    }

    public String getFileFormatGenerator() {
        return "DSL";
    }

    public synchronized void generateFileFormat(OutputStream out, List<Item> items, Collection<Metadata> metadata, boolean hideDefaultParameters) {
        if (items.isEmpty()) {
            return;
        }
        ItemModel model = ItemsFactory.eINSTANCE.createItemModel();
        for (Item item : items) {
            model.getItems().add((Object)this.buildModelItem(item, this.getChannelLinks(metadata, item.getName()), this.getMetadata(metadata, item.getName()), hideDefaultParameters));
        }
        this.modelRepository.generateSyntaxFromModel(out, "items", (EObject)model);
    }

    private ModelItem buildModelItem(Item item, List<Metadata> channelLinks, List<Metadata> metadata, boolean hideDefaultParameters) {
        ModelBinding binding;
        String namespace;
        String category;
        ModelItem model;
        if (item instanceof GroupItem) {
            GroupItem groupItem = (GroupItem)item;
            ModelGroupItem modelGroup = ItemsFactory.eINSTANCE.createModelGroupItem();
            model = modelGroup;
            Item baseItem = groupItem.getBaseItem();
            if (baseItem != null) {
                modelGroup.setType(baseItem.getType());
                GroupFunction function = groupItem.getFunction();
                if (function != null) {
                    ModelGroupFunction modelFunction = ModelGroupFunction.getByName(function.getClass().getSimpleName().toUpperCase());
                    modelGroup.setFunction(modelFunction);
                    State[] parameters = function.getParameters();
                    int i = 0;
                    while (i < parameters.length) {
                        modelGroup.getArgs().add((Object)parameters[i].toString());
                        ++i;
                    }
                }
            }
        } else {
            model = ItemsFactory.eINSTANCE.createModelNormalItem();
            model.setType(item.getType());
        }
        model.setName(item.getName());
        String label = item.getLabel();
        boolean patternInjected = false;
        String defaultPattern = this.getDefaultStatePattern(item);
        if (label != null && !label.isEmpty()) {
            String patterToInject;
            StateDescription stateDescr = item.getStateDescription();
            String statePattern = stateDescr == null ? null : stateDescr.getPattern();
            String string = patterToInject = statePattern != null && !statePattern.equals(defaultPattern) ? statePattern : null;
            if (patterToInject != null) {
                patternInjected = true;
                model.setLabel("%s [%s]".formatted(label, patterToInject));
            } else {
                model.setLabel(label);
            }
        }
        if ((category = item.getCategory()) != null && !category.isEmpty()) {
            model.setIcon(category);
        }
        for (String group : item.getGroupNames()) {
            model.getGroups().add((Object)group);
        }
        for (String tag : item.getTags().stream().sorted().collect(Collectors.toList())) {
            model.getTags().add((Object)tag);
        }
        for (Metadata md : channelLinks) {
            namespace = md.getUID().getNamespace();
            binding = ItemsFactory.eINSTANCE.createModelBinding();
            binding.setType(namespace);
            binding.setConfiguration(md.getValue());
            for (AbstractItemFileGenerator.ConfigParameter param : this.getConfigurationParameters(md, hideDefaultParameters)) {
                ModelProperty property = this.buildModelProperty(param.name(), param.value());
                if (property != null) {
                    binding.getProperties().add((Object)property);
                    continue;
                }
                this.logger.warn("Item \"{}\": configuration parameter \"{}\" for channel link \"{}\" is ignored because its value type is not supported!", new Object[]{item.getName(), param.name(), md.getValue()});
            }
            model.getBindings().add((Object)binding);
        }
        for (Metadata md : metadata) {
            namespace = md.getUID().getNamespace();
            binding = ItemsFactory.eINSTANCE.createModelBinding();
            binding.setType(namespace);
            binding.setConfiguration(md.getValue());
            String statePattern = null;
            for (AbstractItemFileGenerator.ConfigParameter param : this.getConfigurationParameters(md)) {
                ModelProperty property = this.buildModelProperty(param.name(), param.value());
                if (property != null) {
                    binding.getProperties().add((Object)property);
                } else {
                    this.logger.warn("Item \"{}\": configuration parameter \"{}\" for metadata namespace \"{}\" is ignored because its value type is not supported!", new Object[]{item.getName(), param.name(), namespace});
                }
                if (!"stateDescription".equals(namespace) || !"pattern".equals(param.name())) continue;
                statePattern = param.value().toString();
            }
            if (statePattern != null && binding.getProperties().size() == 1 && (patternInjected || statePattern.equals(defaultPattern))) continue;
            model.getBindings().add((Object)binding);
            if (!patternInjected || statePattern == null) continue;
            model.setLabel(label);
        }
        return model;
    }

    private @Nullable ModelProperty buildModelProperty(String key, Object value) {
        ModelProperty property = ItemsFactory.eINSTANCE.createModelProperty();
        property.setKey(key);
        if (value instanceof List) {
            List list = (List)value;
            if (!list.isEmpty()) {
                for (Object val : list) {
                    if (val instanceof String || val instanceof BigDecimal || val instanceof Boolean) {
                        property.getValue().add(val);
                        continue;
                    }
                    if (val instanceof Double) {
                        Double doubleValue = (Double)val;
                        property.getValue().add((Object)BigDecimal.valueOf(doubleValue));
                        continue;
                    }
                    property = null;
                    break;
                }
            } else {
                property = null;
            }
        } else if (value instanceof String || value instanceof BigDecimal || value instanceof Boolean) {
            property.getValue().add(value);
        } else if (value instanceof Double) {
            Double doubleValue = (Double)value;
            property.getValue().add((Object)BigDecimal.valueOf(doubleValue));
        } else {
            property = null;
        }
        return property;
    }

    private List<AbstractItemFileGenerator.ConfigParameter> getConfigurationParameters(Metadata metadata, boolean hideDefaultParameters) {
        ArrayList<AbstractItemFileGenerator.ConfigParameter> parameters = new ArrayList<AbstractItemFileGenerator.ConfigParameter>();
        HashSet<String> handledNames = new HashSet<String>();
        Map configParameters = metadata.getConfiguration();
        Object profile = configParameters.get("profile");
        List configDescriptionParameter = List.of();
        if (profile instanceof String) {
            String profileStr = (String)profile;
            parameters.add(new AbstractItemFileGenerator.ConfigParameter("profile", (Object)profileStr));
            handledNames.add("profile");
            try {
                ConfigDescription configDesc = this.configDescriptionRegistry.getConfigDescription(new URI("profile:" + profileStr));
                if (configDesc != null) {
                    configDescriptionParameter = configDesc.getParameters();
                }
            }
            catch (URISyntaxException configDesc) {
                // empty catch block
            }
        }
        for (ConfigDescriptionParameter param : configDescriptionParameter) {
            String paramName = param.getName();
            if (handledNames.contains(paramName)) continue;
            Object value = configParameters.get(paramName);
            Object defaultValue = ConfigUtil.getDefaultValueAsCorrectType((ConfigDescriptionParameter)param);
            if (!(value == null || hideDefaultParameters && value.equals(defaultValue))) {
                parameters.add(new AbstractItemFileGenerator.ConfigParameter(paramName, value));
            }
            handledNames.add(paramName);
        }
        for (String paramName : configParameters.keySet().stream().sorted().collect(Collectors.toList())) {
            if (handledNames.contains(paramName)) continue;
            Object value = configParameters.get(paramName);
            if (value != null) {
                parameters.add(new AbstractItemFileGenerator.ConfigParameter(paramName, value));
            }
            handledNames.add(paramName);
        }
        return parameters;
    }
}

