/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal.utils;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.aries.component.dsl.Effect;
import org.slf4j.Logger;

public class LogUtils {
    public static Effect<Object> debugTracking(Logger log, Supplier<String> type) {
        return new Effect(o -> {
            if (log.isDebugEnabled()) {
                log.debug("adding new {}: {}", type.get(), o);
            }
        }, o -> {
            if (log.isDebugEnabled()) {
                log.debug("removed new {}: {}", type.get(), o);
            }
        });
    }

    public static Consumer<Object> ifDebugEnabled(Logger log, Supplier<String> message) {
        return o -> {
            if (log.isDebugEnabled()) {
                log.debug((String)message.get(), o);
            }
        };
    }

    public static Consumer<Object> ifInfoEnabled(Logger log, Supplier<String> message) {
        return o -> {
            if (log.isInfoEnabled()) {
                log.info((String)message.get(), o);
            }
        };
    }

    public static Consumer<Object> ifErrorEnabled(Logger log, Supplier<String> message) {
        return o -> {
            if (log.isErrorEnabled()) {
                log.error((String)message.get(), o);
            }
        };
    }

    public static Consumer<Object> ifErrorEnabled(Logger log, Supplier<String> message, Throwable t) {
        return o -> {
            if (log.isErrorEnabled()) {
                log.error((String)message.get(), o, (Object)t);
            }
        };
    }
}

