/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.cdi;

import aQute.bnd.cdi.BeanDef;
import aQute.bnd.cdi.CDIAnnotationReader;
import aQute.bnd.cdi.Discover;
import aQute.bnd.cdi.ReferenceDef;
import aQute.bnd.component.MergedRequirement;
import aQute.bnd.component.annotations.ReferenceCardinality;
import aQute.bnd.exceptions.FunctionWithException;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Packages;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.bnd.version.Version;
import aQute.lib.strings.Strings;
import aQute.lib.xml.XML;
import aQute.libg.glob.PathSet;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class CDIAnnotations
implements AnalyzerPlugin {
    static final DocumentBuilderFactory dbf = XML.newDocumentBuilderFactory();
    static final XPathFactory xpf = XPathFactory.newInstance();
    private static final Predicate<String> beansResourceFilter = new PathSet("META-INF/beans.xml").matches();

    @Override
    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        Resource beansXml;
        Parameters header = OSGiHeader.parseHeader(analyzer.getProperty("-cdiannotations", "*"));
        if (header.isEmpty()) {
            return false;
        }
        Jar currentJar = analyzer.getJar();
        Attrs attrs = header.get("*");
        if (attrs != null && !attrs.containsKey("discover") && (beansXml = currentJar.getResource("META-INF/beans.xml")) != null) {
            Discover discover = this.findDiscoveryMode(beansXml);
            attrs.put("discover", discover.toString());
        }
        Map discoverPerBCPEntry = analyzer.getBundleClassPath().keySet().stream().filter(path -> !path.equals(".") && !path.equals("/")).map(xva$0 -> Processor.appendPath(xva$0)).filter(path -> currentJar.exists((String)path) || !path.equals("WEB-INF/classes") && !path.endsWith("/WEB-INF/classes") && currentJar.hasDirectory((String)path)).collect(Collectors.toMap(path -> path, FunctionWithException.asFunction(path -> {
            Resource resource = currentJar.getResource((String)path);
            if (resource != null) {
                try (Stream<Resource> resources = Jar.getResources(resource, beansResourceFilter);){
                    Resource beansResource = resources.findFirst().orElse(null);
                    Discover discover = this.findDiscoveryMode(beansResource);
                    return discover;
                }
            }
            Resource beansResource = currentJar.getResource(Processor.appendPath(path, "META-INF/beans.xml"));
            return this.findDiscoveryMode(beansResource);
        }), (u, v) -> u, HashMap::new));
        Instructions instructions = new Instructions(header);
        Packages contained = analyzer.getContained();
        ArrayList<String> names = new ArrayList<String>();
        TreeSet<String> provides = new TreeSet<String>();
        TreeSet<String> requires = new TreeSet<String>();
        block2: for (Clazz c : analyzer.getClassspace().values()) {
            if (c.isModule() || c.isEnum() || c.isAnnotation() || c.isInnerClass() || c.isSynthetic()) continue;
            for (Map.Entry<Instruction, Attrs> entry : instructions.entrySet()) {
                List<BeanDef> definitions;
                Instruction instruction = entry.getKey();
                if (!instruction.matches(c.getFQN())) continue;
                if (instruction.isNegated()) continue block2;
                attrs = entry.getValue();
                String discover = attrs.get("discover");
                EnumSet<Discover> options = EnumSet.noneOf(Discover.class);
                try {
                    Discover.parse(discover, options, this);
                }
                catch (IllegalArgumentException e) {
                    analyzer.error("Unrecognized discover '%s', expected values are %s", discover, EnumSet.allOf(Discover.class));
                }
                analyzer.getBundleClassPathEntry(c).map(discoverPerBCPEntry::get).ifPresent(d -> {
                    options.clear();
                    options.add((Discover)((Object)d));
                });
                if (options.isEmpty()) {
                    options.add(Discover.annotated_by_bean);
                }
                if (options.contains((Object)Discover.none) || (definitions = CDIAnnotationReader.getDefinition(c, analyzer, options)) == null) continue block2;
                names.add(definitions.get((int)0).implementation.getFQN());
                if (!attrs.containsKey("noservicecapabilities")) {
                    for (BeanDef beanDef : definitions) {
                        if (beanDef.service.isEmpty()) continue;
                        int length = beanDef.service.size();
                        Object[] objectClass = new String[length];
                        for (int i = 0; i < length; ++i) {
                            Descriptors.TypeRef tr = beanDef.service.get(i);
                            objectClass[i] = tr.getFQN();
                        }
                        Arrays.sort(objectClass);
                        this.addServiceCapability((String[])objectClass, provides);
                    }
                }
                if (attrs.containsKey("noservicerequirements")) continue block2;
                MergedRequirement serviceReqMerge = new MergedRequirement("osgi.service");
                for (ReferenceDef ref : definitions.get((int)0).references) {
                    this.addServiceRequirement(ref, serviceReqMerge);
                }
                requires.addAll(serviceReqMerge.toStringList());
                continue block2;
            }
        }
        if (!names.isEmpty()) {
            this.addExtenderRequirement(requires, names, CDIAnnotationReader.V1_0);
        }
        this.updateHeader(analyzer, "Require-Capability", requires);
        this.updateHeader(analyzer, "Provide-Capability", provides);
        return false;
    }

    private void addServiceCapability(String[] objectClass, Set<String> provides) {
        if (objectClass.length > 0) {
            Parameters p = new Parameters();
            Attrs a = new Attrs();
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (String oc : objectClass) {
                sb.append(sep).append(oc);
                sep = ",";
            }
            a.put("objectClass:List<String>", sb.toString());
            p.put("osgi.service", a);
            String s = p.toString();
            provides.add(s);
        }
    }

    private void addServiceRequirement(ReferenceDef ref, MergedRequirement requires) {
        String objectClass = ref.service;
        ReferenceCardinality cardinality = ref.cardinality;
        boolean optional = cardinality == ReferenceCardinality.OPTIONAL || cardinality == ReferenceCardinality.MULTIPLE;
        boolean multiple = cardinality == ReferenceCardinality.MULTIPLE || cardinality == ReferenceCardinality.AT_LEAST_ONE;
        String filter = "(objectClass=" + objectClass + ")";
        requires.put(filter, "active", optional, multiple);
    }

    private void addExtenderRequirement(Set<String> requires, List<String> beans, Version version) {
        Version next = version.bumpMajor();
        Parameters p = new Parameters();
        Attrs a = new Attrs();
        a.put("filter:", "\"(&(osgi.extender=osgi.cdi)(version>=" + version + ")(!(version>=" + next + ")))\"");
        a.put("beans:List<String>", String.join((CharSequence)",", beans));
        p.put("osgi.extender", a);
        String s = p.toString();
        requires.add(s);
    }

    private void updateHeader(Analyzer analyzer, String name, TreeSet<String> set) {
        if (!set.isEmpty()) {
            String value = analyzer.getProperty(name);
            if (value != null) {
                Parameters p = OSGiHeader.parseHeader(value);
                for (Map.Entry<String, Attrs> entry : p.entrySet()) {
                    StringBuilder sb = new StringBuilder(entry.getKey());
                    if (entry.getValue() != null) {
                        sb.append(";");
                        entry.getValue().append(sb);
                    }
                    set.add(sb.toString());
                }
            }
            String header = Strings.join(set);
            analyzer.setProperty(name, header);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private Discover findDiscoveryMode(Resource beansResource) throws Exception {
        if (beansResource == null) {
            return Discover.none;
        }
        Document document = this.readXMLResource(beansResource);
        if (!document.hasAttributes() && !document.hasChildNodes()) {
            return Discover.all;
        }
        try {
            XPath xPath = xpf.newXPath();
            XPathExpression discoveryModeExpression = xPath.compile("/beans/@bean-discovery-mode");
            XPathExpression versionExpression = xPath.compile("/beans/@version");
            Object versionResult = versionExpression.evaluate(document, XPathConstants.STRING);
            Version version = Version.valueOf(versionResult.toString());
            if (version.equals(Version.LOWEST) || CDIAnnotationReader.CDI_ARCHIVE_VERSION.compareTo(version) <= 0) {
                try {
                    Object beanDiscoveryMode = discoveryModeExpression.evaluate(document, XPathConstants.STRING);
                    return Discover.parse(beanDiscoveryMode.toString());
                }
                catch (IllegalArgumentException | NullPointerException | XPathExpressionException e) {
                    return Discover.annotated;
                }
            }
            return Discover.all;
        }
        catch (NullPointerException | XPathExpressionException e) {
            return Discover.all;
        }
    }

    private Document readXMLResource(Resource resource) throws Exception {
        Document document;
        block8: {
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputStream is = resource.openInputStream();
            try {
                document = db.parse(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    return db.newDocument();
                }
            }
            is.close();
        }
        return document;
    }
}

