import React from 'react';
import { Security } from './Security';
import { Markdown, Schema, Bindings, Tags, Extensions } from '../../components';
import { useConfig } from '../../contexts';
import { CommonHelpers, SchemaHelpers } from '../../helpers';
export var Server = function (_a) {
    var serverName = _a.serverName, server = _a.server;
    var config = useConfig();
    if (!server) {
        return null;
    }
    var urlVariables = SchemaHelpers.serverVariablesToSchema(server.variables());
    var protocolVersion = server.protocolVersion();
    var security = server.security();
    return (React.createElement("div", { className: "panel-item" },
        React.createElement("div", { className: "panel-item--center px-8" },
            React.createElement("div", { className: "shadow rounded bg-gray-200 p-4 border bg-gray-100" },
                React.createElement("div", null,
                    React.createElement("span", { className: "font-mono text-base" }, server.url()),
                    React.createElement("span", { className: "bg-teal-500 font-bold no-underline text-white uppercase rounded mx-2 px-2 py-1 text-sm" }, protocolVersion
                        ? "".concat(server.protocol(), " ").concat(protocolVersion)
                        : server.protocol()),
                    React.createElement("span", { className: "bg-blue-500 font-bold no-underline text-white uppercase rounded px-2 py-1 text-sm" }, serverName)),
                server.hasDescription() && (React.createElement("div", { className: "mt-2" },
                    React.createElement(Markdown, null, server.description()))),
                urlVariables && (React.createElement("div", { className: "mt-2", id: "".concat(CommonHelpers.getIdentifier("server-".concat(serverName, "-url-variables"), config)) },
                    React.createElement(Schema, { schemaName: "URL Variables", schema: urlVariables, expanded: true }))),
                React.createElement("div", { id: "".concat(CommonHelpers.getIdentifier("server-".concat(serverName, "-security"), config)) },
                    React.createElement(Security, { protocol: server.protocol(), security: security })),
                server.hasBindings() && (React.createElement("div", { className: "mt-2" },
                    React.createElement(Bindings, { name: "Server specific information", bindings: server.bindings() }))),
                React.createElement(Extensions, { name: "Server Extensions", item: server }),
                typeof server.hasTags === 'function' && server.hasTags() && (React.createElement("div", { className: "mt-2" },
                    React.createElement(Tags, { tags: server.tags() }))))),
        React.createElement("div", { className: "panel-item--right" })));
};
//# sourceMappingURL=Server.js.map