var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import React from 'react';
import { Message } from '../Messages/Message';
import { Security } from '../Servers/Security';
import { Href, Markdown, Schema, Bindings, Tags, Extensions, } from '../../components';
import { useConfig } from '../../contexts';
import { CommonHelpers, SchemaHelpers } from '../../helpers';
import { EXTERAL_DOCUMENTATION_TEXT, PUBLISH_LABEL_DEFAULT_TEXT, SUBSCRIBE_LABEL_DEFAULT_TEXT, } from '../../constants';
import { PayloadType } from '../../types';
export var Operation = function (props) {
    var config = useConfig();
    var _a = props.type, type = _a === void 0 ? PayloadType.PUBLISH : _a, operation = props.operation, channelName = props.channelName, channel = props.channel;
    if (!operation || !channel) {
        return null;
    }
    var servers = typeof channel.servers === 'function' && channel.servers();
    var security = typeof operation.security === 'function' && operation.security();
    var parameters = SchemaHelpers.parametersToSchema(channel.parameters());
    return (React.createElement("div", null,
        React.createElement("div", { className: "panel-item--center px-8" },
            React.createElement(OperationInfo, __assign({}, props)),
            servers && servers.length > 0 ? (React.createElement("div", { className: "mt-2 text-sm" },
                React.createElement("p", null, "Available only on servers:"),
                React.createElement("ul", { className: "flex flex-wrap leading-normal" }, servers.map(function (server) { return (React.createElement("li", { className: "inline-block mt-2 mr-2", key: server },
                    React.createElement("a", { href: "#".concat(CommonHelpers.getIdentifier('server-' + server, config)), className: "border border-solid border-blue-300 hover:bg-blue-300 hover:text-blue-600 text-blue-500 font-bold no-underline text-xs rounded px-3 py-1 cursor-pointer" },
                        React.createElement("span", { className: "underline" }, server)))); })))) : null,
            parameters && (React.createElement("div", { className: "mt-2", id: CommonHelpers.getIdentifier("operation-".concat(type, "-").concat(channelName, "-parameters"), config) },
                React.createElement(Schema, { schemaName: "Parameters", schema: parameters, expanded: true }))),
            security && (React.createElement("div", { className: "mt-2", id: CommonHelpers.getIdentifier("operation-".concat(type, "-").concat(channelName, "-security"), config) },
                React.createElement(Security, { security: security, header: "Additional security requirements" }))),
            channel.hasBindings() && (React.createElement("div", { className: "mt-2" },
                React.createElement(Bindings, { name: "Channel specific information", bindings: channel.bindings() }))),
            React.createElement(Extensions, { name: "Channel Extensions", item: channel }),
            operation.hasBindings() && (React.createElement("div", { className: "mt-2" },
                React.createElement(Bindings, { name: "Operation specific information", bindings: operation.bindings() }))),
            React.createElement(Extensions, { name: "Operation Extensions", item: operation }),
            operation.hasTags() && (React.createElement("div", { className: "mt-2" },
                React.createElement(Tags, { tags: operation.tags() })))),
        React.createElement("div", { className: "w-full mt-4", id: CommonHelpers.getIdentifier("operation-".concat(type, "-").concat(channelName, "-message"), config) }, operation.hasMultipleMessages() ? (React.createElement("div", { className: "mt-2" },
            React.createElement("p", { className: "px-8" },
                "Accepts ",
                React.createElement("strong", null, "one of"),
                " the following messages:"),
            React.createElement("ul", null, operation.messages().map(function (msg, idx) { return (React.createElement("li", { className: "mt-4", key: idx },
                React.createElement(Message, { message: msg, index: idx, showExamples: true }))); })))) : (React.createElement("div", { className: "mt-2" },
            React.createElement("p", { className: "px-8" }, "Accepts the following message:"),
            React.createElement("div", { className: "mt-2" },
                React.createElement(Message, { message: operation.message(0), showExamples: true })))))));
};
export var OperationInfo = function (_a) {
    var _b = _a.type, type = _b === void 0 ? PayloadType.PUBLISH : _b, operation = _a.operation, channelName = _a.channelName, channel = _a.channel;
    var config = useConfig();
    var operationSummary = operation.summary();
    var externalDocs = operation.externalDocs();
    var operationId = operation.id();
    return (React.createElement(React.Fragment, null,
        React.createElement("div", { className: "mb-4" },
            React.createElement("h3", null,
                React.createElement("span", { className: "font-mono border uppercase p-1 rounded mr-2 ".concat(type === PayloadType.PUBLISH
                        ? 'border-blue-600 text-blue-500'
                        : 'border-green-600 text-green-600'), title: type }, type === PayloadType.PUBLISH
                    ? config.publishLabel || PUBLISH_LABEL_DEFAULT_TEXT
                    : config.subscribeLabel || SUBSCRIBE_LABEL_DEFAULT_TEXT),
                ' ',
                React.createElement("span", { className: "font-mono text-base" }, channelName))),
        channel.hasDescription() && (React.createElement("div", { className: "mt-2" },
            React.createElement(Markdown, null, channel.description()))),
        operationSummary && (React.createElement("p", { className: "text-gray-600 text-sm mt-2" }, operationSummary)),
        operation.hasDescription() && (React.createElement("div", { className: "mt-2" },
            React.createElement(Markdown, null, operation.description()))),
        externalDocs && (React.createElement("ul", { className: "leading-normal mt-2 mb-4 space-x-2 space-y-2" }, externalDocs && (React.createElement("li", { className: "inline-block" },
            React.createElement(Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: externalDocs.url() },
                React.createElement("span", null, EXTERAL_DOCUMENTATION_TEXT)))))),
        operationId && (React.createElement("div", { className: "border bg-gray-100 rounded px-4 py-2 mt-2" },
            React.createElement("div", { className: "text-sm text-gray-700" },
                "Operation ID",
                React.createElement("span", { className: "border text-orange-600 rounded text-xs ml-2 py-0 px-2" }, operationId))))));
};
//# sourceMappingURL=Operation.js.map