"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schemas = void 0;
var react_1 = __importDefault(require("react"));
var Schema_1 = require("./Schema");
var contexts_1 = require("../../contexts");
var helpers_1 = require("../../helpers");
var constants_1 = require("../../constants");
var Schemas = function () {
    var asyncapi = (0, contexts_1.useSpec)();
    var config = (0, contexts_1.useConfig)();
    var schemas = asyncapi.hasComponents() && asyncapi.components().schemas();
    if (!schemas || Object.keys(schemas).length === 0) {
        return null;
    }
    return (react_1.default.createElement("section", { id: "".concat(helpers_1.CommonHelpers.getIdentifier('schemas', config)), className: "mt-16" },
        react_1.default.createElement("h2", { className: "2xl:w-7/12 text-3xl font-light mb-4 px-8" }, constants_1.SCHEMAS_TEXT),
        react_1.default.createElement("ul", null, Object.entries(schemas).map(function (_a) {
            var schemaName = _a[0], schema = _a[1];
            return (react_1.default.createElement("li", { className: "mb-4", key: schemaName, id: helpers_1.CommonHelpers.getIdentifier("schema-".concat(schemaName), config) },
                react_1.default.createElement(Schema_1.Schema, { schemaName: schemaName, schema: schema })));
        }))));
};
exports.Schemas = Schemas;
//# sourceMappingURL=Schemas.js.map